/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5699;

public class TameMonsterTrigger
extends class_4558<TriggerInstance> {
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, BaseMonster monster, EntityStatsTracker tracker) {
        this.method_22510(player, inst -> inst.matches(player, monster, tracker));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2048> predicate;
        private final int amount;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_45746.optionalFieldOf("predicate").forGetter(TriggerInstance::predicate), (App)class_5699.field_33442.fieldOf("amount").forGetter(TriggerInstance::amount)).apply((Applicative)inst, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2048> predicate, int amount) {
            this.player = player;
            this.predicate = predicate;
            this.amount = amount;
        }

        public static class_175<TriggerInstance> of(int amount) {
            return ((TameMonsterTrigger)((Object)RuneCraftoryCriteria.TAME_MONSTER_TRIGGER.get())).method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.empty(), amount));
        }

        public static class_175<TriggerInstance> of(int amount, class_2048.class_2049 builder) {
            return ((TameMonsterTrigger)((Object)RuneCraftoryCriteria.TAME_MONSTER_TRIGGER.get())).method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(builder.method_8920()), amount));
        }

        public static class_161.class_162 amountOfSteps(class_161.class_162 builder, String key, int amount, boolean boss) {
            for (int i = 0; i < amount; ++i) {
                builder.method_705(key + "_" + i, boss ? TriggerInstance.bossOf(i + 1) : TriggerInstance.of(i + 1));
            }
            return builder;
        }

        public static class_175<TriggerInstance> bossOf(int amount) {
            return ((TameMonsterTrigger)((Object)RuneCraftoryCriteria.TAME_MONSTER_TRIGGER.get())).method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(class_2048.class_2049.method_8916().method_8922(RunecraftoryTags.EntityTypes.BOSS_MONSTERS).method_8920()), amount));
        }

        public boolean matches(class_3222 player, BaseMonster monster, EntityStatsTracker tracker) {
            if (this.predicate.isPresent()) {
                if (!this.predicate.get().method_8914(player, (class_1297)monster)) {
                    return false;
                }
                return tracker.getTameCount(monster.method_5864()) >= this.amount;
            }
            return tracker.getTotalTameCount(false) >= this.amount;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;predicate;amount", "player", "predicate", "amount"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;predicate;amount", "player", "predicate", "amount"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;predicate;amount", "player", "predicate", "amount"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2048> predicate() {
            return this.predicate;
        }

        public int amount() {
            return this.amount;
        }
    }
}

