/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.Random;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class DailyPlayerUpdater {
    private int lastUpdateDay = -1;
    private boolean gaveMonsterItem;
    private boolean ateFood;
    private int bathCounter;
    private final Random random = new Random();
    private long dailyRandomSeed;
    private final PlayerData data;

    public DailyPlayerUpdater(PlayerData data) {
        this.data = data;
    }

    public void tick(class_3222 player) {
        int day;
        if (this.dailyRandomSeed == 0L) {
            this.dailyRandomSeed = player.method_59922().method_43055();
        }
        if (this.lastUpdateDay != (day = WorldUtils.day(player.method_37908()))) {
            this.lastUpdateDay = day;
            this.data.getShippingInv().shipItems(player);
            this.data.refreshShop();
            this.gaveMonsterItem = false;
            this.ateFood = false;
            this.bathCounter = 0;
            this.dailyRandomSeed = player.method_59922().method_43055();
        }
    }

    public void setLastUpdateDay(int lastUpdateDay) {
        this.lastUpdateDay = lastUpdateDay;
    }

    public void onGiveMonsterItem() {
        if (!this.gaveMonsterItem) {
            this.gaveMonsterItem = true;
            LevelCalc.levelSkill(this.data, Skills.TAMING, 4.0f);
        }
    }

    public void onFoodEaten() {
        if (!this.ateFood) {
            this.ateFood = true;
            LevelCalc.levelSkill(this.data, Skills.EATING, 50.0f);
        }
    }

    public int getBathCounter() {
        return this.bathCounter;
    }

    public void increaseBathCounter() {
        ++this.bathCounter;
    }

    public long getDailyRandomSeed() {
        return this.dailyRandomSeed;
    }

    public Random getDailyRandom() {
        this.random.setSeed(this.getDailyRandomSeed());
        return this.random;
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10569("LastUpdateDay", this.lastUpdateDay);
        compound.method_10556("GaveMonsterItem", this.gaveMonsterItem);
        compound.method_10556("AteFood", this.ateFood);
        compound.method_10569("BathCounter", this.bathCounter);
        compound.method_10544("DailyRandomSeed", this.dailyRandomSeed);
        return compound;
    }

    public void read(class_2487 compound) {
        this.lastUpdateDay = compound.method_10550("LastUpdateDay");
        this.gaveMonsterItem = compound.method_10577("GaveMonsterItem");
        this.ateFood = compound.method_10577("AteFood");
        this.bathCounter = compound.method_10550("BathCounter");
        this.dailyRandomSeed = compound.method_10537("DailyRandomSeed");
    }
}

