/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.network.S2CRecipe;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public class RecipeKeeper {
    private final Set<class_2960> unlockedRecipes = new HashSet<class_2960>();

    public void unlockRecipe(class_1657 player, class_8786<?> recipe) {
        this.unlockRecipes(player, Set.of(recipe));
    }

    public void unlockRecipes(class_1657 player, Collection<? extends class_8786<?>> recipes) {
        this.unlockRecipesRes(player, recipes.stream().map(class_8786::comp_1932).toList());
    }

    public void unlockRecipesRes(class_1657 player, Collection<class_2960> recipes) {
        this.unlockedRecipes.addAll(recipes);
        if (player instanceof class_3222) {
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CRecipe(recipes, false), (class_3222)player);
        }
    }

    public void lockRecipe(class_1657 player, class_8786<?> recipe) {
        this.lockRecipes(player, Set.of(recipe));
    }

    public void lockRecipes(class_1657 player, Collection<? extends class_8786<?>> recipes) {
        this.lockRecipesRes(player, recipes.stream().map(class_8786::comp_1932).toList());
    }

    public void lockRecipesRes(class_1657 player, Collection<class_2960> recipes) {
        this.unlockedRecipes.removeAll(recipes);
        if (player instanceof class_3222) {
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CRecipe(recipes, true), (class_3222)player);
        }
    }

    public boolean isUnlocked(class_8786<?> recipe) {
        if (GeneralConfig.recipeSystem.lockIsIgnored()) {
            return true;
        }
        return this.unlockedRecipes.contains(recipe.comp_1932());
    }

    public boolean isUnlockedForCrafting(class_8786<?> recipe) {
        if (GeneralConfig.recipeSystem == GeneralConfig.RecipeSystem.SKILLBLOCKLOCK || GeneralConfig.recipeSystem == GeneralConfig.RecipeSystem.BASEBLOCKLOCK) {
            return this.isUnlocked(recipe);
        }
        return true;
    }

    public Collection<class_2960> unlockedRecipes() {
        return ImmutableSet.copyOf(this.unlockedRecipes);
    }

    public class_2487 save() {
        class_2487 nbt = new class_2487();
        class_2499 recipes = new class_2499();
        this.unlockedRecipes.forEach(res -> recipes.add((Object)class_2519.method_23256((String)res.toString())));
        nbt.method_10566("Unlocked", (class_2520)recipes);
        return nbt;
    }

    public void read(class_2487 nbt) {
        this.unlockedRecipes.clear();
        class_2499 recipes = nbt.method_10554("Unlocked", 8);
        recipes.forEach(inbt -> this.unlockedRecipes.add(class_2960.method_60654((String)inbt.method_10714())));
    }

    public void clientUpdate(Collection<class_2960> recipes) {
        this.unlockedRecipes.clear();
        this.unlockedRecipes.addAll(recipes);
    }
}

