/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class DualBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), Skills.DUAL, 20), 0).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.DUAL_BLADES.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        if (handler.getComboCount() != 5 && handler.getComboCount() != 6 && handler.getComboCount() != 8 && state.isAt("attack")) {
            if (!entity.method_37908().field_9236) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((class_1309)entity, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, handler.getComboCount() == 7 ? 1.0 : 0.0), (double)0.5))).executeAttack();
            }
            DualBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!state.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.1));
                break;
            }
            case 2: {
                if (!state.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.3));
                break;
            }
            case 3: {
                if (!state.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.35));
                break;
            }
            case 4: {
                if (!state.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.4));
                break;
            }
            case 5: {
                CombatUtils.EntityAttack attack;
                if (state.isAt("step")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.applyDelta(dir.method_1021(0.4));
                }
                if ((attack = DualBladeAttack.spinAttack(entity, state, state.getMarker("spin_start", 0), state.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 360.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                break;
            }
            case 6: {
                CombatUtils.EntityAttack attack;
                if (state.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454() - 90.0f));
                    DualBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.applyDelta(dir.method_1021(0.5));
                }
                if (state.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    DualBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if ((attack = DualBladeAttack.spinAttack(entity, state, state.getMarker("spin_start", 0), state.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 360.0f, 0.0f)) != null) {
                    handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
                if ((attack = DualBladeAttack.spinAttack(entity, state, state.getMarker("spin_start", 0), state.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f + 360.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                break;
            }
            case 7: {
                class_243 dir;
                if (state.isAt("leap")) {
                    dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.applyDelta(dir.method_1021(1.7).method_1031(0.0, 0.7, 0.0));
                }
                if (!state.isAt("down")) break;
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(1.0).method_1031(0.0, -0.2, 0.0));
                break;
            }
            case 8: {
                CombatUtils.EntityAttack attack;
                if (state.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454() + 120.0f));
                    DualBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if (state.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    DualBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if (state.isAt("last")) {
                    DualBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.5f);
                }
                if ((attack = DualBladeAttack.spinAttack(entity, state, state.getMarker("spin_start", 0), state.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() - 1440.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
    }

    @Override
    public void onStart(class_1309 entity, WeaponHandler<?> handler) {
        if (handler.getComboCount() != 8 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            LevelCalc.useRP((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), GeneralConfig.dualBladeUltimate, true, 0.0f, false, new Skills[0]);
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, WeaponHandler<?> handler) {
        return handler.getComboCount() == 8;
    }

    @Override
    public float movementReduction(WeaponHandler<?> handler) {
        return GeneralConfig.MOVE_SPEED_ATTACK.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo < 5;
    }
}

