/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class FlashStrikeAttack
extends AttackAction {
    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        double speed = EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.FLASH_STRIKE, speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        class_243 dir;
        handler.store(DataKey.FIXED_LOOK, true);
        if (state.isAt("move_1")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.5).method_1031(0.0, 0.3, 0.0));
            FlashStrikeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_LEAP.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.7f);
        }
        if (state.isAt("move_2")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.7));
        }
        if (state.isAt("move_end")) {
            handler.applyDelta(entity.method_18798().method_1021(0.9));
            handler.store(DataKey.MOVE_DIRECTION, null);
        }
        if (!entity.method_37908().field_9236) {
            if (state.isAt("reset")) {
                handler.resetHitEntityTracker();
            }
            if (state.isPast("attack_start") && !state.isPast("attack_end")) {
                double range = Math.max(0.0, CombatUtils.getRange(entity, -1.0));
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1009(1.0, 0.0, 0.0).method_1012(0.0, 0.0, range))).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.FLASH_STRIKE)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.2f)).executeAttack());
            }
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, WeaponHandler<?> handler) {
        return true;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

