/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class GustAttack
extends AttackAction {
    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        double speed = EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.GUST, speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        handler.store(DataKey.FIXED_LOOK, true);
        if (state.isAt("jump")) {
            class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.applyDelta(dir.method_1021(2.0).method_1031(0.0, 0.5, 0.0));
            GustAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.2f);
        }
        if (state.isAt("attack")) {
            if (!entity.method_37908().field_9236) {
                double range = CombatUtils.getRange(entity, 0.0);
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1009(2.0, 0.0, 0.0).method_1012(0.0, 0.0, range))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.GUST)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 1.1f)).executeAttack());
            }
            GustAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
        handler.store(DataKey.FIXED_LOOK, true);
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, WeaponHandler<?> handler) {
        return true;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

