/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class HammerAxeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), Skills.HAMMERAXE, 20), 0).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.HAMMER_AXE.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        if (state.isAt("attack") && handler.getComboCount() != 3) {
            CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((class_1309)entity, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, 0.0), (double)0.5))).executeAttack();
            HammerAxeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_HEAVY.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 0.8f);
        }
        if (handler.getComboCount() == 3) {
            if (state.isAt("spin_start")) {
                handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
                handler.resetHitEntityTracker();
                HammerAxeAttack.playSound((class_1297)entity, class_3417.field_14550, 0.7f, 0.5f);
            }
            if (state.isAt("reset")) {
                handler.resetHitEntityTracker();
                HammerAxeAttack.playSound((class_1297)entity, class_3417.field_14550, 1.0f, 0.7f);
            }
            if (state.isPast("spin_start") && !state.isPast("spin_end")) {
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                if (state.isAt("spin_start")) {
                    handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.4).method_1031(0.0, 0.15, 0.0));
                }
                if (state.isAt("spin_middle")) {
                    handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.4).method_1031(0.0, -0.15, 0.0));
                }
                entity.method_38785();
                if (!entity.method_37908().field_9236) {
                    handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1009(1.0, 1.0, Math.max(1.0, CombatUtils.getRange(entity, -1.0))))).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).withAttackSound(class_3417.field_14840).executeAttack());
                }
            } else {
                handler.store(DataKey.MOVE_DIRECTION, null);
            }
            handler.store(DataKey.FIXED_LOOK, state.isPast("spin_start") && !state.isPast("spin_end"));
        }
    }

    @Override
    public void onStart(class_1309 entity, WeaponHandler<?> handler) {
        if (handler.getComboCount() == 3 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            LevelCalc.useRP((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), GeneralConfig.hammerAxeUltimate, true, 0.0f, false, new Skills[0]);
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, WeaponHandler<?> handler) {
        return handler.getComboCount() == 3;
    }

    @Override
    public float movementReduction(WeaponHandler<?> handler) {
        return GeneralConfig.MOVE_SPEED_ATTACK.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo != 3;
    }
}

