/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class NaiveBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.matches(state -> state.isPast("prepared"))).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        if (comboIdx == 1) {
            return AttackAction.create(PlayerModelAnimations.NAIVE_BLADE_SUCCESS, speed);
        }
        return AttackAction.create(PlayerModelAnimations.NAIVE_BLADE, speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        if (handler.getComboCount() == 2) {
            if (state.isAt("jump")) {
                handler.applyDelta(new class_243(0.0, 0.37, 0.0));
            }
            if (state.isAt("attack_1")) {
                NaiveBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                if (!entity.method_37908().field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.circleTargets(entity.method_36454() - 150.0f, entity.method_36454() + 150.0f, 0.0f)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.NAIVE_BLADE)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.3f)).executeAttack();
                    if (entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        player.method_7263();
                    }
                }
            }
            if (state.isAt("attack_2")) {
                NaiveBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                if (!entity.method_37908().field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, 3.0, 0.0, false)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.NAIVE_BLADE)).executeAttack();
                }
            }
        } else if (state.isAt("prepared")) {
            NaiveBladeAttack.playSound((class_1297)entity, class_3417.field_24063, 1.5f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void onStart(class_1309 entity, WeaponHandler<?> handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            NaiveBladeAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.SPELL_NAIVE_BLADE.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, WeaponHandler<?> handler) {
        return handler.getComboCount() == 2;
    }

    public static boolean canCounter(WeaponHandler<?> handler) {
        return handler.getCurrentAction() instanceof NaiveBladeAttack && handler.getComboCount() == 1 && handler.matches(state -> state.isPast("prepared"));
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

