/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class RushAttack
extends AttackAction {
    private final ComboContainer combo;

    public RushAttack() {
        Predicate<WeaponHandler<?>> MAIN = handler -> handler.matches(state -> state.isPast("chain_1_start") && !state.isPast("chain_1_end") || state.isPast("chain_2_start") && !state.isPast("chain_2_end"));
        Function<Integer, ComboContainer.ComboGetter> IDX = idx -> handler -> !handler.matches(state -> state.isPast("chain_1_end")) ? idx : 6;
        this.combo = ComboContainer.Builder.builder().addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(new ComboContainer.ComboHandler.Builder(MAIN).advanceTo(IDX)).addCombo(handler -> handler.matches(state -> state.isPast("chain_2_start") && !state.isPast("chain_2_end")), 0).build();
    }

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        comboIdx = comboIdx < 6 ? 0 : 1;
        return AttackAction.create(PlayerModelAnimations.RUSH_ATTACK.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        if (handler.getComboCount() == 7) {
            if (state.isAt("leap")) {
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(1.7).method_1031(0.0, -0.4, 0.0));
            }
            if (state.isAt("attack_start")) {
                RushAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
            }
            entity.field_6017 = 0.0f;
            if (!entity.method_37908().field_9236 && state.isPast("attack_start") && !state.isPast("attack_end")) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, CombatUtils.getWidth(entity, 1.5), -1.0, false)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.RUSH_ATTACK)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 0.8f)).executeAttack());
            }
        } else {
            class_243 dir;
            if (state.isAt("step")) {
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.3));
            }
            if (state.isAt("jump")) {
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.5).method_1031(0.0, 0.6, 0.0));
                entity.method_6092(new class_1293(class_1294.field_5906, 12, 2, true, false, false));
            }
            entity.field_6017 = 0.0f;
            if (state.isAt("attack")) {
                if (!entity.method_37908().field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, CombatUtils.getWidth(entity, 0.5), 0.5, false)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.RUSH_ATTACK)).executeAttack();
                }
                RushAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public void onSetup(class_1309 entity, WeaponHandler<?> handler) {
        if (handler.getComboCount() < 7 && handler.matches(state -> state.isPast("chain_2_start"))) {
            handler.setComboCount(6);
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

