/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpearBase;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class SpearUseAttack
extends AttackAction {
    private final ComboContainer combo;

    public SpearUseAttack() {
        Predicate<WeaponHandler<?>> MAIN = handler -> handler.matches(state -> state.isPast("attack") && !state.isPast("end_continue"));
        ComboContainer.Builder builder = ComboContainer.Builder.builder();
        for (int i = 0; i < 20; ++i) {
            builder.addCombo(MAIN);
        }
        this.combo = builder.build();
    }

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        if (comboIdx > 0) {
            AnimationDefinition definition = PlayerModelAnimations.ANIMS.get(PlayerModelAnimations.SPEAR_USE);
            double offset = definition.marker("chain_offset", 0) * 20.0;
            return AnimationState.create((AnimationDefinition)definition, (int)0, (int)-1, (double)offset, (double)speed);
        }
        return AttackAction.create(PlayerModelAnimations.SPEAR_USE, speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof ItemSpearBase) {
                ItemSpearBase spear = (ItemSpearBase)class_17922;
                if (state.isAt("attack")) {
                    spear.useSpear(serverPlayer, stack, false);
                }
                if (state.isAt("final")) {
                    spear.useSpear(serverPlayer, stack, true);
                }
            }
        }
    }

    @Override
    public boolean disableItemSwitch() {
        return false;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }
}

