/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class StormAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 0).addCombo(ComboContainer.past("done"), 0).addCombo(ComboContainer.past("done"), 0).addCombo(ComboContainer.past("done"), 0).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.STORM.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, WeaponHandler<?> handler, AnimationState state) {
        if (state.isAt("attack") && handler.getComboCount() != 5) {
            if (!entity.method_37908().field_9236) {
                double range = CombatUtils.getRange(entity, 0.0) * 0.5;
                if (handler.getComboCount() == 3) {
                    range *= 2.0;
                }
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(entity.method_36454(), 0.0f, range, 0.5, false)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.STORM)).executeAttack();
            }
            StormAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!state.isAt("move")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.3).method_1031(0.0, 0.1, 0.0));
                break;
            }
            case 2: {
                if (!state.isAt("move")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.35));
                break;
            }
            case 3: {
                if (!state.isAt("move")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.2));
                break;
            }
            case 4: {
                if (state.isAt("up")) {
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.applyDelta(dir.method_1021(0.2).method_1031(0.0, 0.05, 0.0));
                }
                if (!state.isAt("down")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.applyDelta(dir.method_1021(0.2).method_1031(0.0, -0.05, 0.0));
                break;
            }
            case 5: {
                if (state.isAt("up")) {
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.applyDelta(dir.method_1021(0.25).method_1031(0.0, 0.15, 0.0));
                }
                if (state.isAt("down")) {
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.applyDelta(dir.method_1021(0.3).method_1031(0.0, -0.35, 0.0));
                }
                entity.field_6017 = 0.0f;
                if (!state.isAt("attack")) break;
                if (!entity.method_37908().field_9236) {
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1009(1.0, 0.5, 0.0).method_1012(0.0, -1.0, CombatUtils.getRange(entity, 0.0)))).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.STORM)).doOnSuccess(target -> CombatUtils.knockBackEntity(entity, target, 1.1f)).executeAttack();
                }
                StormAttack.playSound((class_1297)entity, (class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public void onStart(class_1309 entity, WeaponHandler<?> handler) {
        super.onStart(entity, handler);
        handler.store(DataKey.GRAVITY, entity.method_5740());
        entity.method_5875(true);
    }

    @Override
    public void onEnd(class_1309 entity, WeaponHandler<?> handler) {
        handler.clearWith(DataKey.GRAVITY, arg_0 -> ((class_1309)entity).method_5875(arg_0));
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

