/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.LazyResolvedRegistryEntry;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class GiantCropBlock
extends ExtendedCropBlock {
    public static final MapCodec<GiantCropBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)GiantCropBlock.method_54096(), (App)LazyResolvedRegistryEntry.codec(class_7924.field_41197).fieldOf("crop").forGetter(d -> d.crop), (App)LazyResolvedRegistryEntry.codec(class_7924.field_41197).fieldOf("seed").forGetter(d -> d.seed), (App)Codec.BOOL.fieldOf("small").forGetter(d -> d.small)).apply((Applicative)inst, GiantCropBlock::new));
    public static final class_2758 AGE = class_2741.field_12521;
    public static final class_2754<class_2760> HALF = class_2741.field_12518;
    public static final class_2754<class_2350> DIRECTION = class_2741.field_12481;
    protected static final List<Pair<class_2338, class_2350>> CROP_POSITION = List.of(Pair.of((Object)new class_2338(0, 0, 0), (Object)class_2350.field_11043), Pair.of((Object)new class_2338(0, 1, 0), (Object)class_2350.field_11043), Pair.of((Object)new class_2338(0, 0, -1), (Object)class_2350.field_11039), Pair.of((Object)new class_2338(0, 1, -1), (Object)class_2350.field_11039), Pair.of((Object)new class_2338(-1, 0, 0), (Object)class_2350.field_11034), Pair.of((Object)new class_2338(-1, 1, 0), (Object)class_2350.field_11034), Pair.of((Object)new class_2338(-1, 0, -1), (Object)class_2350.field_11035), Pair.of((Object)new class_2338(-1, 1, -1), (Object)class_2350.field_11035));
    private static final class_265[] SHAPE_BOTTOM = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0)});
    private static final class_265[] SHAPE_TOP = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0)});
    private static final class_265[] SHAPE_TOP_LESS = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)5.0, (double)12.0)});
    private final boolean small;

    public GiantCropBlock(class_4970.class_2251 prop, class_5321<class_1792> giant, class_5321<class_1792> seed) {
        this(prop, giant, seed, false);
    }

    public GiantCropBlock(class_4970.class_2251 prop, class_5321<class_1792> giant, class_5321<class_1792> seed, boolean small) {
        super(prop, giant, seed);
        this.small = small;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(DIRECTION, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2760.field_12617));
    }

    private GiantCropBlock(class_4970.class_2251 prop, LazyResolvedRegistryEntry<class_1792> crop, LazyResolvedRegistryEntry<class_1792> seed, boolean small) {
        this(prop, crop.getKey(), seed.getKey(), small);
    }

    public MapCodec<GiantCropBlock> method_53969() {
        return CODEC;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (state.method_11654(HALF) == class_2760.field_12619) {
            if (this.small) {
                return SHAPE_TOP_LESS[((class_2350)state.method_11654(DIRECTION)).method_10161()];
            }
            return SHAPE_TOP[((class_2350)state.method_11654(DIRECTION)).method_10161()];
        }
        return SHAPE_BOTTOM[((class_2350)state.method_11654(DIRECTION)).method_10161()];
    }

    @Override
    public class_2758 method_9824() {
        return AGE;
    }

    @Override
    public int method_9827() {
        return 1;
    }

    protected boolean method_9695(class_2680 state, class_1922 level, class_2338 pos) {
        return state.method_27852((class_2248)this) && state.method_11654(HALF) == class_2760.field_12617 || super.method_9695(state, level, pos);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        class_2760 half;
        class_2350 fromHalf;
        class_2350 dir = (class_2350)state.method_11654(DIRECTION);
        if (direction == dir) {
            if (!neighborState.method_27852((class_2248)this) || ((class_2350)neighborState.method_11654(DIRECTION)).method_10170() != dir) {
                return class_2246.field_10124.method_9564();
            }
            int neightborAge = (Integer)neighborState.method_11654((class_2769)AGE);
            if (neightborAge != (Integer)state.method_11654((class_2769)AGE)) {
                return (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(neightborAge));
            }
        }
        class_2350 class_23502 = fromHalf = (half = (class_2760)state.method_11654(HALF)) == class_2760.field_12617 ? class_2350.field_11036 : class_2350.field_11033;
        if (fromHalf == direction) {
            if (!neighborState.method_27852((class_2248)this) || neighborState.method_11654(HALF) != (half == class_2760.field_12617 ? class_2760.field_12619 : class_2760.field_12617)) {
                return class_2246.field_10124.method_9564();
            }
            int neightborAge = (Integer)neighborState.method_11654((class_2769)AGE);
            if (neightborAge != (Integer)state.method_11654((class_2769)AGE)) {
                return (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(neightborAge));
            }
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.field_9236 && player.method_7337() && (state.method_11654(DIRECTION) != class_2350.field_11043 || state.method_11654(HALF) != class_2760.field_12617)) {
            ArrayList<Pair> positions = new ArrayList<Pair>();
            AtomicReference first = new AtomicReference();
            this.applyToCrop(level, pos, state, (p, s) -> {
                if (!p.equals((Object)pos)) {
                    if (s.method_11654(DIRECTION) == class_2350.field_11043 && s.method_11654(HALF) == class_2760.field_12617) {
                        first.set(Pair.of((Object)p, (Object)s));
                    } else {
                        positions.add(Pair.of((Object)p, (Object)s));
                    }
                }
            });
            if (first.get() != null) {
                positions.addFirst((Pair)first.get());
            }
            positions.forEach(p -> {
                level.method_8652((class_2338)p.getFirst(), class_2246.field_10124.method_9564(), 35);
                level.method_8444(player, 2001, (class_2338)p.getFirst(), class_2248.method_9507((class_2680)((class_2680)p.getSecond())));
            });
        }
        return super.method_9576(level, pos, state, player);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE}).method_11667(new class_2769[]{ExtendedCropBlock.WILTED}).method_11667(new class_2769[]{DIRECTION}).method_11667(new class_2769[]{HALF});
    }

    @Override
    public int getGiantAge() {
        return 0;
    }

    @Override
    public class_2680 runecraftory$getGrowableStateForAge(class_2680 current, int age) {
        return (class_2680)current.method_11657((class_2769)this.method_9824(), (Comparable)Integer.valueOf(age));
    }

    @Override
    public void onWither(int amount, class_1937 level, class_2680 state, class_2338 pos) {
        this.applyToCrop(level, pos, state, (p, s) -> super.onWither(amount, level, (class_2680)s, (class_2338)p));
    }

    @Override
    public void onWater(class_1937 level, class_2338 pos, class_2680 state) {
        this.applyToCrop(level, pos, state, (p, s) -> {
            super.onWater(level, (class_2338)p, (class_2680)s);
            class_2338 belowPos = p.method_10074();
            class_2680 below = level.method_8320(belowPos);
            if (below.method_28498((class_2769)class_2344.field_11009)) {
                level.method_8652(belowPos, (class_2680)below.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(7)), 3);
            }
        });
    }

    @Override
    public boolean canGrow(class_3218 level, class_2338 pos, class_2680 state) {
        return state.method_11654(HALF) == class_2760.field_12617 && state.method_11654(DIRECTION) == class_2350.field_11043 && !this.runecraftory$isAtMaxAge(state);
    }

    @Override
    public class_2338 getCropPosition(class_1937 level, class_2338 pos, class_2680 state) {
        class_2680 target;
        class_2338.class_2339 newPos = pos.method_25503();
        for (class_2350 dir = (class_2350)state.method_11654(DIRECTION); dir != class_2350.field_11043; dir = dir.method_10160()) {
            newPos.method_10098(dir);
        }
        if (state.method_11654(HALF) == class_2760.field_12619) {
            newPos.method_10100(0, -1, 0);
        }
        if (!(target = level.method_8320((class_2338)newPos)).method_27852((class_2248)this)) {
            return pos;
        }
        return newPos.method_10062();
    }

    private void applyToCrop(class_1937 level, class_2338 start, class_2680 current, BiConsumer<class_2338, class_2680> apply) {
        class_2338.class_2339 mut = start.method_25503();
        class_2350 dir = (class_2350)current.method_11654(DIRECTION);
        class_2760 half = (class_2760)current.method_11654(HALF);
        if (half == class_2760.field_12619) {
            start = start.method_10074();
        }
        class_2470 rot = EntityUtils.fromDirection(dir);
        for (Pair<class_2338, class_2350> pos : CROP_POSITION) {
            class_2350 blockDir;
            class_2338 rotated = ((class_2338)pos.getFirst()).method_10070(rot);
            mut.method_35831((class_2382)start, (class_2382)rotated);
            class_2680 blockAt = level.method_8320((class_2338)mut);
            if (!blockAt.method_27852((class_2248)this) || (blockDir = (class_2350)blockAt.method_11654(DIRECTION)) != rot.method_10503((class_2350)pos.getSecond()) || blockAt.method_11654(HALF) != (((class_2338)pos.getFirst()).method_10264() == 1 ? class_2760.field_12619 : class_2760.field_12617)) continue;
            apply.accept(mut.method_10062(), blockAt);
        }
    }

    public boolean isGiantOf(class_2680 current, class_2680 newState) {
        if (current.method_27852(newState.method_26204())) {
            return false;
        }
        CropProperties prop = DataPackHandler.INSTANCE.cropManager().get(current.method_26204());
        return prop != null && prop.getGiantVersion().map(b -> b == this).orElse(false) != false;
    }
}

