/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.common.blocks.BossSpawnerBlock;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class BossSpawnerBlockEntity
extends class_2586 {
    private int lastUpdateDay = -1;
    private int ticker;
    private class_2960 spawnListId;
    private StructureBossManager.BossSpawnList spawnList;
    private class_1299<?> nextSpawn;

    public BossSpawnerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)RuneCraftoryBlocks.BOSS_SPAWNER_TILE.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, BossSpawnerBlockEntity blockEntity) {
        ++blockEntity.ticker;
        if (blockEntity.ticker % 5 != 0) {
            return;
        }
        class_243 pos = class_243.method_24953((class_2382)blockPos.method_10086(2));
        List<class_3222> nearby = LevelCalc.playersAround((class_1924)level, pos, 20.0);
        if (blockEntity.nextSpawn == null) {
            blockEntity.updateEntity();
        }
        if (!nearby.isEmpty() && blockEntity.nextSpawn != null) {
            boolean flag;
            EntityProperties prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(blockEntity.nextSpawn);
            boolean canSpawn = false;
            if (prop.spawnerPredicate().isPresent()) {
                ArrayList<class_3222> removed = new ArrayList<class_3222>();
                for (class_3222 player : nearby) {
                    if (!prop.spawnerPredicate().get().method_8914(player, (class_1297)player)) {
                        removed.add(player);
                        if (!player.method_19538().method_24802((class_2374)pos, 16.0)) continue;
                        class_243 opposite = player.method_19538().method_1020(pos).method_1029();
                        player.field_6017 = 0.0f;
                        player.method_18799(opposite);
                        player.method_7353((class_2561)class_2561.method_43471((String)"runecraftory.misc.spawner.entry.deny").method_27692(class_124.field_1064), true);
                        player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                        continue;
                    }
                    if (!player.method_19538().method_24802((class_2374)pos, 10.0)) continue;
                    canSpawn = true;
                }
                nearby.removeAll(removed);
            } else {
                canSpawn = true;
            }
            boolean bl = flag = blockEntity.lastUpdateDay != WorldUtils.day(level);
            if (canSpawn && flag) {
                blockEntity.spawnEntity(nearby, pos);
            }
        }
    }

    public void spawnEntity(List<class_3222> nearby, class_243 pos) {
        class_1297 entity;
        if (this.nextSpawn == null) {
            this.updateEntity();
        }
        if (!this.field_11863.field_9236 && this.nextSpawn != null && (entity = this.nextSpawn.method_5883(this.field_11863)) != null) {
            IBaseMob mob;
            this.lastUpdateDay = WorldUtils.day(this.field_11863);
            if (entity instanceof EnsembleMonsters) {
                EnsembleMonsters ensemble = (EnsembleMonsters)entity;
                if (!ensemble.canSpawnerSpawn((class_3218)this.field_11863, this.field_11867, 32)) {
                    return;
                }
                ensemble.setLevel(LevelCalc.levelFromPos((class_3218)this.field_11863, class_243.method_24953((class_2382)this.field_11867), nearby));
                ensemble.setRestrictRadius(13);
                switch ((class_2350)this.method_11010().method_11654((class_2769)BossSpawnerBlock.FACING)) {
                    case field_11035: {
                        ensemble.withDirection(class_2470.field_11464);
                        break;
                    }
                    case field_11039: {
                        ensemble.withDirection(class_2470.field_11465);
                        break;
                    }
                    case field_11034: {
                        ensemble.withDirection(class_2470.field_11463);
                        break;
                    }
                    default: {
                        ensemble.withDirection(class_2470.field_11467);
                        break;
                    }
                }
            } else if (!this.noNearby()) {
                return;
            }
            if (entity instanceof IBaseMob) {
                mob = (IBaseMob)entity;
                mob.setXPLevel(LevelCalc.levelFromPos((class_3218)this.field_11863, class_243.method_24953((class_2382)this.field_11867), nearby));
            }
            entity.method_5808((double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 5), (double)this.field_11867.method_10260() + 0.5, this.field_11863.field_9229.method_43057() * 360.0f, 0.0f);
            if (entity instanceof class_1308) {
                mob = (class_1308)entity;
                mob.method_18408(this.field_11867, 13);
                mob.method_5943((class_5425)this.field_11863, this.field_11863.method_8404(entity.method_24515()), class_3730.field_16469, null);
            }
            this.field_11863.method_8649(entity);
            this.updateEntity();
        }
    }

    public void setEntity(class_1299<?> entity) {
        this.nextSpawn = entity;
    }

    private void updateEntity() {
        if (this.spawnList != null) {
            this.spawnList.getRandom(this.field_11863.method_8409()).ifPresent(this::setEntity);
        }
    }

    private boolean noNearby() {
        return this.field_11863.method_8390(class_1308.class, new class_238(this.field_11867).method_1014(32.0), e -> e.method_5864() == this.nextSpawn || this.spawnList != null && this.spawnList.has(e.method_5864())).isEmpty();
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.lastUpdateDay = tag.method_10550("LastUpdate");
        if (tag.method_10545("SpawnListId")) {
            this.spawnListId = class_2960.method_60654((String)tag.method_10558("SpawnListId"));
            this.spawnList = DataPackHandler.INSTANCE.structureBossManager().getBoss(this.spawnListId);
        }
        if (tag.method_10545("Entity")) {
            this.nextSpawn = (class_1299)class_7923.field_41177.method_39673().parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag.method_10580("Entity")).getOrThrow();
        }
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10569("LastUpdate", this.lastUpdateDay);
        if (this.spawnListId != null) {
            tag.method_10582("SpawnListId", this.spawnListId.toString());
        }
        if (this.nextSpawn != null) {
            tag.method_10566("Entity", (class_2520)class_7923.field_41177.method_39673().encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), this.nextSpawn).getOrThrow());
        }
    }

    public static class_2487 creatTagFor(class_2960 spawnListId) {
        class_2487 tag = new class_2487();
        tag.method_10582("SpawnListId", spawnListId.toString());
        tag.method_10569("LastUpdate", -1);
        return tag;
    }
}

