/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MonsterBarnBlockEntity
extends class_2586 {
    private static final int MAX_SIZE = 5;
    private UUID owner;
    private int cooldown = 0;
    private BarnData barnData;

    public MonsterBarnBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)RuneCraftoryBlocks.MONSTER_BARN_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, MonsterBarnBlockEntity blockEntity) {
        class_2338 pos2;
        if (blockEntity.owner == null || --blockEntity.cooldown > 0 || !(level instanceof class_3218)) {
            return;
        }
        if (blockEntity.barnData == null) {
            blockEntity.barnData = RunecraftorySavedData.get(level.method_8503()).getOrCreateFor(blockEntity.owner, level, blockPos);
        }
        blockEntity.cooldown = 40;
        int size = 5;
        for (class_2338 pos2 : class_2338.method_10094((int)(blockPos.method_10263() - size), (int)(blockPos.method_10264() - 1), (int)(blockPos.method_10260() - size), (int)(blockPos.method_10263() + size), (int)(blockPos.method_10264() - 1), (int)(blockPos.method_10260() + size))) {
            if (Math.abs(pos2.method_10263() - blockPos.method_10263()) > size || Math.abs(pos2.method_10260() - blockPos.method_10260()) > size || MonsterBarnBlockEntity.matches(level, pos2, true) || (size = Math.max(Math.abs(pos2.method_10263() - blockPos.method_10263()), Math.abs(pos2.method_10260() - blockPos.method_10260())) - 1) >= 2) continue;
            blockEntity.barnData.update(0, -1);
            return;
        }
        int airLayers = 10;
        pos2 = new class_2338.class_2339();
        block1: for (int y = 0; y < airLayers; ++y) {
            for (int x = blockPos.method_10263() - size; x < blockPos.method_10263() + size; ++x) {
                for (int z = blockPos.method_10260() - size; z < blockPos.method_10260() + size; ++z) {
                    pos2.method_10103(x, blockPos.method_10264() + y, z);
                    if (pos2.equals((Object)blockPos) || MonsterBarnBlockEntity.matches(level, pos2, false)) continue;
                    airLayers = y;
                    break block1;
                }
            }
        }
        if (airLayers >= 3) {
            boolean hasRoof = true;
            for (class_2338 pos2 : class_2338.method_10094((int)(blockPos.method_10263() - size), (int)(blockPos.method_10264() + airLayers), (int)(blockPos.method_10260() - size), (int)(blockPos.method_10263() + size), (int)(blockPos.method_10264() + airLayers), (int)(blockPos.method_10260() + size))) {
                if (level.method_8624(class_2902.class_2903.field_13197, pos2.method_10263(), pos2.method_10260()) > pos2.method_10264()) continue;
                hasRoof = false;
                break;
            }
            blockEntity.barnData.update(size, hasRoof ? airLayers : -1);
        } else {
            blockEntity.barnData.update(0, -1);
        }
    }

    private static boolean matches(class_1937 level, class_2338 pos, boolean ground) {
        class_2680 state = level.method_8320(pos);
        return ground ? state.method_26164(RunecraftoryTags.Blocks.BARN_GROUND) : !state.method_27852((class_2248)RuneCraftoryBlocks.MONSTER_BARN.get()) && state.method_26220((class_1922)level, pos).method_1110();
    }

    @Nullable
    public BarnData getBarnData() {
        return this.barnData;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID uuid) {
        this.owner = uuid;
        this.method_5431();
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_25928("Owner")) {
            this.owner = tag.method_25926("Owner");
        }
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 nbt = new class_2487();
        if (this.owner != null) {
            nbt.method_25927("Owner", this.owner);
        }
        return nbt;
    }
}

