/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.client.ClientFarmlandHandler;
import io.github.flemmli97.runecraftory.common.blocks.TreeFruitLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeLogBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandDataContainer;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class TreeBlockEntity
extends class_2586 {
    private final PositionHolder logs = new PositionHolder();
    private final PositionHolder leaves = new PositionHolder();
    private final PositionHolder fruits = new PositionHolder();
    private boolean withered;

    public TreeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)RuneCraftoryBlocks.TREE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void updateTreeLogs(class_1922 level, Collection<class_2338> pos) {
        ArrayList<class_2338> list = new ArrayList<class_2338>(pos.stream().filter(p -> !p.equals((Object)this.method_11016().method_10074())).toList());
        list.forEach(log -> {
            class_2586 patt0$temp = level.method_8321(log);
            if (patt0$temp instanceof TreeLogBlockEntity) {
                TreeLogBlockEntity logBlockEntity = (TreeLogBlockEntity)patt0$temp;
                logBlockEntity.updateTreeRoot(this.method_11016());
            }
        });
        this.logs.scheduleNewPositions(list);
        this.method_5431();
    }

    public void updateTreeLeaves(class_1936 level, Collection<class_2338> pos) {
        this.leaves.scheduleNewPositions(pos);
        this.witherTree(level, this.withered, 0);
        this.method_5431();
    }

    public void updateTreeFruits(class_1936 level, Collection<class_2338> pos) {
        this.fruits.scheduleNewPositions(pos);
        this.witherTree(level, this.withered, 1);
        this.method_5431();
    }

    public void invalidateUpdate() {
        this.logs.invalidateUpdate();
        this.leaves.invalidateUpdate();
        this.fruits.invalidateUpdate();
    }

    public boolean isTreeValid(class_1922 getter) {
        for (class_2338 pos : this.logs.getPositions()) {
            TreeLogBlockEntity log;
            class_2586 entity = getter.method_8321(pos);
            if (entity instanceof TreeLogBlockEntity && (log = (TreeLogBlockEntity)entity).treeBase().equals((Object)this.method_11016())) continue;
            return false;
        }
        return true;
    }

    public boolean isPartOf(class_2338 pos) {
        return this.logs.getPositions().contains(pos);
    }

    public int getHealth() {
        if (this.method_10997() == null) {
            return -1;
        }
        if (this.method_10997().field_9236) {
            FarmlandDataContainer data = ClientFarmlandHandler.INSTANCE.getData(this.method_11016().method_10074());
            return data == null ? 0 : data.health();
        }
        class_3218 serverLevel = (class_3218)this.method_10997();
        return FarmlandHandler.get(serverLevel.method_8503()).getData(serverLevel, this.method_11016().method_10074()).map(FarmlandData::getHealth).orElse(0);
    }

    public void onBreak(int cost) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        FarmlandHandler.get(serverLevel.method_8503()).getData(serverLevel, this.method_11016().method_10074()).ifPresent(d -> {
            d.modifyHealth(serverLevel, -cost);
            if (d.getHealth() <= 0) {
                this.onRemove((class_1937)serverLevel, this.method_11016(), true);
            }
        });
    }

    public void update(class_3218 level) {
        for (class_2338 pos : this.fruits.getPositions()) {
            class_2680 state = level.method_8320(pos);
            if (!(state.method_26204() instanceof TreeFruitLeavesBlock)) continue;
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)TreeFruitLeavesBlock.HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        this.method_5431();
    }

    public void onRemove(class_1937 level, class_2338 source, boolean particle) {
        List<class_2338> logs = this.logs.getPositions();
        List<class_2338> leaves = this.leaves.getPositions();
        List<class_2338> fruits = this.fruits.getPositions();
        this.logs.scheduleNewPositions(List.of());
        this.leaves.scheduleNewPositions(List.of());
        this.fruits.scheduleNewPositions(List.of());
        logs.forEach(p -> this.removeBlock(level, (class_2338)p, p.equals((Object)source) ? 2 : (particle ? 1 : 0)));
        leaves.forEach(p -> this.removeBlock(level, (class_2338)p, p.equals((Object)source) ? 2 : (particle ? 1 : 0)));
        fruits.forEach(p -> this.removeBlock(level, (class_2338)p, p.equals((Object)source) ? 2 : (particle ? 1 : 0)));
        if (!this.method_11016().equals((Object)source)) {
            this.removeBlock(level, this.method_11016(), 2);
        }
        this.method_5431();
    }

    private void removeBlock(class_1937 level, class_2338 pos, int removeFlag) {
        switch (removeFlag) {
            case 2: {
                level.method_22352(pos, true);
                break;
            }
            case 1: {
                class_2680 blockState = level.method_8320(pos);
                level.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
                level.method_8652(pos, blockState.method_26227().method_15759(), 2);
                break;
            }
            default: {
                class_2680 blockState = level.method_8320(pos);
                level.method_8652(pos, blockState.method_26227().method_15759(), 2);
            }
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        class_2499 logs = tag.method_10554("Logs", 11);
        logs.forEach(t -> this.logs.getPositions().add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow()));
        class_2499 leaves = tag.method_10554("Leaves", 11);
        leaves.forEach(t -> this.leaves.getPositions().add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow()));
        class_2499 fruits = tag.method_10554("Fruits", 11);
        fruits.forEach(t -> this.fruits.getPositions().add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow()));
        this.withered = tag.method_10577("Withered");
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        class_2499 logs = new class_2499();
        this.logs.getPositions().forEach(p -> logs.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, p).getOrThrow())));
        tag.method_10566("Logs", (class_2520)logs);
        class_2499 leaves = new class_2499();
        this.leaves.getPositions().forEach(p -> leaves.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, p).getOrThrow())));
        tag.method_10566("Leaves", (class_2520)leaves);
        class_2499 fruits = new class_2499();
        this.fruits.getPositions().forEach(p -> fruits.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, p).getOrThrow())));
        tag.method_10566("Fruits", (class_2520)fruits);
        tag.method_10556("Withered", this.withered);
    }

    public void witherTree(class_1936 level, boolean wither) {
        this.witherTree(level, wither, 2);
    }

    private void witherTree(class_1936 level, boolean wither, int positions) {
        if (positions == 2 || positions == 0) {
            this.leaves.getPositions().forEach(p -> {
                class_2680 state = level.method_8320(p);
                if (state.method_28498((class_2769)TreeLeavesBlock.WILTED) && (Boolean)state.method_11654((class_2769)TreeLeavesBlock.WILTED) != wither) {
                    level.method_8652(p, (class_2680)state.method_11657((class_2769)TreeLeavesBlock.WILTED, (Comparable)Boolean.valueOf(wither)), 3);
                }
            });
        }
        if (positions == 2 || positions == 1) {
            this.fruits.getPositions().forEach(p -> {
                class_2680 state = level.method_8320(p);
                if (state.method_28498((class_2769)TreeLeavesBlock.WILTED) && (Boolean)state.method_11654((class_2769)TreeLeavesBlock.WILTED) != wither) {
                    level.method_8652(p, (class_2680)state.method_11657((class_2769)TreeLeavesBlock.WILTED, (Comparable)Boolean.valueOf(wither)), 3);
                }
            });
        }
        this.withered = wither;
    }

    public boolean withered() {
        return this.withered;
    }

    private static class PositionHolder {
        private Collection<class_2338> toUpdate;
        private List<class_2338> positions = new ArrayList<class_2338>();

        private PositionHolder() {
        }

        public void invalidateUpdate() {
            this.toUpdate = null;
        }

        public void scheduleNewPositions(Collection<class_2338> update) {
            this.getPositions();
            this.toUpdate = update;
        }

        public List<class_2338> getPositions() {
            if (this.toUpdate != null) {
                this.positions = new ArrayList<class_2338>(this.toUpdate);
            }
            return this.positions;
        }
    }
}

