/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleAVLTreeMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1320;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class FoodAttributeData {
    public static final FoodAttributeData DEFAULT = new FoodAttributeData(Map.of(), Map.of());
    public static final Codec<FoodAttributeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("flat_stats").forGetter(d -> d.flatStats), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("multiplier_stats").forGetter(d -> d.multiplierStats)).apply((Applicative)instance, FoodAttributeData::new));
    public static final class_9139<class_9129, FoodAttributeData> STREAM_CODEC = new class_9139<class_9129, FoodAttributeData>(){

        public FoodAttributeData decode(class_9129 buf) {
            return new FoodAttributeData((Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf));
        }

        public void encode(class_9129 buf, FoodAttributeData component) {
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, component.flatStats);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, component.multiplierStats);
        }
    };
    private final Map<class_6880<class_1320>, Double> flatStats;
    private final Map<class_6880<class_1320>, Double> multiplierStats;

    private FoodAttributeData(Map<class_6880<class_1320>, Double> flatStats, Map<class_6880<class_1320>, Double> multiplierStats) {
        Object2DoubleAVLTreeMap stats = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        stats.putAll(flatStats);
        this.flatStats = stats;
        Object2DoubleAVLTreeMap stats2 = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        stats2.putAll(multiplierStats);
        this.multiplierStats = stats2;
    }

    public FoodAttributeData add(Map<class_6880<class_1320>, Double> stats) {
        HashMap<class_6880<class_1320>, Double> map = new HashMap<class_6880<class_1320>, Double>(this.flatStats);
        stats.forEach((attribute, value) -> map.put((class_6880<class_1320>)attribute, map.getOrDefault(attribute, 0.0) + value));
        return new FoodAttributeData(map, this.getFlatStats());
    }

    public FoodAttributeData addMultiplier(Map<class_6880<class_1320>, Double> stats) {
        HashMap<class_6880<class_1320>, Double> map = new HashMap<class_6880<class_1320>, Double>(this.multiplierStats);
        stats.forEach((attribute, value) -> map.put((class_6880<class_1320>)attribute, map.getOrDefault(attribute, 0.0) + value));
        return new FoodAttributeData(this.getFlatStats(), map);
    }

    public Map<class_6880<class_1320>, Double> getFlatStats() {
        return Map.copyOf(this.flatStats);
    }

    public Map<class_6880<class_1320>, Double> getMultiplierStats() {
        return Map.copyOf(this.multiplierStats);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FoodAttributeData) {
            FoodAttributeData other = (FoodAttributeData)object;
            return this.flatStats.equals(other.flatStats) && this.multiplierStats.equals(other.multiplierStats);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.flatStats, this.multiplierStats);
    }
}

