/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.datapack.SyncableListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class CropManager
extends class_4309
implements SyncableListener<Map<class_1792, ReloadableHolder<CropProperties>>> {
    public static final class_2960 ID = RuneCraftory.modRes("crop_property");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static final class_9139<class_9129, ReloadableHolder<CropProperties>> HOLDER_CODEC = ReloadableHolder.streamCodec(CropProperties.STREAM_CODEC);
    public static final class_9139<class_9129, Map<class_1792, ReloadableHolder<CropProperties>>> CODEC = new class_9139<class_9129, Map<class_1792, ReloadableHolder<CropProperties>>>(){

        public Map<class_1792, ReloadableHolder<CropProperties>> decode(class_9129 buf) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)((class_1792)class_9135.method_56365((class_5321)class_7924.field_41197).decode((Object)buf)), (Object)((ReloadableHolder)HOLDER_CODEC.decode((Object)buf)));
            }
            return builder.build();
        }

        public void encode(class_9129 buf, Map<class_1792, ReloadableHolder<CropProperties>> props) {
            buf.method_10804(props.size());
            props.forEach((item, prop) -> {
                class_9135.method_56365((class_5321)class_7924.field_41197).encode((Object)buf, item);
                HOLDER_CODEC.encode((Object)buf, prop);
            });
        }
    };
    private Map<class_1792, ReloadableHolder<CropProperties>> itemLookup = ImmutableMap.of();
    private Map<class_1792, ReloadableHolder<CropProperties>> seedLookup = ImmutableMap.of();
    private Map<class_2248, ReloadableHolder<CropProperties>> blockLookup = ImmutableMap.of();
    private boolean resolved;
    private Set<ReloadableHolder<CropProperties>> unresolved = ImmutableSet.of();
    private class_7225.class_7874 provider;

    public CropManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    @Nullable
    public CropProperties get(class_1792 item) {
        ReloadableHolder<CropProperties> value = this.getWithId(item);
        return value != null ? value.value() : null;
    }

    @Nullable
    public ReloadableHolder<CropProperties> getWithId(class_1792 item) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.itemLookup.get(item);
    }

    @Nullable
    public CropProperties get(class_2248 block) {
        ReloadableHolder<CropProperties> value = this.getWithId(block);
        return value != null ? value.value() : null;
    }

    @Nullable
    public ReloadableHolder<CropProperties> getWithId(class_2248 block) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.blockLookup.get(block);
    }

    @Nullable
    public ReloadableHolder<CropProperties> getSeedWithId(class_1792 item) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.seedLookup.get(item);
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap tagEntries = new HashMap();
            HashMap itemEntries = new HashMap();
            HashMap tagEntriesBlocks = new HashMap();
            HashMap itemEntriesBlocks = new HashMap();
            this.unresolved.stream().sorted(Comparator.comparing(ReloadableHolder::id)).forEach(entry -> {
                CropProperties.CropMappingInfo info = ((CropProperties)entry.value()).getInfo();
                if (info.seed() instanceof class_6885.class_6888) {
                    info.seed().forEach(h -> tagEntries.put((class_1792)h.comp_349(), entry));
                } else {
                    info.seed().forEach(h -> itemEntries.put((class_1792)h.comp_349(), entry));
                }
                if (info.crop() instanceof class_6885.class_6888) {
                    info.crop().forEach(h -> tagEntries.put((class_1792)h.comp_349(), entry));
                } else {
                    info.crop().forEach(h -> itemEntries.put((class_1792)h.comp_349(), entry));
                }
                if (info.cropBlock() instanceof class_6885.class_6888) {
                    info.cropBlock().forEach(h -> tagEntriesBlocks.put((class_2248)h.comp_349(), entry));
                } else {
                    info.cropBlock().forEach(h -> itemEntriesBlocks.put((class_2248)h.comp_349(), entry));
                }
                info.giant().ifPresent(giant -> {
                    itemEntries.put((class_1792)giant.getFirst(), entry);
                    itemEntriesBlocks.put((class_2248)giant.getSecond(), entry);
                });
            });
            tagEntries.putAll(itemEntries);
            this.itemLookup = ImmutableMap.copyOf(tagEntries);
            HashMap seedEntries = new HashMap();
            this.itemLookup.forEach((item, prop) -> {
                if (((CropProperties)prop.value()).getInfo().seed().method_40241(class_7923.field_41178.method_47983(item))) {
                    seedEntries.put(item, prop);
                }
            });
            this.seedLookup = ImmutableMap.copyOf(seedEntries);
            tagEntriesBlocks.putAll(itemEntriesBlocks);
            this.blockLookup = ImmutableMap.copyOf(tagEntriesBlocks);
        }
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.resolved = false;
        ImmutableSet.Builder toResolve = ImmutableSet.builder();
        class_6903 ops = this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> CropManager.lambda$apply$9((DynamicOps)ops, toResolve, arg_0, arg_1));
        this.unresolved = toResolve.build();
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    @Override
    public class_9139<class_9129, Map<class_1792, ReloadableHolder<CropProperties>>> codec() {
        return CODEC;
    }

    @Override
    public Map<class_1792, ReloadableHolder<CropProperties>> toSync() {
        this.resolveTags(false);
        return Collections.unmodifiableMap(this.seedLookup);
    }

    @Override
    public void update(class_7225.class_7874 provider, Map<class_1792, ReloadableHolder<CropProperties>> value) {
        this.insertRegistryAccess(provider);
        this.seedLookup = value;
    }

    private static /* synthetic */ void lambda$apply$9(DynamicOps ops, ImmutableSet.Builder toResolve, class_2960 fres, JsonElement el) {
        try {
            CropProperties props = (CropProperties)CropProperties.CODEC.parse(ops, (Object)el).getOrThrow();
            toResolve.add(new ReloadableHolder<CropProperties>(fres, props));
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse crop properties json {} {}", (Object)fres, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

