/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.SpellProperties;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class SpellPropertiesManager
extends class_4309
implements ListenerExtension {
    public static final class_2960 ID = RuneCraftory.modRes("spell");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private Map<Spell, SpellProperties> propertiesMap = new HashMap<Spell, SpellProperties>();
    private class_7225.class_7874 provider;

    public SpellPropertiesManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public SpellProperties getPropertiesFor(Spell spell) {
        return this.propertiesMap.getOrDefault(spell, SpellProperties.DEFAULT_PROP);
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder propertiesBuilder = new ImmutableMap.Builder();
        class_6903 ops = this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$1((DynamicOps)ops, propertiesBuilder, arg_0, arg_1));
        this.propertiesMap = propertiesBuilder.build();
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    private /* synthetic */ void lambda$apply$1(DynamicOps ops, ImmutableMap.Builder propertiesBuilder, class_2960 key, JsonElement el) {
        try {
            Spell spell = (Spell)HolderUtils.get(this.provider, RuneCraftorySpells.SPELL_REGISTRY_KEY, key).orElseThrow(() -> new NoSuchElementException("Spell with id " + String.valueOf(key) + " doesn't exist"));
            SpellProperties props = (SpellProperties)SpellProperties.CODEC.parse(ops, (Object)el).getOrThrow();
            propertiesBuilder.put((Object)spell, (Object)props);
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse spell properties json {} {}", (Object)key, (Object)ex, (Object)ex.fillInStackTrace());
        }
    }
}

