/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.common.advancements.TameMonsterTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.FollowEntityEx;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SinkIfTooHigh;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.TendCrops;
import io.github.flemmli97.runecraftory.common.entities.utils.CommonMonsterHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.DailyMonsterUpdater;
import io.github.flemmli97.runecraftory.common.entities.utils.ExtendedEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateHolder;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateTracker;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2COpenCompanionGui;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.TamingTracker;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryActivities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.mixin.CombatTrackerAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.MoveControllerPlus;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1331;
import net.minecraft.class_1408;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1839;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5569;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMonster
extends class_1314
implements class_1569,
AnimatedEntity,
CommonMonsterHandler,
ExtendedEntity,
SleepingEntity,
TargetableOpponent,
AOEAttackEntity,
MobAttackExt,
SmartBrainOwner<BaseMonster>,
SyncedMobDataHandler,
MoveStateHolder {
    public static final int MOVE_TICK_MAX = 5;
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> BEHAVIOUR_DATA = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> PLAY_DEATH_STATE = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FRIEND_POINTS_SYNC = class_2945.method_12791(BaseMonster.class, (class_2941)class_2943.field_13327);
    public static final TypedResource<TargetPosition> TARGET_POSITION = new TypedResource(RuneCraftory.modRes("target_position"));
    public final Predicate<class_1309> targetPred = e -> {
        if (e != this) {
            class_1308 mob;
            if (this.method_5626((class_1297)e) || !this.method_18395((class_1309)e)) {
                return false;
            }
            if (this.isTamed()) {
                return e instanceof class_1569 && EntityUtils.canAttackOwned(e, false, true, this.targetPred);
            }
            if (e instanceof class_1308 && this == (mob = (class_1308)e).method_5968()) {
                return true;
            }
            return EntityUtils.canMonsterTargetNPC((class_1297)e) || EntityUtils.canAttackOwned(e, false, e instanceof class_1657, entity -> entity instanceof class_1657 ? entity.method_33190() : this.targetPred.test((class_1309)entity));
        }
        return false;
    };
    public final Predicate<class_1309> hitPred = e -> {
        if (e != this) {
            if (this.method_5626((class_1297)e) || !this.method_18395((class_1309)e)) {
                return false;
            }
            if (e instanceof class_1308 && this == ((class_1308)e).method_5968()) {
                return true;
            }
            class_1309 controller = this.method_5642();
            if (this.isTamed()) {
                UUID owner = EntityUtils.tryGetOwner(e);
                if (owner != null && (!this.attackOtherTamedMobs() || owner.equals(this.method_6139()))) {
                    return false;
                }
                if (e == this.method_5968()) {
                    return true;
                }
                if (controller instanceof class_1657) {
                    return true;
                }
                return e instanceof class_1569 || e instanceof class_1308 && ((class_1308)e).method_5968() == this;
            }
            boolean riderTarget = false;
            if (controller != null) {
                class_1308 mob;
                if (controller instanceof BaseMonster) {
                    BaseMonster baseMonster = (BaseMonster)controller;
                    return baseMonster.hitPred.test((class_1309)e);
                }
                riderTarget = controller instanceof class_1308 && e == (mob = (class_1308)controller).method_5968();
            }
            return riderTarget || e == this.method_5968() || EntityUtils.canMonsterTargetNPC((class_1297)e) || EntityUtils.canAttackOwned(e, false, e instanceof class_1657, this.targetPred) || e instanceof class_1657;
        }
        return false;
    };
    public final Predicate<class_1309> defendPred = e -> {
        if (e != this) {
            if (this.method_5642() instanceof class_1657) {
                return false;
            }
            if (this.isTamed()) {
                return !e.method_5667().equals(this.method_6139()) && !this.method_6139().equals(EntityUtils.tryGetOwner(e));
            }
            return true;
        }
        return false;
    };
    private final EntityProperties prop;
    private final float defaultScale;
    private final XpLevelHolder levelPair = new XpLevelHolder();
    private final XpLevelHolder friendlyPoints = new XpLevelHolder();
    private final DailyMonsterUpdater updater = new DailyMonsterUpdater(this);
    private final SyncedDataContainer<BaseMonster> syncedDataContainer;
    protected int tamingTick = -1;
    protected int feedTimeOut;
    private class_2338 seedInventory;
    private class_2338 cropInventory;
    private int playDeathTick;
    private int brushCount;
    private int loveAttCount;
    private Runnable delayedTaming;
    private boolean doJumping = false;
    private int foodBuffTick;
    private class_1657 owner;
    private int tpCooldown;
    private Behaviour behaviour = Behaviour.WANDER;
    private BarnData assignedBarn;
    private Pair<String, Runnable> scheduledAnimationHandling;
    private final MoveStateTracker moveStateTracker = new MoveStateTracker((class_1309)this, 5, MOVE_FLAGS, this::calculateMoveType);
    private boolean initAnim;

    public BaseMonster(class_1299<? extends BaseMonster> type, class_1937 level) {
        super(type, level);
        SyncedDataContainer.Builder builder = SyncedDataContainer.builder((class_1297)this);
        this.definedAdditinoalSyncedData((SyncedDataContainer.Builder<BaseMonster>)builder);
        this.syncedDataContainer = builder.build();
        this.field_6207 = new MoveControllerPlus((class_1308)this);
        this.prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(type);
        this.applyAttributes();
        this.defaultScale = (float)(type.method_58629(0.0, 0.0, 0.0).method_17940() / (double)type.method_17686());
    }

    public static class_5132.class_5133 createAttributes() {
        class_5132.class_5133 map = class_1588.method_26918().method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23718, 1.0);
        for (RegistryEntrySupplier<class_1320, ?> att : RuneCraftoryAttributes.ENTITY_ATTRIBUTES) {
            map.method_26867(att.asHolder());
        }
        return map;
    }

    public EntityProperties getProp() {
        return this.prop;
    }

    protected class_1408 method_5965(class_1937 level) {
        return new SmoothGroundNavigation((class_1308)this, level);
    }

    protected void applyAttributes() {
        for (Map.Entry<class_6880<class_1320>, Double> att : this.prop.baseValues().entrySet()) {
            class_1324 inst = this.method_5996(att.getKey());
            if (inst == null) continue;
            inst.method_6192(att.getValue().doubleValue());
            if (att.getKey() != class_5134.field_23716) continue;
            this.method_6033(this.method_6063());
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OWNER_UUID, Optional.empty());
        builder.method_56912(MOVE_FLAGS, (Object)0);
        builder.method_56912(BEHAVIOUR_DATA, (Object)0);
        builder.method_56912(PLAY_DEATH_STATE, (Object)false);
        builder.method_56912(FRIEND_POINTS_SYNC, (Object)1);
    }

    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        builder.define(TARGET_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.TARGET_POS.get(), null);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.method_37908().field_9236) {
            if (key.equals(BEHAVIOUR_DATA)) {
                try {
                    this.behaviour = Behaviour.values()[(Integer)this.field_6011.method_12789(BEHAVIOUR_DATA)];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (key.equals(PLAY_DEATH_STATE) && ((Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE)).booleanValue() && !this.getAnimationHandler().hasAnimation()) {
                this.playDeathAnimation(true);
            }
        }
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public void method_5711(byte id) {
        if (id == 10) {
            this.playTameEffect(true);
        } else if (id == 11) {
            this.playTameEffect(false);
        } else if (id == 34) {
            for (int i = 0; i < 5; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11231, this.method_23317() - (double)this.method_17681() * 0.25 + (double)(this.field_5974.method_43057() * this.method_17681() * 0.25f), this.method_23318() + (double)this.method_17682() + (double)this.field_5974.method_43057() * 0.3, this.method_23321() - (double)this.method_17681() * 0.25 + (double)(this.field_5974.method_43057() * this.method_17681() * 0.25f), 0.0, 0.0, 0.0);
            }
        } else if (id == 64) {
            this.method_37908().method_8466((class_2394)class_2398.field_11224, true, this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.3, this.method_23321(), 0.0, 0.0, 0.0);
        } else if (id == 65) {
            this.method_37908().method_8466((class_2394)class_2398.field_11201, true, this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.3, this.method_23321(), 0.0, 0.0, 0.0);
        }
        super.method_5711(id);
    }

    public void method_5773() {
        super.method_5773();
        class_243 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            float[] clamp = this.targetLookClamp();
            this.method_36456(MathsHelper.rotlerp(this.method_36454(), yxRot[0], clamp[0]));
            this.method_36457(MathsHelper.rotlerp(this.method_36455(), yxRot[1], clamp[1]));
            this.method_5636(this.method_36454());
            this.method_5847(this.method_36454());
        }
    }

    public void method_6007() {
        AnimationState animation;
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                if (anim != null && !this.method_37908().field_9236) {
                    this.setupAttack((AnimationDefinition)anim);
                }
                return false;
            });
            this.initAnim = true;
        }
        super.method_6007();
        this.getAnimationHandler().tick();
        boolean teleported = false;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1657 owner;
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (owner = this.getOwner()) != null) {
                serverLevel.method_14178().method_17297(WorldUtils.ENTITY_LOADER, this.method_31476(), 3, (Object)this.method_31476());
                if (owner.method_37908().method_27983() != this.method_37908().method_27983()) {
                    TeleportUtils.safeDimensionTeleport((class_1308)this, (class_3218)owner.method_37908(), owner.method_24515());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (owner.method_5858((class_1297)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((class_1308)this, (class_1297)owner);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
            this.updater.tick();
            if (this.tamingTick > 0 || this.method_5987()) {
                if (this.getMoveFlag() != MoveType.NONE) {
                    this.setMovingFlag(MoveType.NONE);
                    this.method_18799(class_243.field_1353);
                }
                if (this.tamingTick > 0) {
                    --this.tamingTick;
                }
            }
            if (this.tamingTick == 0) {
                if (this.delayedTaming != null) {
                    this.delayedTaming.run();
                    this.delayedTaming = null;
                }
                this.tamingTick = -1;
            }
            if (this.feedTimeOut > 0) {
                --this.feedTimeOut;
            }
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.assignedBarn != null && this.assignedBarn.isInvalidFor(this)) {
                this.assignedBarn = null;
            }
            if (this.isTamed() && this.assignedBarn == null && MobConfig.monsterNeedBarn && this.behaviourState() != Behaviour.STAY) {
                this.setBehaviour(Behaviour.STAY);
            }
        } else if (!this.playDeath() && TendCrops.cantTendToCropsAnymore(this) && this.behaviour == Behaviour.FARM && this.field_6012 % 20 == 0) {
            this.method_37908().method_8406((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.3, this.method_23321(), 0.0, 0.0, 0.0);
        }
        this.moveStateTracker.tick();
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.method_37908().field_9236) {
                if (teleported) {
                    this.method_6025(1.0f);
                }
                if ((double)this.method_6032() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
        if ((animation = this.getAnimationHandler().getAnimation()) == null && this.getTargetPosition() != null) {
            this.setTargetPosition((TargetPosition)null);
        }
        if (animation == null || this.scheduledAnimationHandling != null && !((String)this.scheduledAnimationHandling.getFirst()).equals(animation.getID())) {
            this.scheduledAnimationHandling = null;
        }
    }

    public void method_5958() {
        super.method_5958();
        this.tickBrain((class_1309)this);
        if (this.field_6012 % 10 == 0) {
            if (this.isStaying()) {
                BrainUtils.setMemory((class_1309)this, (class_4140)((class_4140)RuneCraftoryMemoryTypes.STAYING.get()), (Object)class_3902.field_17274);
            } else {
                BrainUtils.clearMemory((class_1309)this, (class_4140)((class_4140)RuneCraftoryMemoryTypes.STAYING.get()));
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("MobLevel", (class_2520)this.xpLevel().save());
        if (this.isTamed()) {
            compound.method_25927("Owner", this.method_6139());
        }
        compound.method_10569("Behaviour", this.behaviourState().ordinal());
        compound.method_10569("FeedTime", this.feedTimeOut);
        if (this.method_18410()) {
            compound.method_10539("Home", new int[]{this.method_18412().method_10263(), this.method_18412().method_10264(), this.method_18412().method_10260(), (int)this.method_18413()});
        }
        compound.method_10569("FoodBuffTick", this.foodBuffTick);
        compound.method_10566("FriendlyPoints", (class_2520)this.friendlyPoints.save());
        compound.method_10566("DailyUpdater", (class_2520)this.updater.save());
        compound.method_10556("PlayDeath", ((Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE)).booleanValue());
        if (this.seedInventory != null) {
            compound.method_10539("SeedInventory", new int[]{this.seedInventory.method_10263(), this.seedInventory.method_10264(), this.seedInventory.method_10260()});
        }
        if (this.cropInventory != null) {
            compound.method_10539("CropInventory", new int[]{this.cropInventory.method_10263(), this.cropInventory.method_10264(), this.cropInventory.method_10260()});
        }
        if (this.assignedBarn != null && !this.assignedBarn.isInvalidFor(this)) {
            class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.assignedBarn.pos).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> compound.method_10566("AssignedBarnLocation", t));
        }
    }

    public void method_5749(class_2487 compound) {
        int[] arr;
        super.method_5749(compound);
        this.levelPair.read((class_2520)compound.method_10562("MobLevel"));
        if (compound.method_10545("Owner")) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(compound.method_25926("Owner")));
        }
        this.feedTimeOut = compound.method_10550("FeedTime");
        if (compound.method_10545("Home")) {
            int[] home = compound.method_10561("Home");
            this.method_18408(new class_2338(home[0], home[1], home[2]), home[3]);
        }
        this.foodBuffTick = compound.method_10550("FoodBuffTick");
        this.friendlyPoints.read((class_2520)compound.method_10562("FriendlyPoints"));
        this.field_6011.method_12778(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel());
        this.updater.read(compound.method_10562("DailyUpdater"));
        this.setPlayDeath(compound.method_10577("PlayDeath"));
        if (compound.method_10545("SeedInventory") && (arr = compound.method_10561("SeedInventory")).length == 3) {
            this.setSeedInventory(new class_2338(arr[0], arr[1], arr[2]));
        }
        if (compound.method_10545("CropInventory") && (arr = compound.method_10561("CropInventory")).length == 3) {
            this.setCropInventory(new class_2338(arr[0], arr[1], arr[2]));
        }
        if (compound.method_10545("AssignedBarnLocation") && this.method_5682() != null) {
            class_4208.field_25066.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)compound.method_10580("AssignedBarnLocation"))).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(p -> {
                this.assignedBarn = RunecraftorySavedData.get(this.method_5682()).barnAt((class_4208)p);
            });
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.method_10550("Behaviour")], true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public List<? extends ExtendedSensor<? extends BaseMonster>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.targetPred.test((class_1309)target)).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                return entity.defendPred.test(attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends BaseMonster> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FloatToSurfaceOfFluid().startCondition(BaseMonster::canFloatInWater), new SetTargetFromRider(), new SinkIfTooHigh(), new FollowEntityEx<BaseMonster, class_1657>().startFollowingWhen((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 8.0 : 12.0).ignoreIfTargetingTill(20.0).stopFollowingWithin((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 2.0 : 6.0).teleportToTargetAfter((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 20.0 : 24.0).following(BaseMonster::getOwner).speedMod(1.05f).speedMod(1.1f).startCondition(m -> m.behaviourState() == Behaviour.FOLLOW || m.behaviourState() == Behaviour.FOLLOW_DISTANCE), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.method_59922().method_39332(40, 100)).whenStopping(m -> BrainUtils.clearMemory((class_1309)m, (class_4140)class_4140.field_18446))});
    }

    protected ExtendedBehaviour<? extends BaseMonster> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((class_5863)class_5862.method_33908((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.method_59922().method_43057() < 0.1 && !BrainUtils.hasMemory((class_1309)m, (class_4140)class_4140.field_18445))}).startCondition(e -> !BrainUtils.hasMemory((class_1309)e, (class_4140)class_4140.field_22355) && !e.method_6113() && !e.playDeath() && !e.getAnimationHandler().hasAnimation());
    }

    public BrainActivityGroup<? extends BaseMonster> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), this.getWanderBehaviour().startCondition(m -> m.method_59922().method_43048(m.wanderChance()) == 0)})});
    }

    public BrainActivityGroup<? extends BaseMonster> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BaseMonster::runCooldownBehaviour).stopIf(e -> !e.runCooldownBehaviour()), this.getCombatAI().startCondition(BaseMonster::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return new Idle();
    }

    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return new Idle();
    }

    protected boolean runCooldownBehaviour() {
        return !this.getAnimationHandler().hasAnimation() && (BrainUtils.hasMemory((class_1309)this, (class_4140)class_4140.field_22475) || !BrainUtils.hasMemory((class_1309)this, (class_4140)((class_4140)TenshilibMemoryModules.ANIMATION_TO_PLAY.get())));
    }

    protected boolean runCombatBehaviour() {
        return !this.getAnimationHandler().hasAnimation() && !BrainUtils.hasMemory((class_1309)this, (class_4140)class_4140.field_22475);
    }

    public Map<class_4168, BrainActivityGroup<? extends BaseMonster>> getAdditionalTasks() {
        HashMap<class_4168, BrainActivityGroup<? extends BaseMonster>> map = new HashMap<class_4168, BrainActivityGroup<? extends BaseMonster>>();
        map.put((class_4168)RuneCraftoryActivities.STAY.get(), new BrainActivityGroup((class_4168)RuneCraftoryActivities.STAY.get()).priority(20).behaviours(new class_4097[]{new Idle()}).onlyStartWithMemoryStatus((class_4140)RuneCraftoryMemoryTypes.STAYING.get(), class_4141.field_18456));
        map.put(class_4168.field_18596, new BrainActivityGroup(class_4168.field_18596).priority(20).behaviours(new class_4097[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetMoveToRestriction(), new TendCrops()})}).onlyStartWithMemoryStatus((class_4140)RuneCraftoryMemoryTypes.FARMING.get(), class_4141.field_18456));
        return map;
    }

    public List<class_4168> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new class_4168[]{(class_4168)RuneCraftoryActivities.STAY.get(), class_4168.field_18596, class_4168.field_22396, class_4168.field_18595});
    }

    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget();
    }

    protected int wanderChance() {
        return this.behaviourState() == Behaviour.WANDER_HOME ? 40 : 120;
    }

    protected boolean canFloatInWater() {
        return true;
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    @Override
    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    @Override
    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public MoveType getMoveFlag() {
        return MoveType.values()[(Byte)this.field_6011.method_12789(MOVE_FLAGS)];
    }

    public void setMovingFlag(MoveType type) {
        this.field_6011.method_12778(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType calculateMoveType() {
        if (this.method_5642() instanceof class_1657 || !this.field_42108.method_48571()) {
            return MoveType.NONE;
        }
        if (this.method_6062()) {
            return MoveType.NONE;
        }
        double d0 = this.method_5962().method_6242();
        MoveType move = d0 > 1.0 || this.method_5968() != null ? MoveType.RUN : (d0 <= 0.6 ? MoveType.SNEAK : MoveType.WALK);
        return move;
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean isStaying() {
        if (!this.isTamed()) {
            return false;
        }
        if (this.method_5816() && !this.method_6094()) {
            return false;
        }
        if (!this.method_24828() && !this.method_5740()) {
            return false;
        }
        return this.behaviour == Behaviour.STAY;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.setBehaviour(behaviour, false);
    }

    private void setBehaviour(Behaviour behaviour, boolean load) {
        this.field_6011.method_12778(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.method_37908().field_9236) {
            this.updateAI(false, load);
        }
    }

    private void updateAI(boolean forced, boolean load) {
        if (forced || this.isTamed()) {
            this.method_5942().method_6340();
            if (this.behaviourState() != Behaviour.FARM) {
                this.setSeedInventory(null);
                this.setCropInventory(null);
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    FarmlandHandler.get(serverLevel.method_8503()).removeIrrigationPOI(serverLevel, this.method_5667());
                }
            }
            BrainUtils.clearMemory((class_1309)this, (class_4140)((class_4140)RuneCraftoryMemoryTypes.FARMING.get()));
            switch (this.behaviourState().ordinal()) {
                case 1: {
                    if (this.getOwner() == null) break;
                    if (this.findNearestBarn(load)) {
                        this.restrictToBasedOnBehaviour(null, load);
                        class_2338 pos = this.assignedBarn.pos.comp_2208();
                        if (this.method_37908().method_27983() == this.assignedBarn.pos.comp_2207()) {
                            TeleportSpell.safeTeleportTo((class_1297)this, pos.method_10263(), pos.method_10264(), pos.method_10260());
                        } else {
                            class_3218 serverLevel = this.method_5682().method_3847(this.assignedBarn.pos.comp_2207());
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((class_1297)this, serverLevel, pos.method_10263(), pos.method_10264(), pos.method_10260());
                            }
                        }
                    } else {
                        if (this.field_6012 > 20) {
                            this.getOwner().method_7353((class_2561)class_2561.method_43469((String)"runecraftory.monster.interact.barn.no.ext", (Object[])new Object[]{this.method_5476(), this.method_24515().method_23854()}), false);
                        }
                        this.setBehaviour(Behaviour.WANDER);
                    }
                    ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner())).party.removePartyMember((class_1297)this);
                    break;
                }
                case 2: {
                    boolean party;
                    if (this.getOwner() == null) break;
                    PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner());
                    boolean bl = party = !data.party.isPartyFull() || data.party.isPartyMember((class_1297)this);
                    if (!party) break;
                    this.method_35055();
                    data.party.addPartyMember((class_1297)this);
                    break;
                }
                case 3: {
                    this.method_35055();
                    if (this.getOwner() == null) break;
                    ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner())).party.addPartyMember((class_1297)this);
                    break;
                }
                case 4: {
                    if (this.getOwner() == null) break;
                    ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner())).party.addPartyMember((class_1297)this);
                    break;
                }
                case 0: {
                    this.restrictToBasedOnBehaviour(this.method_24515(), load);
                    if (this.getOwner() == null) break;
                    ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner())).party.removePartyMember((class_1297)this);
                    break;
                }
                case 5: {
                    this.restrictToBasedOnBehaviour(this.method_24515(), load);
                    BrainUtils.setMemory((class_1309)this, (class_4140)((class_4140)RuneCraftoryMemoryTypes.FARMING.get()), (Object)class_3902.field_17274);
                    class_2338 nearestInv = this.nearestBlockEntityWithInv();
                    if (this.getSeedInventory() == null) {
                        this.setSeedInventory(nearestInv);
                    }
                    if (this.getCropInventory() == null) {
                        this.setCropInventory(nearestInv);
                    }
                    if (this.getOwner() == null) break;
                    ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner())).party.removePartyMember((class_1297)this);
                }
            }
        }
    }

    public void restrictToBasedOnBehaviour(@Nullable class_2338 pos, boolean keepPos) {
        if (this.behaviourState() == Behaviour.WANDER_HOME && this.assignBarn() && this.method_37908().method_27983() == this.assignedBarn.pos.comp_2207()) {
            this.method_18408(this.assignedBarn.pos.comp_2208(), 1);
        }
        if (pos == null) {
            return;
        }
        if (keepPos) {
            pos = this.method_18412();
        }
        if (this.behaviourState() == Behaviour.FARM) {
            this.method_18408(pos, MobConfig.farmRadius + 3);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                FarmlandHandler.get(serverLevel.method_8503()).addIrrigationPOI(serverLevel, this.method_5667(), this.method_24515());
            }
        } else if (this.behaviourState() == Behaviour.WANDER) {
            this.method_18408(pos, 9);
        }
    }

    public float method_18413() {
        if (this.behaviourState() == Behaviour.WANDER_HOME && this.assignedBarn != null && this.method_37908().method_27983() == this.assignedBarn.pos.comp_2207()) {
            return (float)this.assignedBarn.getSize() + 1.5f;
        }
        return super.method_18413();
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5642() instanceof class_1657 || this.playDeath() || this.tamingTick > 0;
    }

    protected float method_6120() {
        return 0.83f;
    }

    public void method_6091(class_243 vec) {
        this.handleLandTravel(vec);
    }

    public void handleLandTravel(class_243 vec) {
        if (this.shouldFreezeTravel()) {
            this.field_6212 = 0.0f;
            this.field_6227 = 0.0f;
            this.field_6250 = 0.0f;
            return;
        }
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            this.handlePlayerInput(player, this.method_5740(), this::landTravel);
        } else {
            this.landTravel(vec);
        }
    }

    private void landTravel(class_243 vec) {
        if (!this.method_5805() || this.playDeath()) {
            vec = class_243.field_1353;
        }
        super.method_6091(vec);
    }

    public void handleFreeTravel(class_243 vec) {
        if (this.shouldFreezeTravel()) {
            this.field_6212 = 0.0f;
            this.field_6227 = 0.0f;
            this.field_6250 = 0.0f;
            return;
        }
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            this.handlePlayerInput(player, true, this::freeTravel);
        } else {
            this.freeTravel(vec);
        }
    }

    private void freeTravel(class_243 vec) {
        boolean currentNophysics = this.field_5960;
        if (!this.method_5805() || this.playDeath()) {
            this.field_5960 = false;
            vec = class_243.field_1353;
        }
        this.method_5724(this.method_6029() * 0.2f, vec);
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.91));
        this.field_5960 = currentNophysics;
        this.method_29242(true);
    }

    public boolean shouldFreezeTravel() {
        return false;
    }

    protected void handlePlayerInput(class_1657 player, boolean hovers, Consumer<class_243> cons) {
        if (this.getAnimationHandler().hasAnimation()) {
            this.setMovingFlag(MoveType.NONE);
            this.method_5728(false);
            cons.accept(class_243.field_1353);
            return;
        }
        if (!this.method_5787()) {
            this.method_18799(class_243.field_1353);
            this.setDoJumping(false);
            return;
        }
        if (this.adjustRotFromRider((class_1309)player)) {
            this.method_36456(this.rotateClamped(this.method_36454(), player.method_36454(), this.method_20240() * 2));
            this.method_36457(this.rotateClamped(this.method_36455(), player.method_36455(), this.method_5978()));
        }
        this.method_5636(this.method_36454());
        this.method_5847(this.method_36454());
        double attrSpeed = !this.method_24828() && this.method_6127().method_45331(class_5134.field_23720) ? this.method_45325(class_5134.field_23720) : this.method_45325(class_5134.field_23719);
        float speed = (float)(attrSpeed / 1.3 * this.ridingSpeedModifier());
        float strafing = player.field_6212 / 0.98f * speed * 0.8f;
        float forward = player.field_6250 / 0.98f * speed;
        if (player.field_6250 < 0.0f) {
            forward *= 0.5f;
        }
        float vertical = 0.0f;
        if (hovers && forward > 0.0f) {
            vertical = (float)Math.min(0.0, player.method_5720().field_1351 + 0.45) * speed;
            if (player.method_36455() > 85.0f) {
                forward = 0.0f;
            } else if (vertical < 0.0f) {
                forward = (float)Math.sqrt(forward * forward - vertical * vertical);
            }
        }
        if (this.doJumping()) {
            if (this.method_24828() && !this.isFlyingEntity()) {
                this.field_6007 = true;
                this.method_6043();
                if (forward > 0.0f) {
                    float x = -class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
                    float z = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
                    this.method_18799(this.method_18798().method_1031(0.3 * (double)x, 0.0, 0.3 * (double)z));
                }
            } else if (this.isFlyingEntity()) {
                vertical = speed * 0.7f;
                if (this.method_18798().method_10214() < (double)vertical) {
                    this.method_18799(new class_243(this.method_18798().field_1352, this.method_18798().field_1351 + 0.1, this.method_18798().field_1350));
                }
            }
        }
        this.method_6125(speed);
        MoveType type = forward > 0.0f ? MoveType.RUN : (forward != 0.0f || strafing != 0.0f ? MoveType.WALK : MoveType.NONE);
        this.setMovingFlag(type);
        this.method_5728(type == MoveType.RUN);
        this.setDoJumping(false);
        cons.accept(new class_243((double)strafing, (double)vertical, (double)forward));
    }

    public void setDoJumping(boolean jump) {
        this.doJumping = jump;
    }

    public boolean doJumping() {
        return this.doJumping;
    }

    public boolean adjustRotFromRider(class_1309 rider) {
        return true;
    }

    private float rotateClamped(float current, float target, float maxChange) {
        float f = class_3532.method_15381((float)current, (float)target);
        float g = class_3532.method_15363((float)f, (float)(-maxChange), (float)maxChange);
        return current + g;
    }

    public double ridingSpeedModifier() {
        return 1.3;
    }

    protected class_243 directionToLookAt() {
        return this.getAnimationHandler().hasAnimation() && this.getTargetPosition() != null ? this.getTargetPosition().asVec(this.method_19538()).method_1020(this.method_19538()) : null;
    }

    protected float[] targetLookClamp() {
        return new float[]{60.0f, 30.0f};
    }

    protected class_238 method_53511() {
        return this.method_5829().method_1014(0.5);
    }

    public boolean method_6121(class_1297 entity) {
        return CombatUtils.mobAttack((class_1309)this, entity, this.damageSourceAttack());
    }

    public DynamicDamage.Builder damageSourceAttack() {
        return new DynamicDamage.Builder((class_1297)this).hurtResistant(5);
    }

    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_59922().method_43048(20) + 30 + diffAdd;
        }
        return this.method_59922().method_43048(20) + 20 + diffAdd;
    }

    public int difficultyCooldown() {
        int diffAdd = 20;
        class_1267 diff = this.method_37908().method_8407();
        if (this.method_37908().method_8407() == class_1267.field_5807) {
            diffAdd = 0;
        } else if (diff == class_1267.field_5802) {
            diffAdd = 10;
        }
        return diffAdd;
    }

    public boolean method_18395(class_1309 target) {
        return super.method_18395(target) && this.method_18407(target.method_24515());
    }

    public class_1309 method_5968() {
        return BrainUtils.getTargetOfEntity((class_1309)this);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (super.method_5968() == null) {
            BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_22355);
        } else {
            BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_22355, (Object)super.method_5968());
        }
    }

    public boolean attackOtherTamedMobs() {
        return false;
    }

    public void setupAttack(AnimationDefinition anim) {
        BrainUtils.clearMemory((class_1309)this, (class_4140)class_4140.field_18446);
        if (this.method_5968() != null) {
            this.setTargetPosition(this.method_5968());
        }
        this.method_5942().method_6340();
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{this.getInteractAnimation()})) {
            if (this.scheduledAnimationHandling != null && anim.is(new String[]{(String)this.scheduledAnimationHandling.getFirst()}) && anim.isAt("attack")) {
                ((Runnable)this.scheduledAnimationHandling.getSecond()).run();
            }
            return;
        }
        if (anim.is(new String[]{this.getDeathAnimation(), this.getSleepAnimation()})) {
            return;
        }
        this.method_5942().method_6340();
        if (anim.isAt("attack")) {
            this.mobAttack(anim, this.method_5968(), this::method_6121);
        }
    }

    @Override
    public TargetPosition getTargetPosition() {
        return (TargetPosition)this.getDataContainer().get(TARGET_POSITION);
    }

    public void setTargetPosition(class_1309 target) {
        this.setTargetPosition(TargetPosition.of((class_1309)target));
    }

    public void setTargetPosition(TargetPosition position) {
        this.getDataContainer().set(TARGET_POSITION, (Object)position);
    }

    @Nullable
    public class_243 tryGetTargetPosition(class_1309 target) {
        if (this.getTargetPosition() != null) {
            return this.getTargetPosition().asVec(this.method_19538());
        }
        return target != null ? target.method_19538() : null;
    }

    public void mobAttack(AnimationState anim, class_1309 target, Consumer<class_1309> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.tryGetTargetPosition(target), 0.0);
        this.method_37908().method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.hitPred.test((class_1309)entity) && obb.intersects(entity.method_5829())).forEach(cons);
        if (!this.method_37908().field_9236) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
    }

    public boolean isInAttackBox(class_1297 entity, String animation) {
        OrientedBoundingBox aabb = this.prepareAttackBox(animation, entity, -0.15, false);
        return aabb.intersects(entity.method_5829());
    }

    public OrientedBoundingBox prepareAttackBox(String anim, class_1297 target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.method_19538() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (class_1297)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable class_243 target, double grow) {
        float yRot = this.method_5791();
        float xRot = this.method_36455();
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            yRot = player.method_5791();
            xRot = player.method_36455();
        } else if (target != null) {
            class_243 dir = target.method_1020(this.method_19538()).method_1029();
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            yRot = yXRot[0];
            xRot = -yXRot[1];
        }
        double off = (double)this.method_17682() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).method_1009(grow, 0.0, grow).method_989(0.0, -off, grow), yRot, class_3532.method_15363((float)xRot, (float)-15.0f, (float)15.0f), this.method_19538().method_1031(0.0, off, 0.0));
    }

    public class_238 attackBB(AnimationState anim) {
        double range = 1.0;
        return new class_238(-range * 0.5, -0.02, 0.0, range * 0.5, this.vehicleDependentHeight() + 0.02, range);
    }

    public final double vehicleDependentHeight() {
        double height = this.method_17682();
        class_1297 entity = this.method_5854();
        if (entity != null) {
            height = this.method_53511().field_1325 - entity.method_5829().field_1322;
        }
        return height;
    }

    public abstract void handleRidingCommand(int var1);

    public boolean allowAnimation(@Nullable String prev, String other) {
        return true;
    }

    public void method_6015(@Nullable class_1309 livingBase) {
        if (this.method_29504() && this.field_6213 > 0) {
            return;
        }
        super.method_6015(livingBase);
    }

    public boolean method_33190() {
        return super.method_33190() && !this.playDeath();
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        if (this.isFlyingEntity() || this.method_5962() instanceof class_1331) {
            return false;
        }
        return super.method_5747(fallDistance, multiplier, source);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5667().equals(this.method_6139()) && !player.method_5715()) {
            return false;
        }
        if (this.getSpawnAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSpawnAnimation()})) {
            return false;
        }
        if (this.playDeath() && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        return (source.method_5529() == null || this.canAttackFrom(source.method_5529().method_19538())) && super.method_5643(source, amount);
    }

    private boolean canAttackFrom(class_243 pos) {
        boolean result;
        if (this.isTamed()) {
            return true;
        }
        boolean bl = result = this.method_18413() == -1.0f || this.method_18412().method_10268(pos.method_10216(), pos.method_10214(), pos.method_10215()) < (double)(this.method_18413() * this.method_18413());
        if (!result) {
            this.method_37908().method_43129(null, (class_1297)this, (class_3414)RuneCraftorySounds.ENTITY_ATTACK_BLOCKED.get(), this.method_5634(), 0.7f, 0.9f);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                for (int i = 0; i < 6; ++i) {
                    serverLevel.method_14199((class_2394)class_2398.field_11208, this.method_23322(1.2), this.method_23319(), this.method_23325(1.2), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return result;
    }

    protected void method_6074(class_1282 source, float damageAmount) {
        DynamicDamage dmg;
        super.method_6074(source, damageAmount);
        if (!this.isTamed() && source instanceof DynamicDamage && (dmg = (DynamicDamage)source).method_5529() instanceof class_1657 && dmg.getElement() == ItemElement.LOVE) {
            this.loveAttCount = Math.min(100, this.loveAttCount + 1);
        }
        if (!source.method_48789(class_8103.field_42242) && this.isTamed() && this.method_6032() <= 0.0f) {
            this.method_6033(0.01f);
            this.setPlayDeath(true);
        }
    }

    @Override
    public boolean canBeAttackedBy(class_1309 entity) {
        if (entity instanceof class_1308) {
            class_1308 m = (class_1308)entity;
            if (entity.method_5864().method_20210(RunecraftoryTags.EntityTypes.TAMED_MONSTER_IGNORE) && this.method_5968() != m && m.method_6065() != this) {
                return !this.isTamed();
            }
        }
        return true;
    }

    @Override
    public Predicate<class_1309> validTargetPredicate() {
        return this.hitPred;
    }

    public void method_6078(class_1282 cause) {
        if (!this.method_37908().field_9236) {
            if (this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
                this.getOwner().method_7353(this.method_6066().method_5548(), false);
            }
            if (this.method_5682() != null && this.method_6139() != null) {
                RunecraftorySavedData.get(this.method_5682()).removeMonsterFromPlayer(this.method_6139(), this);
                this.assignedBarn = null;
            }
            this.getAnimationHandler().setAnimation(null);
            List<class_1281> entries = ((CombatTrackerAccessor)this.method_6066()).getEntries();
            HashMap merged = new HashMap();
            entries.forEach(e -> {
                class_1297 patt0$temp = e.comp_1535().method_5529();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    merged.compute(player.method_5667(), (id, o) -> o == null ? new CombatRecord(player, e.comp_1535(), e.comp_1536()) : new CombatRecord(player, e.comp_1535(), o.totalDamage() + e.comp_1536()));
                }
            });
            merged.values().forEach(rec -> this.onDeathDamageRecord(rec.player, rec.lastSource, rec.totalDamage));
            this.method_5772();
        }
        super.method_6078(cause);
    }

    protected void method_6108() {
        if (!this.method_37908().field_9236 && this.field_6213 == 0) {
            this.playDeathAnimation(false);
            this.method_5942().method_6340();
        }
        ++this.field_6213;
        if (this.field_6213 == this.maxDeathTime() - 5 && !this.method_37908().field_9236 && this.method_6065() != null) {
            LevelCalc.addXP(this.method_6065(), this.baseXP(), this.baseMoney(), this.xpLevel().getLevel());
        }
        if (this.field_6213 >= this.maxDeathTime()) {
            for (int i = 0; i < 20; ++i) {
                AdvancedParticleContainer.make((class_2394)class_2398.field_11203).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02, this.field_5974.method_43059() * 0.02)).add(this.method_37908(), this.method_23322(1.0), this.method_23319(), this.method_23325(1.0));
            }
            if (!this.method_37908().field_9236) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    public void onDeathDamageRecord(class_3222 player, class_1282 source, float damage) {
        if ((double)damage > (double)this.method_6063() * 0.05) {
            ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).increaseMobFrom(this);
        }
    }

    protected void playDeathAnimation(boolean load) {
        if (this.getDeathAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getDeathAnimation());
            if (load && this.method_37908().field_9236) {
                AnimationState anim = this.getAnimationHandler().getAnimation();
                while (!anim.done(0)) {
                    anim.tick();
                }
            }
        }
    }

    public int maxDeathTime() {
        return 20;
    }

    public String getDeathAnimation() {
        return null;
    }

    public int deathRays() {
        return 0;
    }

    public double deathRayOffset() {
        return (double)this.method_17682() * 0.15;
    }

    public boolean playDeath() {
        return (Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE);
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public void setPlayDeath(boolean flag) {
        this.field_6011.method_12778(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
                this.getOwner().method_7353(this.getKnockoutMessage(), false);
            }
            this.method_37908().method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> this.equals(e.method_5968())).forEach(m -> BrainUtils.setTargetOfEntity((class_1309)m, null));
            this.method_5942().method_6340();
            this.playDeathAnimation(false);
            this.setMovingFlag(MoveType.NONE);
            this.method_5660(false);
            this.method_5728(false);
            this.method_18375();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private class_2561 getKnockoutMessage() {
        class_1282 source = this.method_6081();
        if (source != null && source.method_5529() != null) {
            return class_2561.method_43469((String)"runecraftory.tamed.monster.knockout.by", (Object[])new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260(), source.method_5529().method_5476()});
        }
        return class_2561.method_43469((String)"runecraftory.tamed.monster.knockout", (Object[])new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260()});
    }

    public boolean doStartRide(class_3222 player) {
        if (this.rideable()) {
            player.method_5804((class_1297)this);
            return true;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"runecraftory.monster.interact.ride.no"), false);
        return false;
    }

    protected void method_5627(class_1297 passenger) {
        this.method_5942().method_6340();
        this.method_18799(class_243.field_1353);
        this.method_5976(0.0f);
        this.method_5930(0.0f);
        this.method_5938(0.0f);
        BrainUtils.setTargetOfEntity((class_1309)this, null);
        super.method_5627(passenger);
    }

    protected void method_5793(class_1297 passenger) {
        if (passenger == this.getOwner()) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        super.method_5793(passenger);
    }

    @Override
    public boolean rideable() {
        return this.prop.rideable;
    }

    public class_1309 method_5642() {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (this.isTamed() && this.rideable()) {
                return player;
            }
            return null;
        }
        return super.method_5642();
    }

    @Override
    public class_6862<class_1792> tamingItem() {
        return RunecraftoryTags.tamingTag(this.method_5864());
    }

    @Override
    public float tamingChance() {
        return this.prop.tamingChance;
    }

    @Override
    public boolean isTamed() {
        return this.method_6139() != null;
    }

    protected void tameEntity(class_1657 owner) {
        if (!this.method_5805()) {
            return;
        }
        this.method_18408(this.method_24515(), -1);
        this.setOwner(owner);
        this.field_6189.method_6340();
        BrainUtils.setTargetOfEntity((class_1309)this, null);
        this.method_37908().method_8421((class_1297)this, (byte)10);
        this.updater.setLastUpdateDay(WorldUtils.day(this.method_37908()));
        if (((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)owner)).party.isPartyFull()) {
            this.setBehaviour(Behaviour.WANDER);
        } else {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        this.method_37908().method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> {
            if (e == this) return false;
            if (!(e instanceof class_6025)) return false;
            class_6025 ownable = (class_6025)e;
            if (!this.method_6139().equals(ownable.method_6139())) return false;
            if (e.method_5968() != this) return false;
            return true;
        }).forEach(e -> {
            BrainUtils.setTargetOfEntity((class_1309)e, null);
            if (e.method_6065() == this) {
                e.method_6015(null);
            }
        });
        this.method_6015(null);
        if (owner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)owner;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)serverPlayer);
            data.entityStatsTracker.tameEntity(this);
            ((TameMonsterTrigger)((Object)RuneCraftoryCriteria.TAME_MONSTER_TRIGGER.get())).trigger(serverPlayer, this, data.entityStatsTracker);
            LevelCalc.levelSkill(data, Skills.TAMING, 10.0f);
            QuestHandler.getData(serverPlayer).trigger(TamingTracker.KEY, this);
        }
        if (this.method_5682() != null) {
            this.assignBarn();
        }
    }

    protected float tamingMultiplier(class_1657 player, class_1799 stack) {
        boolean flag = stack.method_31573(this.tamingItem());
        return flag ? 2.0f : 1.0f;
    }

    protected void untameEntity() {
        this.method_37908().method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> e != this && e.method_5968() == this).forEach(e -> {
            BrainUtils.setTargetOfEntity((class_1309)e, null);
            if (e.method_6065() == this) {
                e.method_6015(null);
            }
        });
        if (this.method_5682() != null && this.method_6139() != null) {
            RunecraftorySavedData.get(this.method_5682()).removeMonsterFromPlayer(this.method_6139(), this);
            if (this.getOwner() != null) {
                ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.getOwner())).party.removePartyMember((class_1297)this);
            } else {
                RunecraftorySavedData.get(this.method_5682()).toRemovePartyMember((class_1309)this);
            }
            this.assignedBarn = null;
        }
        this.setOwner(null);
        this.method_6015(null);
        if (this.playDeath()) {
            this.method_6025(this.method_6063());
        }
        this.setBehaviour(Behaviour.WANDER);
        this.updateAI(true, false);
        BrainUtils.setTargetOfEntity((class_1309)this, null);
        this.method_5942().method_6340();
    }

    private void playTameEffect(boolean play) {
        class_2400 particle = class_2398.field_11201;
        int amount = 13;
        if (!play) {
            particle = class_2398.field_11251;
            amount += 9;
        }
        for (int i = 0; i < amount; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            double d3 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8466((class_2394)particle, true, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d2, d3);
        }
    }

    private boolean findNearestBarn(boolean load) {
        if (load) {
            return this.assignBarn();
        }
        BarnData nearest = RunecraftorySavedData.get(this.method_5682()).findNearestFittingBarn(this, 5);
        if (nearest != null) {
            if (this.assignedBarn != null && this.assignedBarn != nearest) {
                this.assignedBarn.removeMonster(this);
            }
            this.assignedBarn = nearest;
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return this.assignBarn();
    }

    public BarnData getAssignedBarn() {
        this.assignBarn();
        return this.assignedBarn;
    }

    private boolean assignBarn() {
        if (!this.method_5805()) {
            return false;
        }
        if (this.assignedBarn == null || this.assignedBarn.isInvalidFor(this)) {
            this.assignedBarn = RunecraftorySavedData.get(this.method_5682()).findFittingBarn(this);
        }
        if (this.assignedBarn != null) {
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return false;
    }

    public class_2338 getSeedInventory() {
        if (this.seedInventory != null && !this.method_18407(this.seedInventory)) {
            return null;
        }
        return this.seedInventory;
    }

    public void setSeedInventory(class_2338 seedInventory) {
        this.seedInventory = seedInventory;
    }

    public class_2338 getCropInventory() {
        if (this.cropInventory != null && !this.method_18407(this.cropInventory)) {
            return null;
        }
        return this.cropInventory;
    }

    public void setCropInventory(class_2338 cropInventory) {
        this.cropInventory = cropInventory;
    }

    private class_2338 nearestBlockEntityWithInv() {
        class_2338 blockPos = this.method_18412();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int radius = (int)this.method_18413();
        for (int y = -1; y < 2; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutableBlockPos.method_25504((class_2382)blockPos, x, y, z);
                    if (!Platform.INSTANCE.matchingInventory(this.method_37908().method_8321((class_2338)mutableBlockPos), s -> true)) continue;
                    return mutableBlockPos.method_10062();
                }
            }
        }
        return null;
    }

    public String getInteractAnimation() {
        return null;
    }

    public void runInteractHandling(Runnable runnable) {
        if (this.getInteractAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getInteractAnimation());
            this.scheduledAnimationHandling = Pair.of((Object)this.getInteractAnimation(), (Object)runnable);
        } else {
            runnable.run();
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean clientSide = this.method_37908().field_9236;
        class_1799 stack = player.method_5998(hand);
        if (this.isTamed()) {
            if (!player.method_5667().equals(this.method_6139())) {
                if (!clientSide) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"runecraftory.monster.interact.notowner"), false);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (player.method_5715() && stack.method_7909() == class_1802.field_8600) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    EntityUtils.playSoundForPlayer(serverPlayer, (class_3414)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
                    this.untameEntity();
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (!clientSide && MobConfig.monsterNeedBarn && this.assignedBarn == null && !this.assignBarn()) {
                player.method_7353((class_2561)class_2561.method_43469((String)"runecraftory.monster.interact.barn.no", (Object[])new Object[]{this.method_5476()}), false);
                return class_1269.field_21466;
            }
            if (stack.method_7909() == RuneCraftoryItems.BRUSH.get()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    int day = WorldUtils.day(this.method_37908());
                    if (this.updater.getLastUpdateBrush() == day) {
                        return class_1269.field_5811;
                    }
                    EntityUtils.playSoundForPlayer(serverPlayer, (class_3414)RuneCraftorySounds.PLAYER_BRUSH.get(), class_3419.field_15254, 0.7f, 1.0f);
                    this.updater.setLastUpdateBrush(day);
                    this.onBrushing();
                    this.increaseFriendPoints(15);
                    this.method_37908().method_8421((class_1297)this, (byte)64);
                    player.method_6104(hand);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (hand == class_1268.field_5808 && !this.playDeath() && player.method_5715()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    EntityUtils.sendAttributesTo((class_1309)this, serverPlayer);
                    LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2COpenCompanionGui(this, serverPlayer), serverPlayer);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            return class_1269.field_5811;
        }
        if (player.method_5715() && !stack.method_7960()) {
            if (stack.method_7909() == RuneCraftoryItems.TAME.get()) {
                if (!clientSide) {
                    this.tameEntity(player);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
            if (stack.method_7909() == RuneCraftoryItems.BRUSH.get() && this.method_5805()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (this.tamingTick == -1) {
                        return class_1269.field_5811;
                    }
                    EntityUtils.playSoundForPlayer(serverPlayer, (class_3414)RuneCraftorySounds.PLAYER_BRUSH.get(), class_3419.field_15254, 0.7f, 1.0f);
                    this.brushCount = Math.min(10, this.brushCount + 1);
                    this.tamingTick = 40;
                    this.method_37908().method_8421((class_1297)this, (byte)64);
                }
                return class_1269.method_29236((boolean)clientSide);
            }
        }
        return class_1269.field_5811;
    }

    public void onBrushing() {
        class_6880 toIncrease = switch (this.field_5974.method_43048(4)) {
            case 1 -> RuneCraftoryAttributes.DEFENCE.asHolder();
            case 2 -> RuneCraftoryAttributes.MAGIC_ATTACK.asHolder();
            case 3 -> RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder();
            default -> class_5134.field_23721;
        };
        class_1324 inst = this.method_5996(toIncrease);
        if (inst != null) {
            class_1322 mod = inst.method_6199(LibConstants.MONSTER_BRUSH_MODIFIER);
            double inc = 1.0;
            if (mod != null) {
                inc += mod.comp_2449();
            }
            inst.method_6200(LibConstants.MONSTER_BRUSH_MODIFIER);
            inst.method_26837(new class_1322(LibConstants.MONSTER_BRUSH_MODIFIER, inc, class_1322.class_1323.field_6328));
        }
    }

    @Override
    public XpLevelHolder xpLevel() {
        return this.levelPair;
    }

    @Override
    public void setXPLevel(int level) {
        this.levelPair.setLevel(class_3532.method_15340((int)level, (int)1, (int)10000), lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl));
        this.updateStatsToLevel();
    }

    public void increaseLevel() {
        this.levelPair.setLevel(class_3532.method_15340((int)(this.xpLevel().getLevel() + 1), (int)1, (int)10000), lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl));
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        XpLevelHolder pair = this.xpLevel();
        boolean res = pair.addXP(amount, 10000, lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl), () -> {});
        LoaderNetwork.INSTANCE.sendToTracking((class_8710)S2CEntityLevelPkt.create(this), (class_1297)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateStatsToLevel() {
        if (!this.method_37908().field_9236) {
            LoaderNetwork.INSTANCE.sendToTracking((class_8710)S2CEntityLevelPkt.create(this), (class_1297)this);
        }
        float preHealthDiff = this.method_6063() - this.method_6032();
        this.prop.levelGains().forEach((att, val) -> {
            class_1324 inst = this.method_5996((class_6880)att);
            if (inst != null) {
                val = val * 0.01;
                inst.method_6200(LibConstants.MONSTER_LEVEL_MODIFIER);
                float levelBonus = att == class_5134.field_23716 ? LevelCalc.getIntervalledMultiplier(this.xpLevel().getLevel(), 10, 100.0f, 1.0f) : LevelCalc.getIntervalledMultiplier(this.xpLevel().getLevel(), 25, 100.0f, 1.0f);
                inst.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * val, class_1322.class_1323.field_6328));
                if (att == class_5134.field_23716) {
                    this.method_6033(this.method_6063() - preHealthDiff);
                }
            }
        });
    }

    @Override
    public int friendPoints(UUID player) {
        if (player.equals(this.method_6139())) {
            return (Integer)this.field_6011.method_12789(FRIEND_POINTS_SYNC);
        }
        return 0;
    }

    public void increaseFriendPoints(int xp) {
        boolean leveledUp = this.friendlyPoints.addXP(xp, 10, lvl -> GeneralConfig.friendPointsExperience.xpAmountForNext(lvl), () -> this.field_6011.method_12778(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel()));
        if (leveledUp) {
            this.updateFriendPointAttributeBonus();
        }
    }

    private void updateFriendPointAttributeBonus() {
        List<class_6880> increasable = List.of(class_5134.field_23716, class_5134.field_23721, RuneCraftoryAttributes.DEFENCE.asHolder(), RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
        for (class_6880 att : increasable) {
            class_1324 inst = this.method_5996(att);
            if (inst == null) continue;
            double inc = (double)(this.friendlyPoints.getLevel() - 1) * (att == class_5134.field_23716 ? 0.02 : 0.01);
            inst.method_6200(LibConstants.FRIENDSHIP_MODIFIER);
            inst.method_26837(new class_1322(LibConstants.FRIENDSHIP_MODIFIER, inc, class_1322.class_1323.field_6331));
        }
    }

    public void recalcStatsFull() {
        this.applyAttributes();
        this.updateStatsToLevel();
        this.updateFriendPointAttributeBonus();
    }

    @Override
    public int baseXP() {
        return this.prop.xp;
    }

    @Override
    public int baseMoney() {
        return this.prop.money;
    }

    @Override
    public boolean isFlyingEntity() {
        return this.prop.flying;
    }

    public void onDailyUpdate(int daysPassed) {
        if (this.method_37908() instanceof class_3218 && this.isTamed() && !this.playDeath()) {
            if (!MobConfig.monsterNeedBarn || this.assignBarn()) {
                class_5321<class_52> resourceLocation = this.dailyDropTable();
                this.dropAsDailyDrop(resourceLocation);
            }
            if (this.behaviourState() == Behaviour.FARM) {
                float cost = 0.2f * (float)this.friendPoints(this.method_6139());
                cost -= 0.1f * class_3532.method_15363((float)((float)this.friendPoints(this.method_6139()) / 10.0f), (float)0.0f, (float)1.0f);
                TendCrops.setHealthTo(this, this.method_6032() - this.method_6063() * (cost *= (float)daysPassed));
            }
        }
    }

    public class_5321<class_52> dailyDropTable() {
        class_5321 def = this.method_5991();
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)def.method_29177().method_12836(), (String)(def.method_29177().method_12832() + "_tamed_drops")));
    }

    protected void dropAsDailyDrop(class_5321<class_52> resourceLocation) {
        class_52 lootTable = this.method_37908().method_8503().method_58576().method_58295(resourceLocation);
        lootTable.method_51882(this.dailyDropContext().method_51875(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((BaseMonster)this).method_5775(arg_0));
    }

    protected class_8567.class_8568 dailyDropContext() {
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538());
        if (this.method_6139() != null) {
            builder.method_51877(LootCtxParameters.UUID_CONTEXT, (Object)this.method_6139());
        }
        return builder;
    }

    protected void method_5964(class_5819 source, class_1266 difficulty) {
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        this.method_5964(this.method_59922(), difficulty);
        this.setXPLevel(class_3532.method_15340((int)this.xpLevel().getLevel(), (int)this.prop.minLevel, (int)10000));
        if (this.getSpawnAnimation() != null && reason != class_3730.field_16462 && reason != class_3730.field_16470) {
            this.getAnimationHandler().setAnimation(this.getSpawnAnimation());
        }
        ((AttributeMapAccessor)this.method_6127()).getAttributes().forEach((att, inst) -> {
            if (att.method_40220(RunecraftoryTags.Attributes.RANDOMIZABLE_ATTRIBUTES)) {
                inst.method_61163(new class_1322(LibConstants.MONSTER_RANDOM_SPAWN_BONUS, 0.2 * this.method_59922().method_43058() - 0.1, class_1322.class_1323.field_6331));
            }
        });
        this.method_6033(this.method_6063());
        return spawnData;
    }

    public String getSpawnAnimation() {
        return null;
    }

    public float method_55693() {
        return super.method_55693() * this.defaultScale;
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.isTamed();
    }

    public boolean method_17326() {
        return super.method_17326() || this.isTamed();
    }

    public void method_5837(class_3222 player) {
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)S2CEntityLevelPkt.create(this), player);
    }

    public void method_31744(class_5569 levelCallback) {
        super.method_31744(WorldUtils.wrappedCallbackFor(this, this::getOwner, levelCallback));
    }

    @Override
    public boolean onGivingItem(class_1657 player, class_1799 stack) {
        if (this.isTamed()) {
            if (!player.method_5667().equals(this.method_6139())) {
                return false;
            }
            if (this.method_5626((class_1297)player)) {
                return false;
            }
            if (this.feedTimeOut <= 0) {
                boolean favorite = stack.method_31573(this.tamingItem());
                int count = stack.method_7947();
                class_3414 sound = switch (stack.method_7976()) {
                    case class_1839.field_8946 -> stack.method_21832();
                    case class_1839.field_8950 -> stack.method_21833();
                    default -> (class_3414)class_3417.field_14622.comp_349();
                };
                boolean food = this.applyFoodEffect(stack);
                if (food || !this.playDeath()) {
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        EntityUtils.playSoundForPlayer(serverPlayer, sound, class_3419.field_15254, 0.7f, 1.0f);
                        ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)serverPlayer)).getDailyUpdater().onGiveMonsterItem();
                    }
                    stack.method_7939(count);
                    this.feedTimeOut = 7;
                    int day = WorldUtils.day(this.method_37908());
                    if (this.updater.getLastUpdateFood() != day) {
                        this.updater.setLastUpdateFood(day);
                        this.increaseFriendPoints(favorite ? 50 : 30);
                        if (favorite) {
                            this.method_37908().method_8421((class_1297)this, (byte)65);
                        } else {
                            this.method_37908().method_8421((class_1297)this, (byte)64);
                        }
                        DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).ifPresent(s -> s.getMonsterGiftIncrease().forEach((att, d) -> {
                            class_1324 inst = this.method_5996((class_6880)att);
                            if (inst != null) {
                                class_1322 mod = inst.method_6199(LibConstants.MONSTER_GIFT_MODIFIER);
                                double val = d;
                                if (mod != null) {
                                    val += mod.comp_2449();
                                    inst.method_6202(mod);
                                }
                                inst.method_26837(new class_1322(LibConstants.MONSTER_GIFT_MODIFIER, val, class_1322.class_1323.field_6328));
                            }
                        }));
                    }
                    stack.method_7934(1);
                }
                return true;
            }
        } else if (this.tamingTick == -1 && this.method_5805()) {
            class_3414 sound;
            switch (stack.method_7976()) {
                case field_8946: {
                    class_3414 class_34142 = stack.method_21832();
                    break;
                }
                case field_8950: {
                    class_3414 class_34142 = stack.method_21833();
                    break;
                }
                default: {
                    class_3414 class_34142 = sound = (class_3414)class_3417.field_14622.comp_349();
                }
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                EntityUtils.playSoundForPlayer(serverPlayer, sound, class_3419.field_15254, 0.7f, 1.0f);
            }
            float rightItemMultiplier = this.tamingMultiplier(player, stack);
            int count = stack.method_7947();
            this.applyFoodEffect(stack);
            if (count == stack.method_7947() && !player.method_7337()) {
                stack.method_7934(1);
            }
            this.tamingTick = 60;
            float chance = EntityUtils.tamingChance(this, player, rightItemMultiplier, this.brushCount, this.loveAttCount);
            if (!(this.method_5682() == null || MobConfig.monsterNeedBarn && RunecraftorySavedData.get(this.method_5682()).findFittingBarn(this, player.method_5667()) == null)) {
                this.delayedTaming = () -> {
                    if (chance == 0.0f) {
                        this.method_37908().method_8421((class_1297)this, (byte)34);
                    } else if (this.field_5974.method_43057() < chance) {
                        this.tameEntity(player);
                    } else {
                        this.method_37908().method_8421((class_1297)this, (byte)11);
                    }
                };
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyFoodEffect(class_1799 stack) {
        FoodProperties food;
        if (this.method_37908().field_9236) {
            return false;
        }
        if (stack.method_7909() == RuneCraftoryItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((class_1309)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909())) == null) {
            class_4174 mcFood = (class_4174)stack.method_57824(class_9334.field_50075);
            this.method_60492(this.method_37908(), stack);
            if (mcFood != null) {
                this.method_6025((float)mcFood.comp_2491() * 0.5f);
                return true;
            }
            return false;
        }
        this.method_60492(this.method_37908(), stack);
        Pair<Map<class_6880<class_1320>, Double>, Map<class_6880<class_1320>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            class_1324 inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.method_5996((class_6880)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_MODIFIER_MULTI);
                inst.method_26837(new class_1322(LibConstants.FOOD_MODIFIER_MULTI, ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6330));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.method_5996((class_6880)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_MODIFIER);
                inst.method_26837(new class_1322(LibConstants.FOOD_MODIFIER, ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6328));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((class_1309)this, food.getHPGain());
        EntityUtils.foodHealing((class_1309)this, this.method_6063() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (class_6880 class_68802 : food.potionHeals()) {
                this.method_6016(class_68802);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.method_6092(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.method_6127()).getAttributes().values().forEach(inst -> {
            inst.method_6200(LibConstants.FOOD_MODIFIER);
            inst.method_6200(LibConstants.FOOD_MODIFIER_MULTI);
        });
    }

    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public class_1657 getOwner() {
        UUID uuid = this.method_6139();
        if (uuid != null) {
            if (this.owner == null || !this.owner.method_5805()) {
                this.owner = this.method_37908().field_9236 ? this.method_37908().method_18470(uuid) : this.method_37908().method_8503().method_3760().method_14602(uuid);
            }
        } else {
            this.owner = null;
        }
        return this.owner;
    }

    @Override
    public void setOwner(class_1657 player) {
        if (player != null) {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(player.method_5667()));
        } else {
            this.field_6011.method_12778(OWNER_UUID, Optional.empty());
        }
    }

    public void method_18402(class_2338 pos) {
        super.method_18402(pos);
        this.setSleeping(true);
    }

    public void method_18399() {
        super.method_18399();
        this.setSleeping(false);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.onSleeping(sleeping);
    }

    @Override
    public boolean hasSleepingAnimation() {
        return this.getSleepAnimation() != null;
    }

    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            if (this.getSleepAnimation() != null) {
                this.getAnimationHandler().setAnimation(this.getSleepAnimation());
                if (this.field_5953 && this.method_37908().field_9236) {
                    AnimationState anim = this.getAnimationHandler().getAnimation();
                    while (!anim.done(0)) {
                        anim.tick();
                    }
                }
            }
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    public String getSleepAnimation() {
        return null;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public static enum Behaviour {
        WANDER("runecraftory.monster.interact.wander", false),
        WANDER_HOME("runecraftory.monster.interact.home", false),
        FOLLOW("runecraftory.monster.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.monster.interact.follow.distance", true),
        STAY("runecraftory.monster.interact.stay", true),
        FARM("runecraftory.monster.interact.farm", false);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }

    public record CombatRecord(class_3222 player, class_1282 lastSource, float totalDamage) {
    }
}

