/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.tenshilib.common.entity.OverlayEntityRender;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class BossMonster
extends BaseMonster
implements OverlayEntityRender {
    public static int DEATH_DURATION = 140;
    protected static final List<Supplier<class_6880<class_1320>>> STAT_INCREASE = List.of(() -> class_5134.field_23721, () -> RuneCraftoryAttributes.DEFENCE.asHolder(), () -> RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), () -> RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
    protected static final class_2960 STAT_INCREASE_ID = RuneCraftory.modRes("boss_enraged_buff");
    private static final class_2940<Boolean> ENRAGED = class_2945.method_12791(BossMonster.class, (class_2941)class_2943.field_13323);
    protected final RunecraftoryBossbar bossInfo = this.createBossBar();
    private int combatTick;
    private int noPlayerRegenTick;
    private int fullHealDelay;
    private class_5321<class_1937> restrictDimension;
    protected int deathRays;

    public BossMonster(class_1299<? extends BossMonster> type, class_1937 level) {
        super(type, level);
    }

    public static <T extends BaseMonster> ImmutableMap<String, BiConsumer<AnimationState, T>> createAnimationHandler(Consumer<ImmutableMap.Builder<String, BiConsumer<AnimationState, T>>> cons) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        cons.accept(builder);
        return (ImmutableMap)builder.build().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ENRAGED, (Object)false);
    }

    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            if (!this.isTamed() && this.method_5805()) {
                this.updatePlayers();
                this.updateBossBar();
                if ((this.method_5968() == null || !this.method_5968().method_5805()) && this.bossInfo.method_14092().stream().noneMatch(class_1657::method_33190)) {
                    if (++this.combatTick > 200 && ++this.noPlayerRegenTick > 40) {
                        this.method_6025(this.method_6063() * 0.1f);
                        if (this.method_6032() >= this.method_6063()) {
                            this.fullyHeal();
                        }
                        this.noPlayerRegenTick = 0;
                    }
                    if (this.combatTick > 300 && this.method_18410() && !this.method_18411() && this.restrictDimension != null) {
                        class_2338 restrict = this.method_18412();
                        if (this.method_37908().method_27983() == this.restrictDimension) {
                            TeleportSpell.safeTeleportTo((class_1297)this, restrict.method_10263(), restrict.method_10264(), restrict.method_10260());
                        } else {
                            class_3218 serverLevel = this.method_5682().method_3847(this.restrictDimension);
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((class_1297)this, serverLevel, restrict.method_10263(), restrict.method_10264(), restrict.method_10260());
                            }
                        }
                    }
                } else {
                    this.combatTick = 0;
                    this.noPlayerRegenTick = 0;
                }
            }
            if (--this.fullHealDelay == 1) {
                this.fullyHeal();
            }
        }
        if (this.method_5805()) {
            this.field_6213 = 0;
            this.deathRays = 0;
        }
    }

    public void method_18408(@Nullable class_2338 pos, int distance) {
        super.method_18408(pos, distance);
        this.restrictDimension = this.method_37908().method_27983();
    }

    public void method_35055() {
        super.method_35055();
        this.restrictDimension = null;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.transitionalAnimations() && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.transitionalAnimations();
    }

    protected boolean transitionalAnimations() {
        return this.getSpawnAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSpawnAnimation()}) || this.getDeathAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getDeathAnimation()});
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Enraged", this.isEnraged());
        compound.method_10569("FullHealDelay", this.fullHealDelay);
        if (this.restrictDimension != null) {
            compound.method_10582("RestrictDim", this.restrictDimension.method_29177().toString());
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setEnraged(compound.method_10577("Enraged"), true);
        this.fullHealDelay = compound.method_10550("FullHealDelay");
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
        if (compound.method_10545("RestrictDim")) {
            this.restrictDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)compound.method_10558("RestrictDim")));
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    @Override
    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void setOwner(class_1657 player) {
        super.setOwner(player);
        if (player != null) {
            this.bossInfo.method_14094();
        }
    }

    @Override
    protected void method_6108() {
        super.method_6108();
        if (!this.method_37908().field_9236 && this.field_6213 == 1) {
            this.updateBossBar();
        }
        if (this.method_37908().field_9236) {
            if (this.field_6213 < 50) {
                if (this.field_6213 % 10 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 1.0f);
                    this.method_37908().method_55116((class_1297)this, (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 2.0f, 0.8f);
                }
            } else if (this.field_6213 < 74) {
                if (this.field_6213 % 5 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 1.0f);
                    this.method_37908().method_55116((class_1297)this, (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 2.0f, 0.8f);
                }
            } else if (this.field_6213 < 95) {
                if (this.field_6213 % 3 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 1.0f);
                    this.method_37908().method_55116((class_1297)this, (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 2.0f, 0.8f);
                }
            } else if (this.field_6213 < 120 && this.field_6213 % 2 == 0) {
                ++this.deathRays;
                S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 1.0f);
                this.method_37908().method_55116((class_1297)this, (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 2.0f, 0.8f);
            }
        }
        if (!this.method_37908().field_9236 && this.field_6213 >= this.maxDeathTime()) {
            S2CScreenShake.sendAround((class_1297)this, 24.0, 4, 3.0f);
            this.method_5783(this.getBossDeathSound(), 2.0f, 1.0f);
        }
    }

    @Override
    public int maxDeathTime() {
        return DEATH_DURATION;
    }

    @Override
    public int deathRays() {
        return this.deathRays;
    }

    @Override
    protected float tamingMultiplier(class_1657 player, class_1799 stack) {
        if (((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).entityStatsTracker.getKillCount(this.method_5864()) == 0) {
            return 0.0f;
        }
        boolean flag = stack.method_31573(this.tamingItem());
        return flag ? 1.0f : 0.0f;
    }

    @Override
    protected void tameEntity(class_1657 owner) {
        super.tameEntity(owner);
        this.setEnraged(false, false);
    }

    public boolean isEnraged() {
        return this.method_5805() && !this.isTamed() && (Boolean)this.field_6011.method_12789(ENRAGED) != false;
    }

    public void setEnraged(boolean flag, boolean load) {
        this.field_6011.method_12778(ENRAGED, (Object)flag);
        if (!load) {
            if (flag) {
                STAT_INCREASE.forEach(att -> {
                    class_1324 inst = this.method_5996((class_6880)att.get());
                    if (inst.method_6199(STAT_INCREASE_ID) == null) {
                        inst.method_26837(new class_1322(STAT_INCREASE_ID, 0.25, class_1322.class_1323.field_6331));
                    }
                });
            } else {
                STAT_INCREASE.forEach(att -> this.method_5996((class_6880)att.get()).method_6200(STAT_INCREASE_ID));
            }
        }
        if (flag && !load && this.method_5805() && this.getAngryAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getAngryAnimation());
        }
    }

    @Override
    public int animationCooldown(String anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 20 + this.method_59922().method_43048(30) : 30 + this.method_59922().method_43048(35)) + diffAdd;
    }

    protected void updateBossBar() {
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
    }

    @Override
    protected void method_6074(class_1282 source, float damageAmount) {
        super.method_6074(source, damageAmount);
        this.combatTick = 0;
        if (!this.isTamed() && this.checkRage()) {
            this.setEnraged(true, false);
        }
    }

    @Override
    public void onDeathDamageRecord(class_3222 player, class_1282 source, float damage) {
        super.onDeathDamageRecord(player, source, damage);
        if (!this.isTamed() && (double)damage > (double)this.method_6063() * 0.05 && (this.field_6232 <= 0 || player != this.method_6124())) {
            player.method_5716((class_1297)this, this.field_6232, source);
        }
    }

    protected boolean checkRage() {
        return (double)(this.method_6032() / this.method_6063()) < 0.5 && !this.isEnraged();
    }

    protected void fullyHeal() {
        this.method_6025(this.method_6063());
        this.setEnraged(false, false);
    }

    private void updatePlayers() {
        HashSet<class_3222> set = new HashSet<class_3222>();
        for (class_3222 serverPlayer : this.method_37908().method_8390(class_3222.class, this.arenaAABB(), e -> true)) {
            this.bossInfo.method_14088(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set2 = Sets.newHashSet((Iterable)this.bossInfo.method_14092());
        set2.removeAll(set);
        for (class_3222 serverPlayer : set2) {
            this.bossInfo.removePlayerFading(serverPlayer);
        }
    }

    public class_238 arenaAABB() {
        if (this.method_18410()) {
            return new class_238(this.method_18412()).method_1014((double)(this.method_18413() + 1.0f));
        }
        return this.method_5829().method_1014(Math.max(48.0, this.method_45325(class_5134.field_23717) + 1.0));
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        for (class_3222 player : this.bossInfo.method_14092()) {
            this.method_5742(player);
        }
    }

    @Override
    public void method_5837(class_3222 player) {
        super.method_5837(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
        if (this.method_5805() && !this.isTamed() && player.method_31481() && this.bossInfo.method_14092().stream().noneMatch(class_1657::method_33190)) {
            this.fullHealDelay = 10;
        }
    }

    public int overlayU(int orig) {
        return this.isEnraged() ? (int)(Math.sin((float)this.field_6012 / 7.0f) * 5.0 + 5.0) : orig;
    }

    public int overlayV(int orig) {
        return this.isEnraged() ? 0 : orig;
    }

    public void method_5966() {
        if (this.getSpawnAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSpawnAnimation()})) {
            return;
        }
        super.method_5966();
    }

    protected class_3414 getBossDeathSound() {
        return (class_3414)RuneCraftorySounds.ENTITY_BOSS_DEFEAT.get();
    }

    public void playRandomizedSound(class_3414 event) {
        this.method_5783(event, 1.0f, (this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.2f + 0.8f);
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (prev == null) {
            return super.allowAnimation(null, other);
        }
        return !prev.equals(other);
    }

    public String getAngryAnimation() {
        return null;
    }
}

