/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToAttackTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToWalkTargetWithSight;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetAnimationToPlay;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class MonsterBehaviourUtils {
    public static <E extends BaseMonster> Predicate<E> chancedStart(Supplier<Float> floats) {
        return entity -> {
            if (entity.method_59922().method_43057() < ((Float)floats.get()).floatValue()) {
                return true;
            }
            if (!BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_22475)) {
                int cooldown = entity.animationCooldown(null);
                BrainUtils.setForgettableMemory((class_1309)entity, (class_4140)class_4140.field_22475, (Object)true, (int)cooldown);
            }
            return false;
        };
    }

    public static <E extends BaseMonster> SetAnimationToPlay<E> checkedAttack(String ... animations) {
        return new SetAnimationToPlay(animations).filter((animation, entity) -> {
            String previous = (String)BrainUtils.getMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()));
            return entity.allowAnimation(previous, (String)animation);
        });
    }

    @SafeVarargs
    public static <E extends BaseMonster> SetAnimationToPlay<E> checkedAttack(AnimationPlayHolder<E> ... animations) {
        return new SetAnimationToPlay(animations).filter((animation, entity) -> {
            String previous = (String)BrainUtils.getMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()));
            return entity.allowAnimation(previous, (String)animation);
        });
    }

    public static <E extends BaseMonster> PlayAnimation<E> cooldownedPlay() {
        return MonsterBehaviourUtils.cooldownedPlay(null);
    }

    public static <E extends BaseMonster> PlayAnimation<E> requireInRangePlay() {
        return MonsterBehaviourUtils.cooldownedPlay(entity -> {
            AnimationPlayHolder anim = (AnimationPlayHolder)BrainUtils.getMemory((class_1309)entity, (class_4140)((class_4140)TenshilibMemoryModules.ANIMATION_TO_PLAY.get()));
            class_1309 target = BrainUtils.getTargetOfEntity((class_1309)entity);
            return target != null && entity.isInAttackBox((class_1297)target, anim.animation());
        });
    }

    public static <E extends BaseMonster> PlayAnimation<E> cooldownedPlay(Predicate<E> condition) {
        PlayAnimation behaviour = new PlayAnimation().withCallback(MonsterBehaviourUtils.cooldownHandler()).withCallback(MonsterBehaviourUtils.cooldownHandlerCont());
        if (condition != null) {
            behaviour.startCondition(condition);
        }
        return behaviour;
    }

    public static <E extends BaseMonster> PlayAnimation.OnStart<E> cooldownHandler() {
        return (animation, entity) -> {
            double calc = entity.animationCooldown(animation);
            int cooldown = class_3532.method_15384((double)(calc += entity.getAnimationHandler().get(animation).length()));
            BrainUtils.setForgettableMemory((class_1309)entity, (class_4140)class_4140.field_22475, (Object)true, (int)cooldown);
            BrainUtils.setForgettableMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()), (Object)animation, (int)(cooldown + 80));
        };
    }

    public static <E extends BaseMonster> PlayAnimation.OnContinue<E> cooldownHandlerCont() {
        return (animation, chains, entity) -> {
            double calc = BrainUtils.getTimeUntilMemoryExpires((class_1309)entity, (class_4140)class_4140.field_22475);
            if (chains != null) {
                for (AnimationPlayHolder.AnimationHolder chain : chains) {
                    calc += entity.getAnimationHandler().get(chain.animation()).length();
                }
                int cooldown = class_3532.method_15384((double)calc);
                BrainUtils.setForgettableMemory((class_1309)entity, (class_4140)class_4140.field_22475, (Object)true, (int)cooldown);
                BrainUtils.setForgettableMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()), (Object)animation, (int)cooldown);
            }
        };
    }

    public static <T extends BaseMonster> Predicate<T> inAABBRange(String animation) {
        return entity -> {
            class_1309 target = BrainUtils.getTargetOfEntity((class_1309)entity);
            return target != null && entity.isInAttackBox((class_1297)target, animation);
        };
    }

    public static <E extends class_1309> ToIntBiFunction<E, class_1309> closeEnough(int dist) {
        return (entity, target) -> dist;
    }

    public static <E extends class_1308> Predicate<E> ifCloserThan(double dist) {
        return entity -> {
            class_1309 target = entity.method_5968();
            if (target == null) {
                return false;
            }
            double distance = dist + (double)entity.method_17681() * 0.5 + (double)target.method_17681() * 0.5;
            return entity.method_5858((class_1297)target) <= distance * distance;
        };
    }

    public static <E extends class_1308> Predicate<E> ifFurtherThan(double dist) {
        return entity -> {
            class_1309 target = entity.method_5968();
            if (target == null) {
                return false;
            }
            double distance = dist + (double)entity.method_17681() * 0.5 + (double)target.method_17681() * 0.5;
            return entity.method_5858((class_1297)target) >= distance * distance;
        };
    }

    public static <E extends class_1309> Consumer<ExtendedBehaviour<E>> withCondition(Predicate<E> test) {
        return behaviour -> {
            behaviour.startCondition(test);
            behaviour.stopIf(e -> !test.test(e));
        };
    }

    public static <E extends class_1314 & AnimatedEntity> MoveToAttackTarget<E> timedMovement() {
        return MonsterBehaviourUtils.timedMovement(30, 45);
    }

    public static <E extends class_1314 & AnimatedEntity> MoveToAttackTarget<E> timedMovement(int min, int max) {
        MoveToAttackTarget<E> behaviour = MonsterBehaviourUtils.moveAttack();
        behaviour.runFor(e -> min + e.method_59922().method_43048(max - min));
        return behaviour;
    }

    public static <E extends class_1314 & AnimatedEntity> MoveToAttackTarget<E> moveAttack() {
        MoveToAttackTarget behaviour = new MoveToAttackTarget();
        behaviour.runFor(e -> 100);
        return behaviour;
    }

    public static <E extends class_1314> MoveToWalkTargetWithSight<E> moveTo() {
        return new MoveToWalkTargetWithSight();
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T> ... and) {
        return t -> {
            for (Predicate pred : and) {
                if (pred.test(t)) continue;
                return false;
            }
            return true;
        };
    }
}

