/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.runecraftory.common.utils.BlockPlaceCtxHelper;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5575;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;

public class TendCrops<E extends BaseMonster>
extends ExtendedBehaviour<E> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORIES = MemoryTest.builder((int)1).hasMemory((class_4140)RuneCraftoryMemoryTypes.FARMING.get());
    private static final Predicate<class_1799> SEED_ITEM = s -> !s.method_7960() && s.method_7909() instanceof class_1747 && (s.method_31573(RunecraftoryTags.Items.SEEDS) || s.method_7909() == class_1802.field_8567 || s.method_7909() == class_1802.field_8179);
    private final List<class_2338> toTend = new ArrayList<class_2338>();
    private class_2338 selected;
    private int cooldown;
    private boolean canPlant;

    public static boolean cantTendToCropsAnymore(BaseMonster monster) {
        return (double)class_3532.method_15375((float)monster.method_6032()) <= Math.max(1.0, (double)monster.method_6063() * 0.05);
    }

    public static void setHealthTo(BaseMonster monster, float health) {
        monster.method_6033(Math.max(health, monster.method_6063() * 0.05f));
    }

    public TendCrops() {
        this.cooldownFor(e -> 40);
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        return !TendCrops.cantTendToCropsAnymore(entity) && entity.method_18410();
    }

    protected boolean canStillUse(class_3218 level, E entity, long gameTime) {
        return !this.toTend.isEmpty();
    }

    protected void start(E entity) {
        this.toTend.clear();
        this.canPlant = ((BaseMonster)entity).getSeedInventory() != null && Platform.INSTANCE.matchingInventory(entity.method_37908().method_8321(((BaseMonster)entity).getSeedInventory()), SEED_ITEM);
        class_2338 center = entity.method_18412();
        class_2338.class_2339 mutable = entity.method_18412().method_25503();
        int radius = MobConfig.farmRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    mutable.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                    if (!this.validPos((class_2338)mutable, entity.method_37908())) continue;
                    this.toTend.add(new class_2338((class_2382)mutable));
                }
            }
        }
        if (!this.toTend.isEmpty()) {
            this.selected = this.toTend.remove(entity.method_59922().method_43048(this.toTend.size()));
        }
    }

    private boolean validPos(class_2338 pos, class_1937 level) {
        class_2302 crop;
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2302 && (crop = (class_2302)block).method_9825(state)) {
            return true;
        }
        class_2680 state2 = level.method_8320(pos.method_10074());
        if (state2.method_26164(RunecraftoryTags.Blocks.FARMLAND) && (Integer)state2.method_11654((class_2769)class_2344.field_11009) < 7) {
            return true;
        }
        if (state2.method_26204() instanceof class_2344) {
            if (state.method_26164(RunecraftoryTags.Blocks.MONSTER_CLEARABLE)) {
                return true;
            }
            if (this.canPlant) {
                return state.method_26215();
            }
        }
        return false;
    }

    protected void tick(E entity) {
        if (entity.getAnimationHandler().hasAnimation() || --this.cooldown > 0) {
            return;
        }
        if (this.selected == null) {
            if (this.toTend.isEmpty()) {
                return;
            }
            this.selected = this.toTend.remove(entity.method_59922().method_43048(this.toTend.size()));
            boolean bl = this.canPlant = ((BaseMonster)entity).getSeedInventory() != null && Platform.INSTANCE.matchingInventory(entity.method_37908().method_8321(((BaseMonster)entity).getSeedInventory()), SEED_ITEM);
            if (!this.validPos(this.selected, entity.method_37908())) {
                this.selected = null;
                this.cooldown = 10;
                return;
            }
        }
        if (!this.selected.method_19769((class_2374)entity.method_19538(), Math.max(1.1, (double)entity.method_17681() * 1.9))) {
            class_243 to = class_243.method_24953((class_2382)this.selected);
            class_11 path = entity.method_5942().method_6352(to.method_10216(), to.method_10214(), to.method_10215(), 0);
            entity.method_5942().method_6334(path, 1.0);
            this.cooldown = entity.method_59922().method_43048(5) + 5;
        } else {
            class_2338 selected = this.selected;
            class_2680 state = entity.method_37908().method_8320(selected);
            class_2248 block = state.method_26204();
            Runnable run = () -> {
                class_2302 crop;
                boolean success = false;
                if (state.method_26164(RunecraftoryTags.Blocks.MONSTER_CLEARABLE)) {
                    TendCrops.breakBlock(entity, selected, entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(entity.method_37908().method_8321(entity.getCropInventory()), (class_1799)s) : null);
                } else if (block instanceof class_2302 && (crop = (class_2302)block).method_9825(state)) {
                    CropUtils.harvestCropRightClick(state, entity.method_37908(), selected, (class_1297)entity, class_1799.field_8037, DataPackHandler.INSTANCE.cropManager().get((class_2248)crop), class_1268.field_5808, entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(entity.method_37908().method_8321(entity.getCropInventory()), (class_1799)s) : null);
                    entity.method_37908().method_18023(class_5575.method_31795(class_1542.class), entity.method_5829().method_1014(0.2), e -> true);
                    success = true;
                } else {
                    class_2338 pos = selected.method_10074();
                    class_2680 state2 = entity.method_37908().method_8320(pos);
                    if (state2.method_26164(RunecraftoryTags.Blocks.FARMLAND)) {
                        class_1792 patt0$temp;
                        class_1799 stack;
                        if ((Integer)state2.method_11654((class_2769)class_2344.field_11009) < 7) {
                            FarmlandHandler.waterLand((class_3218)entity.method_37908(), pos, state2);
                            success = true;
                        } else if (state.method_26215() && entity.getSeedInventory() != null && !(stack = Platform.INSTANCE.findMatchingItem(entity.method_37908().method_8321(entity.getSeedInventory()), SEED_ITEM, 1)).method_7960() && (patt0$temp = stack.method_7909()) instanceof class_1747) {
                            class_1747 blockItem = (class_1747)patt0$temp;
                            blockItem.method_7712(BlockPlaceCtxHelper.entityPlaceAt(entity.method_37908(), stack, selected, class_2350.field_11036));
                            entity.method_37908().method_8652(selected, blockItem.method_7711().method_9564(), 3);
                            entity.method_37908().method_43128(null, (double)selected.method_10263(), (double)selected.method_10264(), (double)selected.method_10260(), class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
                            stack.method_7934(1);
                            success = true;
                        }
                    }
                }
                if (success) {
                    entity.addXp(5 + entity.method_59922().method_43048(5));
                }
            };
            ((BaseMonster)entity).runInteractHandling(run);
            this.selected = null;
            this.cooldown = entity.method_59922().method_43048(15) + 20;
        }
    }

    public void stop(E entity) {
        super.stop(entity);
        this.toTend.clear();
        this.selected = null;
    }

    private static <E extends class_1297> void breakBlock(E entity, class_2338 pos, Function<class_1799, class_1799> stackConsumer) {
        class_2586 blockEntity;
        class_3218 level = (class_3218)entity.method_37908();
        class_2680 state = level.method_8320(pos);
        level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        class_2586 class_25862 = blockEntity = state.method_31709() ? level.method_8321(pos) : null;
        if (stackConsumer != null) {
            class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)blockEntity, entity, (class_1799)class_1799.field_8037).forEach(s -> {
                class_1799 rest = (class_1799)stackConsumer.apply((class_1799)s);
                if (!rest.method_7960()) {
                    class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)rest);
                }
            });
            state.method_26180(level, pos, class_1799.field_8037, false);
        } else {
            class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, (class_2586)blockEntity, entity, (class_1799)class_1799.field_8037);
        }
        level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
    }
}

