/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.DoNPCAttackAction;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SerializableBehaviour;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.DummyBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_2048;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_5699;
import net.minecraft.class_8567;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.util.BrainUtils;

public class NPCAttackActions {
    public static final Codec<NPCAttackActions> CODEC = NPCAttackSequence.CODEC.listOf().xmap(NPCAttackActions::new, h -> h.behaviours);
    public static final ReloadableHolder<NPCAttackActions> DEFAULT = new ReloadableHolder<NPCAttackActions>(RuneCraftory.modRes("default_action"), new NPCAttackActions(List.of()));
    private final List<NPCAttackSequence> behaviours;

    public NPCAttackActions(List<NPCAttackSequence> behaviours) {
        this.behaviours = behaviours;
    }

    public static class_47 createLootContext(NPCEntity npc) {
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)npc.method_37908()).method_51874(class_181.field_1226, (Object)npc).method_51874(class_181.field_24424, (Object)npc.method_19538());
        return new class_47.class_48(builder.method_51875(class_173.field_24423)).method_60568(npc.method_59922()).method_309(Optional.empty());
    }

    public static Builder builder() {
        return new Builder();
    }

    public ExtendedBehaviour<NPCEntity> create() {
        if (this.behaviours.isEmpty()) {
            return new InvalidateMemory(class_4140.field_22355);
        }
        if (this.behaviours.size() == 1) {
            return this.behaviours.getFirst().create().startCondition(npc -> !npc.getAnimationHandler().hasAnimation() && !BrainUtils.hasMemory((class_1309)npc, (class_4140)class_4140.field_22475)).stopIf(npc -> BrainUtils.hasMemory((class_1309)npc, (class_4140)class_4140.field_22475));
        }
        return new OneRandomBehaviour((Pair[])this.behaviours.stream().map(seq -> Pair.of(seq.create(), (Object)seq.weight())).toArray(Pair[]::new)).startCondition(npc -> !npc.getAnimationHandler().hasAnimation() && !BrainUtils.hasMemory((class_1309)npc, (class_4140)class_4140.field_22475)).stopIf(npc -> BrainUtils.hasMemory((class_1309)npc, (class_4140)class_4140.field_22475));
    }

    public static class Builder {
        private final List<NPCAttackSequence> behaviours = new ArrayList<NPCAttackSequence>();

        public SequenceBuilder addSequence(int weight) {
            return new SequenceBuilder(weight);
        }

        public NPCAttackActions build() {
            return new NPCAttackActions(this.behaviours);
        }

        public class SequenceBuilder {
            private final int weight;
            private class_2048 predicate = null;
            private class_5658 timeout = class_44.method_32448((float)20.0f);
            private class_5658 cooldown = class_44.method_32448((float)20.0f);
            private final List<SerializableBehaviour.SerializabledBehaviourHolder<?>> sequence = new ArrayList();

            public SequenceBuilder(int weight) {
                this.weight = weight;
            }

            public SequenceBuilder predicate(class_2048.class_2049 predicate) {
                this.predicate = predicate.method_8920();
                return this;
            }

            public SequenceBuilder timeout(class_5658 timeout) {
                this.timeout = timeout;
                return this;
            }

            public SequenceBuilder cooldown(class_5658 cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            public SequenceBuilder add(SerializableBehaviour.SerializabledBehaviourHolder<?> behaviour) {
                this.sequence.add(behaviour);
                return this;
            }

            public Builder end() {
                NPCAttackSequence seq = new NPCAttackSequence(this.sequence, Optional.ofNullable(this.predicate), this.timeout, this.cooldown, this.weight);
                Builder.this.behaviours.add(seq);
                return Builder.this;
            }
        }
    }

    public record NPCAttackSequence(List<SerializableBehaviour.SerializabledBehaviourHolder<?>> sequence, Optional<class_2048> predicate, class_5658 timeout, class_5658 cooldown, int weight) {
        public static final Codec<NPCAttackSequence> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableBehaviour.SerializabledBehaviourHolder.CODEC.listOf().fieldOf("sequence").forGetter(NPCAttackSequence::sequence), (App)class_2048.field_45746.optionalFieldOf("predicate").forGetter(NPCAttackSequence::predicate), (App)class_5659.field_45888.fieldOf("time_out").forGetter(NPCAttackSequence::timeout), (App)class_5659.field_45888.fieldOf("cooldown").forGetter(NPCAttackSequence::cooldown), (App)class_5699.field_33442.fieldOf("weight").forGetter(NPCAttackSequence::weight)).apply((Applicative)instance, NPCAttackSequence::new));

        public ExtendedBehaviour<NPCEntity> create() {
            ArrayList<ExtendedBehaviour> behaviours = new ArrayList<ExtendedBehaviour>();
            ImmutableList.Builder builder = ImmutableList.builder();
            this.sequence.forEach(seq -> behaviours.addAll(seq.create(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0))));
            behaviours.add(DummyBehaviour.opt((ExtendedBehaviour)new DoNPCAttackAction()));
            SequentialBehaviour seq2 = new SequentialBehaviour((ExtendedBehaviour[])behaviours.toArray(ExtendedBehaviour[]::new));
            this.predicate().ifPresent(pred -> builder.add(npc -> pred.method_8909((class_3218)npc.method_37908(), npc.method_19538(), (class_1297)npc)));
            ImmutableList predicates = builder.build();
            if (!predicates.isEmpty()) {
                if (predicates.size() == 1) {
                    seq2.startCondition((Predicate)predicates.getFirst());
                } else {
                    seq2.startCondition(arg_0 -> NPCAttackSequence.lambda$create$5((List)predicates, arg_0));
                }
            }
            seq2.runFor(npc -> this.timeout().method_366(NPCAttackActions.createLootContext(npc)));
            seq2.whenStopping(npc -> BrainUtils.setForgettableMemory((class_1309)npc, (class_4140)class_4140.field_22475, (Object)true, (int)this.cooldown().method_366(NPCAttackActions.createLootContext(npc))));
            return seq2;
        }

        private static /* synthetic */ boolean lambda$create$5(List predicates, NPCEntity entity) {
            for (Predicate pred : predicates) {
                if (pred.test(entity)) continue;
                return false;
            }
            return true;
        }
    }
}

