/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public class AmbrosiaWaveEntity
extends BaseDamageCloud {
    private static final class_2940<Integer> MAX_TICK = class_2945.method_12791(AmbrosiaWaveEntity.class, (class_2941)class_2943.field_13327);
    private static final List<Vector3f> CIRCLE_PARTICLE_MOTION = MathUtils.rotatedVecs((Vector3f)new Vector3f(0.3f, 0.0f, 0.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (float)-180.0f, (float)175.0f, (float)5.0f);
    private final Set<FrozenEntity> hitEntityPos = new HashSet<FrozenEntity>();

    public AmbrosiaWaveEntity(class_1299<? extends AmbrosiaWaveEntity> type, class_1937 level) {
        super(type, level);
        this.damageMultiplier = 0.3f;
    }

    public AmbrosiaWaveEntity(class_1937 level, class_1309 shooter, int maxLivingTick) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)RuneCraftoryEntities.AMBROSIA_WAVE.get()), level, shooter);
        this.field_6011.method_12778(MAX_TICK, (Object)maxLivingTick);
        this.damageMultiplier = 0.3f;
    }

    public float radiusIncrease() {
        return 0.45f;
    }

    public double maxRadius() {
        return 6.5;
    }

    public int livingTickMax() {
        return (Integer)this.field_6011.method_12789(MAX_TICK);
    }

    public boolean canStartDamage() {
        return true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MAX_TICK, (Object)120);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.livingTicks < (Integer)this.field_6011.method_12789(MAX_TICK) - 8 && this.livingTicks % 5 == 1) {
                for (Vector3f vec : CIRCLE_PARTICLE_MOTION) {
                    AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.78431374f, 0.52156866f, 0.14117648f, 1.0f)).addData((AdvancedParticleData)new MotionData(new class_243((double)vec.x(), (double)vec.y(), (double)vec.z()), true, false)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23318() + 0.2, this.method_23321());
                }
            }
        } else {
            if (this.canStartDamage()) {
                this.method_5783((class_3414)RuneCraftorySounds.ENTITY_AMBROSIA_WAVE.get(), 1.0f, 1.0f);
            }
            if (this.method_24921() != null && !this.method_24921().method_5805()) {
                this.method_31472();
            }
            this.hitEntityPos.forEach(frozenEntity -> {
                class_1309 patt0$temp = frozenEntity.entity;
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    player.method_24203(frozenEntity.pos.method_10216(), frozenEntity.pos.method_10214(), frozenEntity.pos.method_10215());
                } else {
                    frozenEntity.entity.method_5814(frozenEntity.pos.method_10216(), frozenEntity.pos.method_10214(), frozenEntity.pos.method_10215());
                }
                frozenEntity.entity.field_6037 = true;
            });
        }
    }

    @Override
    protected boolean canHit(class_1309 e) {
        return super.canHit(e) && e.method_5858((class_1297)this) <= (double)(this.getRadius() * this.getRadius());
    }

    protected class_238 damageBoundingBox() {
        float radius = this.getRadius();
        return this.method_5829().method_1009((double)radius, 0.75, (double)radius);
    }

    protected boolean damageEntity(class_1309 e) {
        DynamicDamage.Builder builder = new DynamicDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(5).element(ItemElement.EARTH).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.DRAIN.asHolder(), 50.0);
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), (class_1297)e, builder, CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            e.method_6092(new class_1293(class_1294.field_5909, 10, 6, true, false));
            this.hitEntityPos.add(new FrozenEntity(e, e.method_19538()));
            return true;
        }
        return false;
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(MAX_TICK, (Object)compound.method_10550("MaxTick"));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("MaxTick", ((Integer)this.field_6011.method_12789(MAX_TICK)).intValue());
    }

    record FrozenEntity(class_1309 entity, class_243 pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FrozenEntity) {
                FrozenEntity frozenEntity = (FrozenEntity)obj;
                return this.entity == frozenEntity.entity;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entity.method_5667().hashCode();
        }
    }
}

