/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class AppleProjectileEntity
extends BaseProjectile {
    private static final class_2940<Float> SCALE = class_2945.method_12791(AppleProjectileEntity.class, (class_2941)class_2943.field_13320);
    private boolean circling;
    private int angleOffset;
    private int circleTime;

    public AppleProjectileEntity(class_1299<? extends BaseProjectile> type, class_1937 level) {
        super(type, level);
    }

    public AppleProjectileEntity(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.APPLE.get()), level, shooter);
    }

    public void setAngleOffset(int angleOffset) {
        this.angleOffset = angleOffset;
    }

    public void setCircling(boolean circling, int circleTime) {
        this.circling = circling;
        this.circleTime = circleTime;
    }

    public void withSizeInc(float size) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(size));
    }

    public int livingTickMax() {
        return 300;
    }

    public float radius() {
        return this.method_17681() * this.getScale();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SCALE, (Object)Float.valueOf(1.0f));
    }

    public float getScale() {
        return Math.max(0.2f, ((Float)this.field_6011.method_12789(SCALE)).floatValue());
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            --this.circleTime;
            if (this.circling && this.method_24921() != null) {
                class_1297 owner = this.method_24921();
                if (this.circleTime > 0) {
                    class_243 ownerPos = owner.method_19538();
                    class_243 pos = new class_243((double)owner.method_17681() + 0.5, 0.0, 0.0).method_1024((float)(13 * this.livingTicks + this.angleOffset));
                    this.method_18800(ownerPos.field_1352 + pos.method_10216() - this.method_23317(), ownerPos.field_1351 + (double)this.method_24921().method_5751() - 0.2 - this.method_23318(), ownerPos.field_1350 + pos.method_10215() - this.method_23321());
                    this.field_6007 = true;
                    this.checkedEntities.clear();
                } else if (this.circleTime == 0) {
                    class_1308 mob;
                    if (owner instanceof class_1308 && (mob = (class_1308)owner).method_5968() != null) {
                        this.shootAtEntity((class_1297)mob.method_5968(), 1.0f, 0.0f);
                    } else {
                        this.shoot(owner, owner.method_36455(), owner.method_36454(), -5.0f, 1.0f, 0.0f);
                    }
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return this.circling ? 0.002f : super.getGravityVelocity();
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).noKnockback().hurtResistant(4).projectile(), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)class_5134.field_23721) * (double)this.damageMultiplier, null)) {
            this.method_31472();
            return true;
        }
        return false;
    }

    protected void onBlockHit(class_3965 result) {
        if (!this.circling || this.circleTime < 0) {
            this.method_31472();
        }
    }

    protected class_3966 getEntityHit(class_243 from, class_243 to) {
        if (!this.method_5805()) {
            return null;
        }
        if (this.attackedEntities.isEmpty()) {
            OrientedBoundingBox obb = new OrientedBoundingBox(new class_238((double)(-this.radius()), (double)(-this.radius()), (double)(-this.radius()), (double)this.radius(), (double)this.radius(), (double)this.radius()).method_18804(to.method_1020(from)), 0.0f, 0.0f, this.method_19538());
            List list = this.method_37908().method_8335((class_1297)this, obb.getEncompassingBox());
            for (class_1297 e : list) {
                if (!this.canHit(e) || !obb.intersects(e.method_5829())) continue;
                class_238 outer = obb.getEncompassingBox();
                class_243 hit = new class_243(class_3532.method_15350((double)e.method_19538().field_1352, (double)outer.field_1323, (double)outer.field_1320), class_3532.method_15350((double)e.method_19538().field_1351, (double)outer.field_1322, (double)outer.field_1325), class_3532.method_15350((double)e.method_19538().field_1350, (double)outer.field_1321, (double)outer.field_1324));
                return new class_3966(e, hit);
            }
            return null;
        }
        return null;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.circling = compound.method_10577("Circling");
        this.circleTime = compound.method_10550("CirclingTime");
        this.angleOffset = compound.method_10550("AngleOffset");
        this.withSizeInc(compound.method_10545("Scale") ? compound.method_10583("Scale") : 1.0f);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Circling", this.circling);
        compound.method_10569("CirclingTime", this.circleTime);
        compound.method_10569("AngleOffset", this.angleOffset);
        compound.method_10548("Scale", ((Float)this.field_6011.method_12789(SCALE)).floatValue());
    }
}

