/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.joml.Vector3d;

public class BigRaccoonLeafEntity
extends BaseProjectile {
    private static final class_2940<Boolean> SPIN = class_2945.method_12791(BigRaccoonLeafEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> INITIAL_YAW = class_2945.method_12791(BigRaccoonLeafEntity.class, (class_2941)class_2943.field_13320);
    private class_243 shootDir;
    private class_243 center;
    private class_243 axis;
    private float circleRadius;

    public BigRaccoonLeafEntity(class_1299<? extends BaseProjectile> type, class_1937 level) {
        super(type, level);
    }

    public BigRaccoonLeafEntity(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.BIG_RACCOON_LEAF.get()), level, shooter);
        if (shooter.method_17682() > 2.0f) {
            this.method_5814(this.method_23317(), shooter.method_23318() + (double)shooter.method_17682() * 0.5, this.method_23321());
        }
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
        this.field_6011.method_12778(INITIAL_YAW, (Object)Float.valueOf(this.method_36454()));
        this.shootDir = this.method_18798();
        this.center = this.method_19538().method_1019(this.shootDir);
        this.axis = MathsHelper.getUp(this.method_18798());
    }

    public void setCenter(float radius) {
        class_243 dir = this.getShootDir().method_1029().method_1021((double)radius);
        this.center = this.method_19538().method_1019(dir);
        this.axis = MathsHelper.getUp(dir);
        this.circleRadius = radius;
    }

    private class_243 getShootDir() {
        return this.shootDir == null ? this.method_18798() : this.shootDir;
    }

    public float radius() {
        return 0.5f;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPIN, (Object)false);
        builder.method_56912(INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return 30;
    }

    public void method_5773() {
        if (!this.method_37908().field_9236) {
            class_243 dir = this.method_19538().method_1020(this.center).method_1029().method_1021((double)this.circleRadius);
            float angle = (float)(Math.PI * 2 / (double)this.livingTickMax());
            if (!this.spinRight()) {
                angle *= -1.0f;
            }
            if (this.field_5953) {
                angle *= 2.0f;
            }
            Vector3d point = new Vector3d(dir.field_1352, dir.field_1351, dir.field_1350).rotateAxis((double)angle, this.axis.method_10216(), this.axis.method_10214(), this.axis.method_10215());
            class_243 newPos = this.center.method_1031(point.x(), point.y(), point.z());
            this.method_18799(newPos.method_1020(this.method_19538()));
            this.field_6007 = true;
        }
        super.method_5773();
    }

    public void withRightSpin(boolean spin) {
        this.field_6011.method_12778(SPIN, (Object)spin);
    }

    public boolean spinRight() {
        return (Boolean)this.field_6011.method_12789(SPIN);
    }

    public float initialYaw() {
        return ((Float)this.field_6011.method_12789(INITIAL_YAW)).floatValue();
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(2).element(ItemElement.EARTH), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (att) {
            this.method_31472();
        }
        return att;
    }

    protected void onBlockHit(class_3965 result) {
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        class_2499 listTag = compound.method_10554("Axis", 6);
        this.axis = new class_243(listTag.method_10611(0), listTag.method_10611(1), listTag.method_10611(2));
        listTag = compound.method_10554("Center", 6);
        this.center = new class_243(listTag.method_10611(0), listTag.method_10611(1), listTag.method_10611(2));
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("Axis", (class_2520)this.method_5846(new double[]{this.axis.field_1352, this.axis.field_1351, this.axis.field_1350}));
        compound.method_10566("Center", (class_2520)this.method_5846(new double[]{this.center.field_1352, this.center.field_1351, this.center.field_1350}));
    }
}

