/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.joml.Vector3d;

public class BulletEntity
extends BaseProjectile {
    private static final float[] SIN_POINTS = BulletEntity.calcSinPoints();
    private static final class_2940<Integer> ELEMENT_DATA = class_2945.method_12791(BulletEntity.class, (class_2941)class_2943.field_13327);
    private ItemElement element = ItemElement.NONE;
    private boolean straight;
    private boolean reverse;
    private class_243 dir;
    private class_243 side;

    public BulletEntity(class_1299<? extends BulletEntity> type, class_1937 level) {
        super(type, level);
    }

    public BulletEntity(class_1937 level, class_1309 thrower) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.CIRCLING_BULLET.get()), level, thrower);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = class_3532.method_15362((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ELEMENT_DATA, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = ItemElement.values()[(Integer)this.field_6011.method_12789(ELEMENT_DATA)];
        }
        super.method_5674(key);
    }

    public void setElement(ItemElement element) {
        this.element = element;
        this.field_6011.method_12778(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public ItemElement element() {
        return this.element;
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
        class_243 up = this.method_18863(-this.method_5695(1.0f), -this.method_5705(1.0f)).method_1029();
        this.dir = this.method_18798();
        Vector3d rot = new Vector3d(this.dir.method_10216(), this.dir.method_10214(), this.dir.method_10215()).rotateAxis(1.5707963705062866, up.method_10216(), up.method_10214(), up.method_10215());
        this.side = new class_243(rot.x(), rot.y(), rot.z()).method_1029();
    }

    public void reverseMovement() {
        this.reverse = !this.reverse;
    }

    public void setStraight() {
        this.straight = true;
    }

    public int livingTickMax() {
        return this.straight ? 20 : 50;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && !this.straight && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = this.reverse ? -SIN_POINTS[t] : SIN_POINTS[t] * 2.0f;
            this.method_18800(this.dir.field_1352 + this.side.field_1352 * (double)sT, this.dir.field_1351 + this.side.field_1351 * (double)sT, this.dir.field_1350 + this.side.field_1350 * (double)sT);
            this.field_6007 = true;
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        boolean res = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(4).element(this.element).projectile(), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (res) {
            this.method_31472();
        }
        return res;
    }

    protected void onBlockHit(class_3965 result) {
        this.method_31472();
    }
}

