/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import org.joml.Vector3d;

public class DarkBallEntity
extends BaseDamageCloud {
    private static final float[] SIN_POINTS = DarkBallEntity.calcSinPoints();
    private Type type = Type.BALL;
    private class_243 dir;
    private class_243 side;

    public DarkBallEntity(class_1299<? extends DarkBallEntity> type, class_1937 level) {
        super(type, level);
    }

    public DarkBallEntity(class_1937 level, class_1309 thrower, Type type) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)RuneCraftoryEntities.DARK_BALL.get()), level, thrower);
        this.method_5814(this.method_23317(), this.method_23318() + (double)thrower.method_17682() * 0.5, this.method_23321());
        this.type = type;
        this.setRadius(1.5f);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = class_3532.method_15362((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    public void shootAtPos(class_243 targetPos, float velocity, float inaccuracy) {
        class_243 dir = new class_243(targetPos.method_10216() - this.method_23317(), targetPos.method_10214() - this.method_23318(), targetPos.method_10215() - this.method_23321());
        this.shoot(dir.field_1352, dir.field_1351, dir.field_1350, velocity, inaccuracy);
    }

    public void shoot(class_1297 entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -class_3532.method_15374((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -class_3532.method_15374((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        class_243 throwerMotion = entityThrower.method_18798();
        this.method_18799(this.method_18798().method_1031(throwerMotion.field_1352, entityThrower.method_24828() ? 0.0 : throwerMotion.field_1351, throwerMotion.field_1350));
        this.method_18798().method_1031(throwerMotion.field_1352, 0.0, throwerMotion.field_1350);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vector3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((class_243)vector3d));
        this.method_36456((float)(class_3532.method_15349((double)vector3d.field_1352, (double)vector3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vector3d.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        class_243 up = this.method_18863(-this.method_5695(1.0f), -this.method_5705(1.0f)).method_1029();
        this.dir = this.method_18798();
        Vector3d rot = new Vector3d(this.dir.method_10216(), this.dir.method_10214(), this.dir.method_10215()).rotateAxis(1.5707963705062866, up.method_10216(), up.method_10214(), up.method_10215());
        this.side = new class_243(rot.x(), rot.y(), rot.z()).method_1029();
    }

    public int livingTickMax() {
        return this.type == Type.BALL ? 100 : 60;
    }

    public void method_5773() {
        super.method_5773();
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        this.method_5814(newX, newY, newZ);
        if (this.method_37908().field_9236) {
            int i;
            for (i = 0; i < 5; ++i) {
                AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.25490198f, 0.007843138f, 0.4117647f, 0.2f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, Math.abs(this.field_5974.method_43059() * 0.03), this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.6f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.method_37908(), this.method_23322(1.0), this.method_23323(this.method_59922().method_43058() * 0.5) + (double)this.method_17682() * 0.4, this.method_23325(1.0));
            }
            for (i = 0; i < 3; ++i) {
                AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.6666667f, 0.3647059f, 0.83137256f, 0.2f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, Math.abs(this.field_5974.method_43059() * 0.03), this.field_5974.method_43059() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.6f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.method_37908(), this.method_23322(1.0), this.method_23323(this.method_59922().method_43058() * 0.5) + (double)this.method_17682() * 0.4, this.method_23325(1.0));
            }
        } else if (this.type == Type.SNAKE && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = SIN_POINTS[t];
            this.method_18800(this.dir.field_1352 + this.side.field_1352 * (double)sT, this.dir.field_1351 + this.side.field_1351 * (double)sT, this.dir.field_1350 + this.side.field_1350 * (double)sT);
            this.field_6007 = true;
        }
    }

    protected boolean damageEntity(class_1309 target) {
        return CombatUtils.damageWithFaintAndCrit(this.method_24921(), (class_1297)target, new DynamicDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(10).element(ItemElement.DARK), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        try {
            this.type = Type.valueOf(compound.method_10558("Type"));
        }
        catch (IllegalArgumentException e) {
            this.type = Type.BALL;
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Type", this.type.toString());
    }

    public static enum Type {
        BALL,
        SNAKE;

    }
}

