/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class FurnitureEntity
extends BaseProjectile {
    private static final class_2940<Integer> FURNITURE_TYPE_SYNC = class_2945.method_12791(FurnitureEntity.class, (class_2941)class_2943.field_13327);
    private Type furnitureType = Type.CHEST;
    private float randomRotationOffset;

    public FurnitureEntity(class_1299<? extends FurnitureEntity> type, class_1937 level) {
        super(type, level);
        this.randomRotationOffset = this.field_5974.method_43057() * 360.0f;
        this.setFurnitureType(Type.WOOLYPLUSH);
    }

    public FurnitureEntity(class_1937 level, class_1309 shooter, Type furnitureType) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.FURNITURE.get()), level, shooter);
        this.setFurnitureType(furnitureType);
    }

    public int livingTickMax() {
        return this.method_5740() ? 300 : 200;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FURNITURE_TYPE_SYNC, (Object)0);
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    protected float getGravityVelocity() {
        return this.method_5740() ? 0.0f : 0.1f;
    }

    protected float motionReduction(boolean inWater) {
        return this.method_5740() ? 1.0f : super.motionReduction(inWater);
    }

    public float getRandomRotationOffset() {
        return this.randomRotationOffset;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        this.method_18382();
        boolean att = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(3).element(ItemElement.DARK), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (att) {
            this.method_31472();
        }
        return att;
    }

    protected class_3966 getEntityHit(class_243 from, class_243 to) {
        if (!this.method_5805()) {
            return null;
        }
        OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.3).method_18804(to.method_1020(from)), 0.0f, 0.0f, this.method_19538());
        List list = this.method_37908().method_8335((class_1297)this, obb.getEncompassingBox());
        for (class_1297 e : list) {
            if (this.checkedEntities.contains(e.method_5667()) || !this.canHit(e) || !obb.intersects(e.method_5829())) continue;
            class_238 outer = obb.getEncompassingBox();
            class_243 hit = new class_243(class_3532.method_15350((double)e.method_19538().field_1352, (double)outer.field_1323, (double)outer.field_1320), class_3532.method_15350((double)e.method_19538().field_1351, (double)outer.field_1322, (double)outer.field_1325), class_3532.method_15350((double)e.method_19538().field_1350, (double)outer.field_1321, (double)outer.field_1324));
            return new class_3966(e, hit);
        }
        return null;
    }

    protected void onBlockHit(class_3965 blockHitResult) {
        if (!this.method_5740() && blockHitResult.method_17780() == class_2350.field_11036) {
            this.method_31472();
        }
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key == FURNITURE_TYPE_SYNC) {
            this.method_18382();
            int id = (Integer)this.field_6011.method_12789(FURNITURE_TYPE_SYNC);
            if (id >= 0 && id < Type.values().length) {
                this.furnitureType = Type.values()[id];
            }
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18385((float)(this.furnitureType.range * 2.0f), (float)(this.furnitureType.range * 2.0f));
    }

    public Type getFurnitureType() {
        return this.furnitureType;
    }

    protected void setFurnitureType(Type furnitureType) {
        this.furnitureType = furnitureType;
        this.field_6011.method_12778(FURNITURE_TYPE_SYNC, (Object)this.furnitureType.ordinal());
        this.method_18382();
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        try {
            this.furnitureType = Type.valueOf(compound.method_10558("Type"));
        }
        catch (IllegalArgumentException e) {
            this.furnitureType = Type.CHEST;
        }
        this.field_6011.method_12778(FURNITURE_TYPE_SYNC, (Object)this.furnitureType.ordinal());
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Type", this.furnitureType.toString());
    }

    public static enum Type {
        CHEST(0.5f),
        BARREL(0.5f),
        ANVIL(0.5f),
        CHAIR(0.4f),
        WOOLYPLUSH(0.4f),
        CHIPSQUEEKPLUSH(0.4f);

        final float range;

        private Type(float range) {
            this.range = range;
        }
    }
}

