/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectileSummonHelperEntity
extends class_1297
implements class_6025 {
    @Nullable
    private UUID ownerUUID;
    private class_1309 caster;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected float damageMultiplier = 1.0f;
    protected int ticksExisted;
    protected int maxLivingTicks = 40;
    protected class_243 lockedPosition;
    protected float lockedYaw;
    protected float lockedPitch;

    public ProjectileSummonHelperEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public ProjectileSummonHelperEntity(class_1299<?> entityType, class_1937 level, class_1309 caster) {
        super(entityType, level);
        this.method_5814(caster.method_23317(), caster.method_23318() + (double)caster.method_5751() - 0.1, caster.method_23321());
        this.caster = caster;
        this.ownerUUID = caster.method_5667();
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public int getMaxLivingTicks() {
        return this.maxLivingTicks;
    }

    public void method_5773() {
        super.method_5773();
        ++this.ticksExisted;
        if (this.lockedPosition == null) {
            this.lockedPosition = this.method_19538();
            this.lockedPitch = this.method_36455();
            this.lockedYaw = this.method_36454();
        }
        this.method_33574(this.lockedPosition);
        this.method_36457(this.lockedPitch);
        this.method_36456(this.lockedYaw);
        if (!this.method_37908().field_9236) {
            if (this.method_35057() != null && this.method_35057().method_5805()) {
                this.summonProjectiles();
            }
            if (this.ticksExisted >= this.getMaxLivingTicks()) {
                this.method_31472();
            }
        }
    }

    protected abstract void summonProjectiles();

    protected void method_5749(class_2487 compound) {
        if (compound.method_25928("Owner")) {
            this.ownerUUID = compound.method_25926("Owner");
        }
        this.caster = this.method_35057();
        this.targetX = compound.method_10574("TargetX");
        this.targetY = compound.method_10574("TargetY");
        this.targetZ = compound.method_10574("TargetZ");
        this.damageMultiplier = compound.method_10583("DamageMultiplier");
        this.ticksExisted = compound.method_10550("TicksExisted");
        this.maxLivingTicks = compound.method_10550("MaxLivingTicks");
    }

    protected void method_5652(class_2487 compound) {
        if (this.ownerUUID != null) {
            compound.method_25927("Owner", this.ownerUUID);
        }
        compound.method_10549("TargetX", this.targetX);
        compound.method_10549("TargetY", this.targetY);
        compound.method_10549("TargetZ", this.targetZ);
        compound.method_10548("DamageMultiplier", this.damageMultiplier);
        compound.method_10569("TicksExisted", this.ticksExisted);
        compound.method_10569("MaxLivingTicks", this.maxLivingTicks);
    }

    public class_2596<class_2602> method_18002(class_3231 entity) {
        class_1309 owner = this.method_35057();
        return new class_2604((class_1297)this, entity, owner == null ? 0 : owner.method_5628());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_1297 entity = this.method_37908().method_8469(packet.method_11166());
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            this.setOwner(livingEntity);
        }
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        double dX = x - this.method_23317();
        double dY = y - this.method_23318();
        double dZ = z - this.method_23321();
        this.method_36456((float)(class_3532.method_15349((double)dZ, (double)dX) * 57.2957763671875) - 90.0f);
        this.method_36457((float)(-(class_3532.method_15349((double)dY, (double)Math.sqrt(dX * dX + dZ * dZ)) * 57.2957763671875)));
    }

    @Nullable
    public UUID method_6139() {
        return this.ownerUUID;
    }

    @Nullable
    public class_1309 method_35057() {
        class_1937 class_19372;
        if (this.caster != null && !this.caster.method_31481()) {
            return this.caster;
        }
        if (this.ownerUUID != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1297 e = serverLevel.method_14190(this.ownerUUID);
            if (e instanceof class_1309) {
                class_1309 livingEntity;
                this.caster = livingEntity = (class_1309)e;
            }
            return this.caster;
        }
        return null;
    }

    public void setOwner(@Nullable class_1309 entity) {
        if (entity != null) {
            this.ownerUUID = entity.method_5667();
            this.caster = entity;
        }
    }
}

