/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_6880;

public class SwipingWaterLaserEntity
extends BaseBeam {
    private static final class_2940<Integer> MAX_LIVING_TICK = class_2945.method_12791(SwipingWaterLaserEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> TOTAL_ROTATION = class_2945.method_12791(SwipingWaterLaserEntity.class, (class_2941)class_2943.field_13320);
    private final Object2IntMap<class_1297> hitEntities = new Object2IntOpenHashMap();

    public SwipingWaterLaserEntity(class_1299<? extends SwipingWaterLaserEntity> type, class_1937 level) {
        super(type, level);
    }

    public SwipingWaterLaserEntity(class_1937 level, class_1309 shooter, float rotationAngle) {
        super((class_1299<? extends BaseBeam>)((class_1299)RuneCraftoryEntities.SWIPING_WATER_LASER.get()), level, shooter);
        this.field_6011.method_12778(TOTAL_ROTATION, (Object)Float.valueOf(rotationAngle));
    }

    public SwipingWaterLaserEntity setMaxTicks(int ticks) {
        this.field_6011.method_12778(MAX_LIVING_TICK, (Object)ticks);
        return this;
    }

    public void setRotationToDirWithOffset(double dirX, double dirY, double dirZ, float acc, float yawOffset) {
        super.setRotationToDir(dirX, dirY, dirZ, acc);
        this.method_36456(this.method_36454() + yawOffset);
        this.updateYawPitch();
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MAX_LIVING_TICK, (Object)20);
        builder.method_56912(TOTAL_ROTATION, (Object)Float.valueOf(0.0f));
    }

    public float getRange() {
        return 12.0f;
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return (Integer)this.field_6011.method_12789(MAX_LIVING_TICK);
    }

    public void updateHitDetectBox() {
        double dist = this.hitVec != null ? this.hitVec.method_1020(this.method_19538()).method_1033() : 0.0;
        double diff = class_3532.method_15374((float)((this.method_36454() - this.field_5982) * ((float)Math.PI / 180))) * this.getRange();
        double width = this.radius() * 2.0f;
        double height = 1.0;
        this.hitObb = new OrientedBoundingBox(new class_238(-width * 0.5 + diff, -width * 0.5, 0.0, width * 0.5, height * 0.5, dist + 0.5), this.method_36454(), -this.method_36455(), this.method_19538());
    }

    public void method_5773() {
        class_1297 class_12972;
        float amount = ((Float)this.field_6011.method_12789(TOTAL_ROTATION)).floatValue() / (float)this.livingTickMax();
        if (amount != 0.0f) {
            this.hit = null;
        }
        super.method_5773();
        if (amount != 0.0f) {
            this.method_36456(class_3532.method_15393((float)(this.method_36454() + amount)));
        }
        if ((class_12972 = this.method_24921()) instanceof class_3222) {
            boolean keep;
            class_3222 player = (class_3222)class_12972;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            AnimationState state = data.getWeaponHandler().getAnimationHandler().getAnimation();
            boolean bl = keep = state != null && state.is(new String[]{PlayerModelAnimations.WATER_LASER_ONE, PlayerModelAnimations.WATER_LASER_TWO, PlayerModelAnimations.WATER_LASER_THREE});
            if (!keep && this.field_6012 < this.livingTickMax() - 5) {
                this.field_6011.method_12778(MAX_LIVING_TICK, (Object)(this.field_6012 + 5));
            }
        }
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int steps) {
    }

    public void onImpact(class_3966 res) {
        class_1297 e = res.method_17782();
        CombatUtils.damageWithFaintAndCrit(this.method_24921(), e, new DynamicDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(5).magic().noKnockback().element(ItemElement.WATER), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.hitEntities.put((Object)e, this.field_6012);
    }

    @Override
    protected boolean check(class_1297 e, Predicate<class_238> intersects) {
        if (this.field_6012 - this.hitEntities.getOrDefault((Object)e, this.field_6012 - 20) <= 19) {
            return false;
        }
        return super.check(e, intersects);
    }

    public boolean canStartDamage() {
        return true;
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(MAX_LIVING_TICK, (Object)compound.method_10550("MaxTicks"));
        this.field_6011.method_12778(TOTAL_ROTATION, (Object)Float.valueOf(compound.method_10583("TotalRotation")));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("MaxTicks", ((Integer)this.field_6011.method_12789(MAX_LIVING_TICK)).intValue());
        compound.method_10548("TotalRotation", ((Float)this.field_6011.method_12789(TOTAL_ROTATION)).floatValue());
    }
}

