/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class ThrownItemEntity
extends BaseProjectile {
    private static final class_2940<class_1799> STACK = class_2945.method_12791(ThrownItemEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> ROTATING = class_2945.method_12791(ThrownItemEntity.class, (class_2941)class_2943.field_13323);
    private boolean actAsFood;

    public ThrownItemEntity(class_1299<? extends ThrownItemEntity> type, class_1937 level) {
        super(type, level);
    }

    public ThrownItemEntity(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.THROWN_ITEM.get()), level, shooter);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STACK, (Object)class_1799.field_8037);
        builder.method_56912(ROTATING, (Object)false);
    }

    public int livingTickMax() {
        return 30;
    }

    public void setItem(class_1799 stack) {
        this.field_6011.method_12778(STACK, (Object)((class_1799)class_156.method_654((Object)stack.method_7972(), itemStack -> itemStack.method_7939(1))));
    }

    public void setActAsFood(boolean flag) {
        this.actAsFood = flag;
    }

    public class_1799 getItem() {
        return (class_1799)this.field_6011.method_12789(STACK);
    }

    public void setRotating(boolean rotating) {
        this.field_6011.method_12778(ROTATING, (Object)rotating);
    }

    public boolean isRotating() {
        return (Boolean)this.field_6011.method_12789(ROTATING);
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (this.actAsFood) {
            class_1799 stack = this.getItem();
            class_1297 class_12972 = result.method_17782();
            if (class_12972 instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)class_12972;
                e = this.method_24921();
                if (e instanceof class_1657) {
                    class_1657 thrower = (class_1657)e;
                    if (mob.onGivingItem(thrower, stack) && stack.method_7960()) {
                        this.method_31472();
                    }
                } else {
                    mob.applyFoodEffect(stack);
                }
            } else {
                e = result.method_17782();
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    e = this.method_24921();
                    if (!(e instanceof class_1657)) {
                        player.method_60492(player.method_37908(), stack);
                        if (stack.method_7960()) {
                            this.method_31472();
                        }
                    } else {
                        class_1542 entity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.getItem());
                        this.method_37908().method_8649((class_1297)entity);
                    }
                }
            }
            return true;
        }
        boolean res = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(3).projectile(), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)class_5134.field_23721) * (double)this.damageMultiplier, null);
        if (res) {
            this.method_31472();
        }
        return res;
    }

    protected void onBlockHit(class_3965 result) {
        if (this.actAsFood) {
            class_1542 entity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.getItem());
            this.method_37908().method_8649((class_1297)entity);
        }
        this.method_31472();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_1799 itemStack = this.getItem();
        if (!itemStack.method_7960()) {
            compound.method_10566("Item", itemStack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)new class_2487()));
        }
        compound.method_10556("Rotating", this.isRotating());
        compound.method_10556("ActAsFood", this.actAsFood);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        class_1799 itemStack = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)compound.method_10562("Item"));
        this.setItem(itemStack);
        this.setRotating(compound.method_10577("Rotating"));
        this.actAsFood = compound.method_10577("ActAsFood");
    }
}

