/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public class WaterLaserEntity
extends BaseBeam {
    private static final class_2940<Float> RANGE = class_2945.method_12791(WaterLaserEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> MAX_LIVING_TICK = class_2945.method_12791(WaterLaserEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> YAW_OFFSET = class_2945.method_12791(WaterLaserEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Vector3f> OFFSET = class_2945.method_12791(WaterLaserEntity.class, (class_2941)class_2943.field_42237);
    private static final class_2940<Boolean> ROTATION_FROM_OFFSET = class_2945.method_12791(WaterLaserEntity.class, (class_2941)class_2943.field_13323);
    private final Object2IntMap<class_1297> hitEntities = new Object2IntOpenHashMap();
    private float accumulatedRot;
    private UUID other;

    public WaterLaserEntity(class_1299<? extends WaterLaserEntity> type, class_1937 level) {
        super(type, level);
    }

    public WaterLaserEntity(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseBeam>)((class_1299)RuneCraftoryEntities.WATER_LASER.get()), level, shooter);
    }

    public WaterLaserEntity(class_1937 level, class_1309 shooter, Vector3f offset) {
        super((class_1299<? extends BaseBeam>)((class_1299)RuneCraftoryEntities.WATER_LASER.get()), level, shooter);
        this.field_6011.method_12778(OFFSET, (Object)offset);
        this.updateYawPitch();
    }

    public WaterLaserEntity setMaxTicks(int ticks) {
        this.field_6011.method_12778(MAX_LIVING_TICK, (Object)ticks);
        return this;
    }

    public void setYawOffset(float offset) {
        this.field_6011.method_12778(YAW_OFFSET, (Object)Float.valueOf(offset));
        this.updateYawPitch();
    }

    public void setTwinId(UUID other) {
        this.other = other;
    }

    public void setRange(float range) {
        this.field_6011.method_12778(RANGE, (Object)Float.valueOf(range));
    }

    public void setRotationFromOffset() {
        this.field_6011.method_12778(ROTATION_FROM_OFFSET, (Object)true);
        this.updateYawPitch();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MAX_LIVING_TICK, (Object)20);
        builder.method_56912(YAW_OFFSET, (Object)Float.valueOf(0.0f));
        builder.method_56912(OFFSET, (Object)new Vector3f());
        builder.method_56912(RANGE, (Object)Float.valueOf(10.0f));
        builder.method_56912(ROTATION_FROM_OFFSET, (Object)false);
    }

    public float getRange() {
        return ((Float)this.field_6011.method_12789(RANGE)).floatValue();
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return (Integer)this.field_6011.method_12789(MAX_LIVING_TICK);
    }

    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.method_24921() != null) {
            this.setupRotationAndPosition(this.method_24921(), this.method_24921());
        }
    }

    public void setupRotationAndPosition(class_1297 positionEntity, class_1297 from) {
        float[] yxRot;
        float yRot = this.method_36454();
        float xRot = this.method_36455();
        Vector3f offset = ((Vector3f)this.field_6011.method_12789(OFFSET)).rotateY(-(from.method_36454() + ((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue()) * ((float)Math.PI / 180), new Vector3f());
        if (((Boolean)this.field_6011.method_12789(ROTATION_FROM_OFFSET)).booleanValue()) {
            float pitch = from.method_36455();
            class_243 look = class_243.method_1030((float)pitch, (float)from.method_36454()).method_1021((double)offset.length());
            class_243 up = class_243.method_1030((float)(pitch - 90.0f), (float)from.method_36454());
            offset = new Vector3f((float)look.method_10216(), (float)look.method_10214(), (float)look.method_10215()).rotateAxis(((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue() * ((float)Math.PI / 180), (float)up.method_10216(), (float)up.method_10214(), (float)up.method_10215(), new Vector3f());
            yxRot = MathsHelper.YXRotFrom(offset.x(), offset.y(), offset.z());
        } else {
            yxRot = new float[]{from.method_36454() + ((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue(), from.method_36455()};
        }
        this.method_36457(yxRot[1]);
        this.method_36456(yxRot[0]);
        this.method_5814(positionEntity.method_23317() + (double)offset.x(), positionEntity.method_23318() + (double)positionEntity.method_5751() - 0.1 + (double)offset.y(), positionEntity.method_23321() + (double)offset.z());
        this.accumulatedRot += Math.abs(this.method_36454() - yRot) + Math.abs(this.method_36455() - xRot);
    }

    public boolean getHitVecFromShooter() {
        return this.method_24921() instanceof class_1657;
    }

    public void method_5773() {
        if (this.accumulatedRot > 15.0f) {
            this.hitEntities.clear();
            this.accumulatedRot = 0.0f;
        }
        super.method_5773();
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_3222) {
            boolean keep;
            class_3222 player = (class_3222)class_12972;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            AnimationState state = data.getWeaponHandler().getAnimationHandler().getAnimation();
            boolean bl = keep = state != null && state.is(new String[]{PlayerModelAnimations.WATER_LASER_ONE, PlayerModelAnimations.WATER_LASER_TWO, PlayerModelAnimations.WATER_LASER_THREE});
            if (!keep && this.field_6012 < this.livingTickMax() - 5) {
                this.field_6011.method_12778(MAX_LIVING_TICK, (Object)(this.field_6012 + 5));
            }
        }
    }

    public void onImpact(class_3966 res) {
        class_1309 living;
        class_1297 e = res.method_17782();
        int invul_time = 5;
        if (e instanceof class_1309 && (living = (class_1309)e).method_6081() != null && living.method_6081().method_5526() != null && living.method_6081().method_5526().method_5667().equals(this.other)) {
            invul_time = 0;
        }
        CombatUtils.damageWithFaintAndCrit(this.method_24921(), e, new DynamicDamage.Builder((class_1297)this, this.method_24921()).hurtResistant(invul_time).magic().noKnockback().element(ItemElement.WATER), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.hitEntities.put((Object)e, this.field_6012);
    }

    @Override
    protected boolean check(class_1297 e, Predicate<class_238> intersects) {
        if (this.field_6012 - this.hitEntities.getOrDefault((Object)e, this.field_6012 - 20) <= 19) {
            return false;
        }
        return super.check(e, intersects);
    }

    public boolean canStartDamage() {
        return true;
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(RANGE, (Object)Float.valueOf(compound.method_10583("Range")));
        this.field_6011.method_12778(MAX_LIVING_TICK, (Object)compound.method_10550("MaxTicks"));
        this.field_6011.method_12778(YAW_OFFSET, (Object)Float.valueOf(compound.method_10583("YawOffset")));
        this.field_6011.method_12778(OFFSET, (Object)new Vector3f(compound.method_10583("OffsetX"), compound.method_10583("OffsetY"), compound.method_10583("OffsetZ")));
        this.field_6011.method_12778(ROTATION_FROM_OFFSET, (Object)compound.method_10577("RotationFromOffset"));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("Range", ((Float)this.field_6011.method_12789(RANGE)).floatValue());
        compound.method_10569("MaxTicks", ((Integer)this.field_6011.method_12789(MAX_LIVING_TICK)).intValue());
        compound.method_10548("YawOffset", ((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue());
        Vector3f offset = (Vector3f)this.field_6011.method_12789(OFFSET);
        compound.method_10548("OffsetX", offset.x());
        compound.method_10548("OffsetY", offset.y());
        compound.method_10548("OffsetZ", offset.z());
        compound.method_10556("RotationFromOffset", ((Boolean)this.field_6011.method_12789(ROTATION_FROM_OFFSET)).booleanValue());
    }
}

