/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import net.minecraft.class_6880;

public class WindBladeEntity
extends BaseProjectile {
    private class_1297 target;
    private Type type = Type.HOMING;
    private int livingTickMax = 70;

    public WindBladeEntity(class_1299<? extends WindBladeEntity> type, class_1937 level) {
        super(type, level);
    }

    public WindBladeEntity(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.WIND_BLADE.get()), level, shooter);
    }

    public void setTarget(class_1297 entity) {
        this.target = entity;
    }

    public void setType(Type type) {
        this.type = type;
        this.livingTickMax = this.isPiercing() ? 70 : 40;
    }

    public void maxTicks(int maxTicks) {
        this.livingTickMax = maxTicks;
    }

    public boolean isPiercing() {
        return this.type == Type.PIERCING;
    }

    public int livingTickMax() {
        return this.livingTickMax;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (!(this.target != null && this.target.method_5805() || this.type != Type.HOMING)) {
                List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(16.0).method_18804(this.method_18798()), e -> {
                    class_6025 ownable;
                    if (!e.method_5863() || !e.method_5732()) {
                        return false;
                    }
                    if (e.equals((Object)this.method_24921()) || e instanceof class_6025 && (ownable = (class_6025)e).method_35057() == this.method_24921()) {
                        return false;
                    }
                    return this.canHit((class_1297)e);
                });
                double distSq = Double.MAX_VALUE;
                class_1297 res = null;
                for (class_1297 e2 : list) {
                    if (!(e2.method_5858((class_1297)this) < distSq)) continue;
                    res = e2;
                }
                if (res != null) {
                    this.target = res;
                }
            }
            if (this.target != null) {
                class_243 dir = this.target.method_33571().method_1020(this.method_19538()).method_1029().method_1021(0.1);
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(dir));
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(this.type == Type.PLAIN ? 4 : 10).element(ItemElement.WIND).projectile(), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            if (!this.isPiercing()) {
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    protected void onBlockHit(class_3965 blockRayTraceResult) {
        if (!this.isPiercing()) {
            this.method_31472();
        } else {
            class_243 mot = this.method_18798();
            class_243 newMot = switch (blockRayTraceResult.method_17780()) {
                case class_2350.field_11033, class_2350.field_11036 -> new class_243(mot.method_10216(), -mot.method_10214(), mot.method_10215());
                case class_2350.field_11039, class_2350.field_11034 -> new class_243(-mot.method_10216(), mot.method_10214(), mot.method_10215());
                default -> new class_243(mot.method_10216(), mot.method_10214(), -mot.method_10215());
            };
            if (!blockRayTraceResult.method_17781()) {
                this.method_33574(blockRayTraceResult.method_17784());
            }
            this.method_18799(newMot);
            this.doBlockCollision();
        }
    }

    private void doBlockCollision() {
        class_243 pos = this.method_19538();
        class_243 to = pos.method_1019(this.method_18798());
        class_3965 raytraceresult = this.method_37908().method_17742(new class_3959(pos, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (raytraceresult.method_17783() == class_239.class_240.field_1332 && !TenshiLibCrossPlat.INSTANCE.projectileImpactEvent((class_1676)this, (class_239)raytraceresult)) {
            class_2338 blockpos = raytraceresult.method_17777();
            class_2680 blockstate = this.method_37908().method_8320(blockpos);
            blockstate.method_26175(this.method_37908(), blockstate, raytraceresult, (class_1676)this);
            this.onBlockHit(raytraceresult);
        }
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setType(Type.values()[compound.method_10550("Type")]);
        this.maxTicks(compound.method_10550("MaxTicks"));
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Type", this.type.ordinal());
        compound.method_10569("MaxTicks", this.livingTickMax());
    }

    public static enum Type {
        PLAIN,
        HOMING,
        PIERCING;

    }
}

