/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Buffamoo
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String CHARGE_ATTACK = BUILDER.add("charge", AnimationsBuilder.definition((double)2.2).marker("attack_start", new double[]{0.72}).marker("attack_end", new double[]{1.92}));
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.48).marker("attack", new double[]{0.28}));
    public static final String INTERACT = BUILDER.add("interact", STOMP);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Buffamoo> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Buffamoo(class_1299<? extends Buffamoo> type, class_1937 level) {
        super((class_1299<? extends ChargingMonster>)type, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.2);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{STOMP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{CHARGE_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(2).start(new String[]{CHARGE_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(4.0)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(3).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5)), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.8;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE_ATTACK})) {
            source.knock(DynamicDamage.KnockBackType.BACK, 2.0f);
        } else if (this.getAnimationHandler().isCurrent(new String[]{STOMP})) {
            source.withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.STUN.asHolder(), 20.0);
        }
        return source;
    }

    public AnimationHandler<Buffamoo> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(CHARGE_ATTACK);
    }

    @Override
    public double chargingSpeed() {
        return 0.35;
    }

    @Override
    public void doWhileCharge() {
        if (this.field_6012 % 3 == 0) {
            this.method_37908().method_8396(null, this.method_24515(), (class_3414)RuneCraftorySounds.ENTITY_BUFFAMOO_STEP.get(), this.method_5634(), 1.0f, 0.9f + this.method_59922().method_43057() * 0.2f);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE_ATTACK);
            } else {
                this.getAnimationHandler().setAnimation(STOMP);
            }
        }
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)RuneCraftorySounds.ENTITY_BUFFAMOO_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)RuneCraftorySounds.ENTITY_BUFFAMOO_DEATH.get();
    }

    public float method_6017() {
        return 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

