/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.HealT2Spell;
import io.github.flemmli97.runecraftory.common.spells.ShineSpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class Fairy
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String LIGHT = BUILDER.add("light", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.32}));
    public static final String HEAL = BUILDER.add("heal", LIGHT);
    public static final String INTERACT = BUILDER.add("interact", LIGHT);
    public static final String WIND = BUILDER.add("wind", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.48}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Fairy> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final Predicate<class_1309> healingPredicate = e -> {
        if (this.method_6139() == null) {
            class_6025 ownable;
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            return e instanceof class_1569 && e != this.method_5968();
        }
        if (e instanceof class_6025) {
            class_6025 ownable = (class_6025)e;
            if (this.method_6139().equals(ownable.method_6139())) {
                return true;
            }
        }
        return this.method_6139().equals(e.method_5667());
    };

    public Fairy(class_1299<? extends Fairy> type, class_1937 level) {
        super(type, level);
        this.method_5875(true);
        this.field_6207 = new FreeMoveControl((class_1308)this);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.3);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{WIND}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(5.0).max(15.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(new String[]{LIGHT}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(15))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveTo()}).end(3).start(new String[]{HEAL}).play(MonsterBehaviourUtils.cooldownedPlay()).end(2).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(12)), MonsterBehaviourUtils.moveTo()}).add(5, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_59922().method_43048(20) + 30 + diffAdd;
        }
        return this.method_59922().method_43048(40) + 22 + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{LIGHT})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ShineSpell)RuneCraftorySpells.SHINE.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{WIND})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((WindBladeSpell)RuneCraftorySpells.DOUBLE_SONIC.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{HEAL})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((HealT2Spell)RuneCraftorySpells.CURE_ALL.get()).use((class_1309)this);
            }
        }
    }

    public AnimationHandler<Fairy> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 1 ? (Spell)RuneCraftorySpells.SHINE.get() : (Spell)RuneCraftorySpells.DOUBLE_BULLET.get())) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LIGHT);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_FAIRY_AMBIENT.get();
    }

    @Override
    public Predicate<class_1309> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

