/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import org.jetbrains.annotations.Nullable;

public class FlowerLily
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)0.88).marker("leap", new double[]{0.28}));
    public static final String ATTACK = BUILDER.add("attack", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.32}));
    public static final String INTERACT = BUILDER.add("interact", ATTACK);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final TypedResource<class_243> LEAP_MOTION = new TypedResource(RuneCraftory.modRes("leap_motion"));
    private final AnimationHandler<FlowerLily> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            this.setLeapMotion(null);
        }
        return false;
    });

    public FlowerLily(class_1299<? extends FlowerLily> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.25);
        super.applyAttributes();
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(LEAP_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(15.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{LEAP}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(3.0)).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(15.0f)}).add(2, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{LEAP})) {
            return this.getLeapMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double attackSize = (double)this.method_17681() * 2.1;
        return new class_238(-attackSize, -0.2, -attackSize, attackSize, (double)this.method_17682() + 0.2, attackSize);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{LEAP})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_59922().method_43048(20) + 30 + diffAdd;
        }
        return this.method_59922().method_43048(40) + 25 + diffAdd;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{LEAP})) {
            this.method_5942().method_6340();
            if (anim.isAt("leap")) {
                class_243 vec32 = EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(-2.0);
                this.method_18800(vec32.field_1352, 0.15, vec32.field_1350);
                this.setLeapMotion(this.method_18798());
            }
        } else if (anim.is(new String[]{ATTACK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.rangedAttackSpell().use((class_1309)this);
            }
        }
    }

    public AnimationHandler<FlowerLily> getAnimationHandler() {
        return this.animationHandler;
    }

    public class_243 getLeapMotion() {
        return (class_243)this.getDataContainer().get(LEAP_MOTION);
    }

    public void setLeapMotion(class_243 chargeMotion) {
        this.getDataContainer().set(LEAP_MOTION, (Object)chargeMotion);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 0 ? this.rangedAttackSpell() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    protected Spell rangedAttackSpell() {
        return (Spell)RuneCraftorySpells.DOUBLE_BULLET.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783((class_3414)RuneCraftorySounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

