/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.DarkBallSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_6025;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Mage
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SWING = BUILDER.add("swing", AnimationsBuilder.definition((double)0.64).marker("attack", new double[]{0.36}));
    public static final String INTERACT = BUILDER.add("interact", SWING);
    public static final String CAST_1 = BUILDER.add("cast_1", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.4}));
    public static final String CAST_DOUBLE = BUILDER.add("cast_double", AnimationsBuilder.definition((double)0.84).animationId(CAST_1).marker("attack", new double[]{0.4, 0.6}));
    public static final String CAST_2 = BUILDER.add("cast_2", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.36}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Mage> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final Predicate<class_1309> healingPredicate = e -> {
        if (this.method_6139() == null) {
            class_6025 ownable;
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            return e instanceof class_1569 && e != this.method_5968();
        }
        if (e instanceof class_6025) {
            class_6025 ownable = (class_6025)e;
            if (this.method_6139().equals(ownable.method_6139())) {
                return true;
            }
        }
        return this.method_6139().equals(e.method_5667());
    };

    public Mage(class_1299<? extends Mage> type, class_1937 level) {
        super(type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SWING}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(SWING)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{CAST_1}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(9.0f).runFor(e -> e.method_59922().method_43048(15) + 10)}).end(5).start(new String[]{CAST_DOUBLE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(9.0f).runFor(e -> e.method_59922().method_43048(15) + 10)}).end(5).start(new String[]{CAST_2}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(9.0f).runFor(e -> e.method_59922().method_43048(15) + 10)}).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(4, new ExtendedBehaviour[]{new StrafeTarget()}).build();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CAST_1})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.getFirstSpell().use((class_1309)this);
            }
        } else if (anim.is(new String[]{CAST_DOUBLE})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((DarkBallSpell)RuneCraftorySpells.DARK_BALL.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{CAST_2})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.getSecondSpell().use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Mage> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            Spell spell;
            switch (command) {
                case 2: {
                    Spell spell2 = this.getSecondSpell();
                    break;
                }
                case 1: {
                    Spell spell2 = this.getFirstSpell();
                    break;
                }
                default: {
                    Spell spell2 = spell = null;
                }
            }
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), spell)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CAST_2);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(CAST_1);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    public Spell getFirstSpell() {
        return (Spell)RuneCraftorySpells.PARALYSIS_BALL.get();
    }

    public Spell getSecondSpell() {
        return (Spell)RuneCraftorySpells.EXPANDING_QUAD_LIGHT.get();
    }

    @Override
    public Predicate<class_1309> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

