/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSwipe;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4140;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SkyFish
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SLAP = BUILDER.add("slap", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.28}));
    public static final String INTERACT = BUILDER.add("interact", SLAP);
    public static final String BEAM = BUILDER.add("beam", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.4}));
    public static final String SWIPE = BUILDER.add("swipe", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.28}));
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<SkyFish> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public SkyFish(class_1299<? extends BaseMonster> type, class_1937 level) {
        super(type, level);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new FreeMoveControl((class_1308)this, () -> false);
        this.method_5875(true);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.25);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SLAP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{BEAM}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(4.0f).radius(4.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{SWIPE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(4.0f).radius(4.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(7)), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomFlyingTarget().flightTargetPredicate((entity, pos) -> {
            class_1309 target;
            class_1309 class_13092 = target = BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_22355) ? BrainUtils.getTargetOfEntity((class_1309)entity) : null;
            if (target == null) {
                target = entity.method_5968();
            }
            return target != null && target.method_5707(pos) <= 121.0 && Math.abs(target.method_23318() - pos.method_10214()) < 6.0;
        }), MonsterBehaviourUtils.moveTo()}).add(4, MonsterBehaviourUtils.ifFurtherThan(7.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomHoverTarget();
    }

    @Override
    protected int wanderChance() {
        return 50;
    }

    @Override
    protected boolean canFloatInWater() {
        return false;
    }

    @Override
    public void method_5773() {
        super.method_5670();
        if (!this.method_37908().field_9236 && this.method_5968() == null && !this.method_5799() && this.belowSoldid()) {
            class_243 mot = this.method_18798();
            double newY = Math.max(0.0, mot.field_1351);
            this.method_18800(mot.field_1352, Math.min(0.3, newY += 0.03), mot.field_1350);
        }
    }

    private boolean belowSoldid() {
        class_2338 pos = this.method_24515().method_10074();
        return this.method_37908().method_8320(pos).method_26168((class_1922)this.method_37908(), pos, (class_1297)this);
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    @Override
    public void method_6091(class_243 vec) {
        this.handleFreeTravel(vec);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        return this.method_59922().method_43048(30) + 20 + diffAdd;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.6;
        return new class_238(-width * 0.2, -0.02, 0.0, width * 0.8, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{BEAM})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((WaterLaserSpell)RuneCraftorySpells.WATER_LASER.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{SWIPE})) {
            if (anim.isAt("attack")) {
                ((WaterLaserSwipe)RuneCraftorySpells.WATER_SWIPE.get()).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<SkyFish> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 1) {
                if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.WATER_LASER.get())) {
                    return;
                }
                this.getAnimationHandler().setAnimation(BEAM);
            } else {
                if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                    return;
                }
                if (command == 2) {
                    this.getAnimationHandler().setAnimation(SWIPE);
                } else {
                    this.getAnimationHandler().setAnimation(SLAP);
                }
            }
        }
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14851;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15003;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.8f;
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public boolean method_5675() {
        return false;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

