/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.MultiFireballSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetSetClampedFloatingMoveTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class VeggieGhost
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String ATTACK = BUILDER.add("head_attack", AnimationsBuilder.definition((double)1.16).marker("attack", new double[]{0.68}));
    public static final String CAST = BUILDER.add("cast", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.36}));
    public static final String INTERACT = BUILDER.add("interact", CAST);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.36}));
    public static final String VANISH = BUILDER.add("vanish", AnimationsBuilder.definition((double)5.0).marker("attack", new double[]{2.5}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private boolean vanishNext;
    private final AnimationHandler<VeggieGhost> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim != null && anim.is(new String[]{VANISH})) {
            this.vanishNext = (double)this.method_59922().method_43057() < 0.6;
        }
        return false;
    });

    public VeggieGhost(class_1299<? extends VeggieGhost> type, class_1937 level) {
        super(type, level);
        this.field_5960 = true;
        this.field_6207 = new FreeMoveControl((class_1308)this);
        this.method_5875(true);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.35);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{ATTACK}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{SPIN}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{CAST}).play(MonsterBehaviourUtils.cooldownedPlay()).prepareOptional(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(9.0), MonsterBehaviourUtils.moveTo()}).end(7).start(MonsterBehaviourUtils.checkedAttack(VANISH)).play(MonsterBehaviourUtils.cooldownedPlay()).end(9).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetSetClampedFloatingMoveTarget(Double.valueOf(2.0)), MonsterBehaviourUtils.moveTo()}).add(5, new ExtendedBehaviour[]{new StrafeTarget()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomHoverTarget();
    }

    @Override
    protected boolean canFloatInWater() {
        return false;
    }

    public boolean method_6057(class_1297 entity) {
        return true;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new String[]{VANISH})) {
            return false;
        }
        boolean ret = super.method_5643(source, amount);
        if (ret) {
            this.vanishNext = (double)this.method_59922().method_43057() < 0.4;
        }
        return ret;
    }

    @Override
    public void method_6091(class_243 vec) {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            this.field_5960 = entity.field_5960;
        } else {
            boolean bl = this.field_5960 = !this.playDeath();
            if (this.method_23318() < (double)(this.method_37908().method_31607() + 1)) {
                vec = new class_243(vec.field_1352, 0.006, vec.field_1350);
            }
        }
        this.handleFreeTravel(vec);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        if (anim.is(new String[]{SPIN})) {
            double attackSize = (double)this.method_17681() * 1.4;
            return new class_238(-attackSize, -0.2, -attackSize, attackSize, (double)this.method_17682() + 0.2, attackSize);
        }
        double width = (double)this.method_17681() * 1.6;
        double length = this.method_17681() * 2.0f;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{CAST})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((MultiFireballSpell)RuneCraftorySpells.TRIPLE_FIRE_BALL.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{VANISH})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                class_1309 target = this.method_5968();
                if (target == null) {
                    double rX = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 16.0;
                    double rY = this.method_23318() + (this.field_5974.method_43058() - 0.5) * 4.0;
                    double rZ = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 16.0;
                    this.teleport(rX, rY, rZ);
                } else {
                    this.teleportTowards((class_1297)target);
                }
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<VeggieGhost> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 1 ? (Spell)RuneCraftorySpells.TRIPLE_FIRE_BALL.get() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CAST);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    @Override
    public boolean allowAnimation(@Nullable String prev, String other) {
        if (other.equals(VANISH)) {
            return this.shouldVanishNext(prev);
        }
        return super.allowAnimation(prev, other);
    }

    public boolean shouldVanishNext(String prev) {
        class_1309 target = this.method_5968();
        if (target != null && target.method_5858((class_1297)this) > 140.0) {
            return true;
        }
        return this.field_5974.method_43057() < 0.2f || !VANISH.equals(prev) && this.vanishNext;
    }

    protected void method_5623(double dist, boolean groundLogic, class_2680 state, class_2338 pos) {
    }

    private void teleport(double x, double y, double z) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        while (mutableBlockPos.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutableBlockPos).method_51366()) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutableBlockPos);
        if (!blockState.method_51366()) {
            y = this.method_23318();
        }
        this.method_5859(x, y + 1.0, z);
    }

    private void teleportTowards(class_1297 entity) {
        class_243 look = EntityUtils.horizontalLookAngle(entity).method_1021(-1.5);
        class_243 behindEntity = entity.method_19538().method_1019(look);
        class_243 dir = new class_243(behindEntity.field_1352 - this.method_23317(), behindEntity.field_1351 - this.method_23318(), behindEntity.field_1350 - this.method_23321());
        if (dir.method_1027() < 100.0) {
            this.teleport(behindEntity.field_1352, behindEntity.field_1351, behindEntity.field_1350);
        } else {
            dir = dir.method_1029();
            double e = this.method_23317() + this.field_5974.method_43058() * 9.0 * dir.field_1352;
            double g = this.method_23321() + this.field_5974.method_43058() * 9.0 * dir.field_1350;
            this.teleport(e, entity.method_23318(), g);
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)RuneCraftorySounds.ENTITY_GHOST_AMBIENT.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

