/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.GustSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_4140;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Weagle
extends BaseMonster {
    public static final TypedResource<class_243> SWOOP_MOTION = new TypedResource(RuneCraftory.modRes("swoop_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String GALE = BUILDER.add("gale", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.28}));
    public static final String PECK = BUILDER.add("peck", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.2}));
    public static final String INTERACT = BUILDER.add("interact", PECK);
    public static final String SWOOP = BUILDER.add("swoop", AnimationsBuilder.definition((double)0.6).marker("swoop_start", new double[]{0.2}).marker("swoop_end", new double[]{0.48}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)2.0).infinite());
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    protected List<class_1309> hitEntity;
    private final AnimationHandler<Weagle> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.hitEntity = null;
        this.setSwoopMotion(null);
        return false;
    });

    public Weagle(class_1299<? extends BaseMonster> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new FreeMoveControl((class_1308)this, 90.0f, 50.0f, FreeMoveControl.TRUE);
        this.method_5875(true);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(SWOOP_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23720).method_6192(0.33);
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{PECK}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{SWOOP}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{GALE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(2.0f).radius(4.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(7.0f)}).add(5, MonsterBehaviourUtils.ifCloserThan(15.0), new ExtendedBehaviour[]{new SetRandomFlyingTarget().flightTargetPredicate((entity, pos) -> {
            class_1309 target;
            class_1309 class_13092 = target = BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_22355) ? BrainUtils.getTargetOfEntity((class_1309)entity) : null;
            if (target == null) {
                target = entity.method_5968();
            }
            return target != null && target.method_5707(pos) <= 121.0 && Math.abs(target.method_23318() - pos.method_10214()) < 6.0;
        }), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomHoverTarget();
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{SWOOP})) {
            return this.getSwoopMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public void method_6091(class_243 vec) {
        super.handleFreeTravel(vec);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        if (anim != null && anim.equals(GALE)) {
            int diffAdd = this.difficultyCooldown();
            return this.method_59922().method_43048(40) + 50 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{SWOOP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2).method_1014(grow), this.method_36454(), 0.0f, this.method_19538().method_1019(this.method_18798()));
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{GALE})) {
            if (anim.isAt("attack")) {
                ((GustSpell)RuneCraftorySpells.GUST_SPELL.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{SWOOP})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList<class_1309>();
            }
            if (this.getSwoopMotion() == null) {
                this.setSwoopMotion(EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(0.2).method_1031(0.0, -0.3, 0.0));
            }
            if (anim.isPast("swoop_start") && !anim.isPast("swoop_end")) {
                this.method_18799(this.getSwoopMotion());
                this.mobAttack(anim, null, e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
            } else {
                this.method_18799(this.getSwoopMotion().method_18805(-1.0, -0.7, -1.0));
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Weagle> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.GUST_SPELL.get() : null)) {
                return;
            }
            switch (command) {
                case 2: {
                    this.getAnimationHandler().setAnimation(GALE);
                    break;
                }
                case 1: {
                    this.getAnimationHandler().setAnimation(SWOOP);
                    break;
                }
                default: {
                    this.getAnimationHandler().setAnimation(PECK);
                }
            }
        }
    }

    protected void method_5623(double dist, boolean groundLogic, class_2680 state, class_2338 pos) {
    }

    public class_243 getSwoopMotion() {
        return (class_243)this.getDataContainer().get(SWOOP_MOTION);
    }

    public void setSwoopMotion(class_243 swoopMotion) {
        this.getDataContainer().set(SWOOP_MOTION, (Object)swoopMotion);
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    protected void method_5801() {
        this.method_5783((class_3414)RuneCraftorySounds.ENTITY_WEAGLE_FLAP.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

