/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.lib.LootTableResources;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class Wooly
extends LeapingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SLAP = BUILDER.add("slap", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.28, 0.56}));
    public static final String KICK = BUILDER.add("kick", AnimationsBuilder.definition((double)1.0).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{0.92}));
    public static final String HEADBUTT = BUILDER.add("headbutt", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.44}));
    public static final String INTERACT = BUILDER.add("interact", HEADBUTT);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    protected static final class_2940<Boolean> SHEARED = class_2945.method_12791(Wooly.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> SPAWNSHEARED = class_2945.method_12791(Wooly.class, (class_2941)class_2943.field_13323);
    private final AnimationHandler<Wooly> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Wooly(class_1299<? extends Wooly> type, class_1937 level) {
        super((class_1299<? extends LeapingMonster>)type, level);
        boolean sheared = (double)this.method_59922().method_43057() < 0.05;
        this.field_6011.method_12778(SPAWNSHEARED, (Object)sheared);
        this.field_6011.method_12778(SHEARED, (Object)sheared);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.22);
        super.applyAttributes();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPAWNSHEARED, (Object)false);
        builder.method_56912(SHEARED, (Object)false);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SLAP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{HEADBUTT}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{KICK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepareOptional(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(3)), MonsterBehaviourUtils.moveTo()}).end(1).start(new String[]{KICK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepareOptional(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(5.0, 4.0), MonsterBehaviourUtils.moveTo()}).end(1).build().startCondition(MonsterBehaviourUtils.chancedStart(this::attackChance));
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(5, MonsterBehaviourUtils.ifCloserThan(5.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Sheared", this.isSheared());
        compound.method_10556("SpawnedSheared", ((Boolean)this.field_6011.method_12789(SPAWNSHEARED)).booleanValue());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setSheared(compound.method_10577("Sheared"));
        this.field_6011.method_12778(SPAWNSHEARED, (Object)compound.method_10577("SpawnedSheared"));
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(RunecraftoryTags.Items.SHEARS)) {
            if (!(this.method_37908().field_9236 || this.isSheared() || this.isTamed() && !player.method_5667().equals(this.method_6139()))) {
                this.shear(player, itemStack);
                itemStack.method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_59922().method_43048(20) + 30 + diffAdd;
        }
        return this.method_59922().method_43048(30) + 30 + diffAdd;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.9;
        if (anim.is(new String[]{HEADBUTT}) || anim.is(new String[]{KICK})) {
            length *= 1.5;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, this.vehicleDependentHeight() + 0.02, length);
    }

    public AnimationHandler<Wooly> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isLeapingAnim(String anim) {
        return anim.equals(KICK);
    }

    @Override
    public class_243 getLeapVec(@Nullable class_243 target) {
        return super.getLeapVec(target).method_1021(1.2);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(KICK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(HEADBUTT);
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }

    @Override
    protected void tameEntity(class_1657 owner) {
        super.tameEntity(owner);
        this.field_6011.method_12778(SPAWNSHEARED, (Object)false);
    }

    protected float attackChance() {
        return (Boolean)this.method_5841().method_12789(SPAWNSHEARED) != false || this.isTamed() ? 0.8f : 0.0f;
    }

    public void shear(class_1657 player, class_1799 used) {
        class_52 lootTable = this.method_37908().method_8503().method_58576().method_58295(Wooly.shearedLootTable(this.method_5991()));
        lootTable.method_51882(this.dailyDropContext().method_51877(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_51877(class_181.field_1229, (Object)used).method_51875(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((Wooly)this).method_5775(arg_0));
        this.setSheared(true);
        this.method_5783(class_3417.field_14975, 1.0f, 1.0f);
        this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
    }

    public static class_5321<class_52> shearedLootTable(class_5321<class_52> def) {
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)def.method_29177().method_12836(), (String)(def.method_29177().method_12832() + "_sheared_drops")));
    }

    protected class_5321<class_52> method_5991() {
        if (this.isSheared()) {
            return super.method_5991();
        }
        return LootTableResources.WOOLY_WHITE;
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public void setSheared(boolean flag) {
        this.field_6011.method_12778(SHEARED, (Object)flag);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14730;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14814;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.7f;
    }

    @Override
    public void onDailyUpdate(int daysPassed) {
        super.onDailyUpdate(daysPassed);
        if (!((Boolean)this.field_6011.method_12789(SPAWNSHEARED)).booleanValue() || this.isTamed()) {
            this.setSheared(false);
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

