/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.PollenEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ButterflySpell;
import io.github.flemmli97.runecraftory.common.spells.SleepBallSpell;
import io.github.flemmli97.runecraftory.common.spells.WaveSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Ambrosia
extends BossMonster {
    public static final TypedResource<class_243> MOVE_DIRECTION = new TypedResource(RuneCraftory.modRes("move_direction"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String KICK_1 = BUILDER.add("kick_1", AnimationsBuilder.definition((double)0.8).marker("move", new double[]{0.44}).marker("attack", new double[]{0.52}));
    public static final String KICK_2 = BUILDER.add("kick_2", AnimationsBuilder.definition((double)0.6).marker("move", new double[]{0.24}).marker("attack", new double[]{0.32}));
    public static final String KICK_3 = BUILDER.add("kick_3", AnimationsBuilder.definition((double)0.84).marker("move", new double[]{0.44}).marker("attack", new double[]{0.28}));
    public static final String BUTTERFLY = BUILDER.add("butterfly", AnimationsBuilder.definition((double)2.08).marker("attack", new double[]{0.36}));
    public static final String WAVE = BUILDER.add("wave", AnimationsBuilder.definition((double)2.24).marker("attack", new double[]{0.24}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.52}));
    public static final String POLLEN = BUILDER.add("pollen", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.52}));
    public static final String POLLEN_2 = BUILDER.add("pollen_2", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.4}));
    public static final String INTERACT = BUILDER.add("interact", KICK_1);
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.4}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.24}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Ambrosia>> ATTACK_HANDLER = Ambrosia.createAnimationHandler(b -> {
        b.put((Object)BUTTERFLY, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((ButterflySpell)RuneCraftorySpells.BUTTERFLY.get()).use((class_1309)entity);
            }
        });
        BiConsumer<AnimationState, Ambrosia> kick = (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (anim.isAt("move")) {
                class_243 dir;
                if (target != null) {
                    dir = target.method_19538().method_1020(entity.method_19538());
                    dir = new class_243(dir.method_10216(), 0.0, dir.method_10215()).method_1029();
                } else {
                    dir = EntityUtils.horizontalLookAngle((class_1297)entity);
                }
                entity.method_5784(class_1313.field_6308, dir.method_1021(0.7));
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::method_6121);
            }
        };
        b.put((Object)KICK_1, kick);
        b.put((Object)KICK_2, kick);
        b.put((Object)KICK_3, kick);
        b.put((Object)SLEEP, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((SleepBallSpell)RuneCraftorySpells.SLEEP_BALLS.get()).use((class_1309)entity);
            }
        });
        b.put((Object)WAVE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((WaveSpell)RuneCraftorySpells.WAVE.get()).use((class_1309)entity);
            }
        });
        BiConsumer<AnimationState, Ambrosia> pollenHandler = (anim, entity) -> {
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.35));
            }
            entity.method_18799(entity.getMoveDirection());
            if (anim.isAt("attack") && !EntityUtils.sealed((class_1309)entity)) {
                entity.method_5942().method_6340();
                PollenEntity pollen = new PollenEntity(entity.method_37908(), (class_1309)entity);
                pollen.setDamageMultiplier(1.1f);
                pollen.method_5814(pollen.method_23317(), pollen.method_23318() + 0.5, pollen.method_23321());
                entity.method_37908().method_8649((class_1297)pollen);
            }
        };
        b.put((Object)POLLEN, pollenHandler);
        b.put((Object)POLLEN_2, pollenHandler);
        b.put((Object)SPAWN, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_AMBROSIA_SPAWN.get(), 1.0f, 0.8f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        });
        b.put((Object)ANGRY, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_AMBROSIA_ANGRY.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        });
    });
    private final AnimationHandler<Ambrosia> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236 && anim == null) {
            this.setMoveDirection(null);
        }
        return false;
    });

    public Ambrosia(class_1299<? extends Ambrosia> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.AMBROSIA.getID(), this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.AMBROSIA_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(MOVE_DIRECTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.29);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)KICK_1).start(KICK_2).chain(KICK_3).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(7).start(MonsterBehaviourUtils.checkedAttack(SLEEP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(1))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(WAVE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(8))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(BUTTERFLY)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(24.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).radius(8.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)POLLEN).start(POLLEN_2).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(10.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(3))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).build();
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.getAnimationHandler().isCurrent(new String[]{WAVE}) && super.method_5643(source, amount);
    }

    @Override
    public boolean shouldFreezeTravel() {
        return this.getAnimationHandler().isCurrent(new String[]{WAVE});
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{POLLEN, POLLEN_2})) {
            return this.getMoveDirection();
        }
        return super.directionToLookAt();
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        super.setupAttack(anim);
        if (anim.is(new String[]{BUTTERFLY}) && this.method_5968() != null) {
            class_1309 target = this.method_5968();
            this.setTargetPosition(new TargetPosition(target.method_19538(), target.method_23318(), target.method_23318() + (double)target.method_17682() * 0.3));
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{POLLEN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 2.0, grow, grow + 2.0), this.method_36454(), this.method_36455(), this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Ambrosia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.WAVE.get())) {
                    this.getAnimationHandler().setAnimation(WAVE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.SLEEP_BALLS.get())) {
                    this.getAnimationHandler().setAnimation(SLEEP);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(KICK_1);
            }
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{POLLEN, ANGRY, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    public class_243 getMoveDirection() {
        return (class_243)this.getDataContainer().get(MOVE_DIRECTION);
    }

    public void setMoveDirection(class_243 direction) {
        this.getDataContainer().set(MOVE_DIRECTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

