/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.GustRockSpell;
import io.github.flemmli97.runecraftory.common.spells.TornadoSpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeBarrageSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector3d;

public class Grimoire
extends BossMonster {
    private static final List<Vector3d> CIRCLE_PARTICLE_MOTION = MathUtils.rotatedVecs((Vector3d)new Vector3d(0.25, 0.0, 0.0), (Vector3d)new Vector3d(0.0, 1.0, 0.0), (float)-180.0f, (float)175.0f, (float)5.0f);
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TAIL_SWIPE = BUILDER.add("tail_swipe", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.52}));
    public static final String INTERACT = BUILDER.add("interact", TAIL_SWIPE);
    public static final String BITE = BUILDER.add("bite", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.48}));
    public static final String GUST = BUILDER.add("gust", AnimationsBuilder.definition((double)1.96).marker("attack", new double[]{0.32}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.76).infinite().marker("charge_start", new double[]{0.24}).marker("charge_end", new double[]{1.76}));
    public static final String CHARGE_LAND = BUILDER.add("charge_land", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.16}));
    public static final String WIND_BREATH = BUILDER.add("wind_breath", AnimationsBuilder.definition((double)1.44).marker("attack", new double[]{0.52}));
    public static final String TORNADO = BUILDER.add("tornado", AnimationsBuilder.definition((double)1.4).marker("attack", new double[]{0.52}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.36}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.36}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final byte CHARGE_LAND_EVENT = 66;
    private static final ImmutableMap<String, BiConsumer<AnimationState, Grimoire>> ATTACK_HANDLER = Grimoire.createAnimationHandler(b -> {
        BiConsumer<AnimationState, Grimoire> melee = (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        };
        b.put((Object)TAIL_SWIPE, melee);
        b.put((Object)BITE, melee);
        b.put((Object)GUST, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((GustRockSpell)RuneCraftorySpells.GUST_ROCKS.get()).use((class_1309)entity);
            }
        });
        b.put((Object)WIND_BREATH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((WindBladeBarrageSpell)RuneCraftorySpells.WIND_BLADE_BARRAGE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)TORNADO, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((TornadoSpell)RuneCraftorySpells.TORNADO.get()).use((class_1309)entity);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("charge_start") && !anim.isPast("charge_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<class_1309>();
                }
                if (entity.getChargeMotion() == null) {
                    entity.setChargeMotion(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.35));
                }
                entity.method_18799(entity.getChargeMotion());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.BACK, 2.0f))) {
                        entity.hitEntity.add((class_1309)e);
                    }
                });
            }
            if (anim.isPast("charge_end")) {
                entity.method_18799(entity.method_18798().method_1031(0.0, -0.06, 0.0));
                if (entity.method_18798().field_1351 < -0.72) {
                    entity.method_18800(entity.method_18798().field_1352, -0.72, entity.method_18798().field_1350);
                }
                if (entity.method_24828()) {
                    entity.getAnimationHandler().setAnimation(CHARGE_LAND);
                }
                if (!(!anim.isPast(6.0) || entity.method_25936().method_27852(class_2246.field_10124) && entity.method_25936().method_27852(class_2246.field_10124))) {
                    entity.getAnimationHandler().setAnimation(CHARGE_LAND);
                }
            }
        });
        b.put((Object)CHARGE_LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                DynamicDamage.Builder source = new DynamicDamage.Builder((class_1297)entity).noKnockback().element(ItemElement.WIND).hurtResistant(5);
                entity.mobAttack((AnimationState)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, source));
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 4, 3.0f);
                entity.method_37908().method_8396(null, entity.method_24515(), (class_3414)class_3417.field_15152.comp_349(), entity.method_5634(), 1.0f, 0.9f);
                entity.method_37908().method_8421((class_1297)entity, (byte)66);
            }
        });
        BiConsumer<AnimationState, Grimoire> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_GRIMOIRE_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Grimoire> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim == null || anim.is(new String[]{CHARGE})) {
            this.hitEntity = null;
        }
        if (!this.method_37908().field_9236 && anim == null) {
            boolean chain = !this.commanded;
            this.setChargeMotion(null);
            this.commanded = false;
            if (chain && this.isEnraged() && this.getAnimationHandler().isCurrent(new String[]{BITE})) {
                this.getAnimationHandler().setAnimation(TAIL_SWIPE);
                return true;
            }
        }
        return false;
    });
    protected List<class_1309> hitEntity;
    private boolean commanded;

    public Grimoire(class_1299<? extends Grimoire> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.GRIMOIRE.getID(), this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.GRIMOIRE_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.29);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(TAIL_SWIPE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(7).start(MonsterBehaviourUtils.checkedAttack(TAIL_SWIPE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged() && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(4).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)BITE).start(TAIL_SWIPE, BossMonster::isEnraged).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(GUST)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(13.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(CHARGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(16.0)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(WIND_BREATH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(TORNADO)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(9.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public MoveType calculateMoveType() {
        if (!this.method_6062() && !this.method_24828()) {
            return MoveType.FLY;
        }
        return super.calculateMoveType();
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public void method_5711(byte id) {
        super.method_5711(id);
        if (id == 66) {
            for (Vector3d vec : CIRCLE_PARTICLE_MOTION) {
                AdvancedParticleContainer.make((class_2394)((class_2394)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.2627451f, 0.6392157f, 0.25490198f, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new MotionData(vec.x(), vec.y(), vec.z())).addData((AdvancedParticleData)new ParticleMetaData(20, false, 0.0f)).add(this.method_37908(), this.method_23317(), this.method_23318() + 0.2, this.method_23321());
            }
        }
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT, CHARGE})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE, CHARGE_LAND})) {
            return this.getChargeMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{CHARGE_LAND})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(1.4, 0.1, 1.4), this.method_36454(), 0.0f, this.method_19538());
        }
        if (anim.is(new String[]{CHARGE})) {
            double width = this.method_17681();
            double speed = Math.max(width, this.method_18798().method_1033() - width);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.5, 0.1, grow + 0.5).method_1012(0.0, 0.0, speed), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.5;
        if (anim.is(new String[]{TAIL_SWIPE})) {
            width = (double)this.method_17681() * 1.5;
            length = (double)this.method_17681() * 1.45;
            return new class_238(-width * 0.65, -0.02, 0.0, width * 0.35, (double)this.method_17682() + 0.02, length);
        }
        if (anim.is(new String[]{BITE})) {
            width = (double)this.method_17681() * 1.1;
            length = (double)this.method_17681() * 1.4;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Grimoire> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.WIND_BLADE_BARRAGE.get())) {
                    this.getAnimationHandler().setAnimation(WIND_BREATH);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                    this.getAnimationHandler().setAnimation(TAIL_SWIPE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(BITE);
            }
            this.commanded = true;
        }
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (prev != null && prev.equals(BITE)) {
            return !this.isEnraged() || !TAIL_SWIPE.equals(other);
        }
        return super.allowAnimation(prev, other);
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeMotion(class_243 direction) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

