/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.MarionettaTrapEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListListener;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.CardThrowSpell;
import io.github.flemmli97.runecraftory.common.spells.DarkBeamSpell;
import io.github.flemmli97.runecraftory.common.spells.FurnitureThrowSpell;
import io.github.flemmli97.runecraftory.common.spells.PlushThrowSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.DummyBehaviour;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.LeapInDirection;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4140;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class Marionetta
extends BossMonster
implements BoundEntityListListener {
    private static final class_2940<Boolean> CAUGHT = class_2945.method_12791(Marionetta.class, (class_2941)class_2943.field_13323);
    public static final TypedResource<class_243> MOVE_DIRECTION = new TypedResource(RuneCraftory.modRes("move_direction"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("melee", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.4}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{1.56}));
    public static final String CARD_ATTACK = BUILDER.add("card_attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.48}));
    public static final String CHEST_ATTACK = BUILDER.add("chest_attack", AnimationsBuilder.definition((double)1.08).marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{0.88}));
    public static final String CHEST_THROW = BUILDER.add("chest_throw", AnimationsBuilder.definition((double)MarionettaTrapEntity.DURATION, (boolean)false).marker("attack", new double[]{0.28}));
    public static final String STUFFED_ANIMALS = BUILDER.add("stuffed_animals", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.52}));
    public static final String DARK_BEAM = BUILDER.add("dark_beam", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.48}));
    public static final String FURNITURE = BUILDER.add("furniture", AnimationsBuilder.definition((double)1.12).marker("attack", new double[]{0.52}));
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)0.6));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.52}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.52}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Marionetta>> ATTACK_HANDLER = Marionetta.createAnimationHandler(b -> {
        b.put((Object)MELEE, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (target != null) {
                entity.method_5942().method_6335((class_1297)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::method_6121);
            }
        });
        b.put((Object)SPIN, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.5));
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.method_18799(entity.getMoveDirection());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    float strength;
                    if (CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(8)) && (strength = (float)(2.0 * (1.0 - e.method_45325(class_5134.field_23718)))) > 0.0f) {
                        e.method_18799(e.method_18798().method_1019(entity.getMoveDirection().method_1021((double)strength)));
                    }
                });
            } else {
                entity.method_18799(entity.method_18798().method_1021(0.95));
            }
        });
        b.put((Object)CARD_ATTACK, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((CardThrowSpell)RuneCraftorySpells.CARD_THROW.get()).use((class_1309)entity);
            }
        });
        b.put((Object)CHEST_ATTACK, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.65));
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.method_18799(entity.getMoveDirection());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.method_5864().method_20210(RunecraftoryTags.EntityTypes.MARIONETTA_TRAP_IGNORE) && !entity.caughtEntities.has((class_1309)e)) {
                        entity.catchEntity((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)CHEST_THROW, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                class_243 throwVec = EntityUtils.horizontalLookAngle((class_1297)entity).method_1021(1.8).method_1031(0.0, 1.0, 0.0);
                MarionettaTrapEntity trap = new MarionettaTrapEntity(entity.method_37908(), (class_1309)entity);
                trap.setDamageMultiplier(0.8f);
                trap.throwIn(throwVec);
                entity.caughtEntities.forEach(trap::addCaughtEntity);
                entity.method_37908().method_8649((class_1297)trap);
                entity.caughtEntities.clear();
            }
        });
        b.put((Object)STUFFED_ANIMALS, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((PlushThrowSpell)RuneCraftorySpells.PLUSH_THROW.get()).use((class_1309)entity);
            }
        });
        b.put((Object)DARK_BEAM, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack") && !EntityUtils.sealed((class_1309)entity)) {
                ((DarkBeamSpell)RuneCraftorySpells.DARK_BEAM.get()).use((class_1309)entity);
            }
        });
        b.put((Object)FURNITURE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack") && !EntityUtils.sealed((class_1309)entity)) {
                ((FurnitureThrowSpell)RuneCraftorySpells.FURNITURE.get()).use((class_1309)entity);
            }
        });
        BiConsumer<AnimationState, Marionetta> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_MARIONETTA_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Marionetta> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.setMoveDirection(null);
        if (((Boolean)this.field_6011.method_12789(CAUGHT)).booleanValue() && !this.method_37908().field_9236) {
            this.field_6011.method_12778(CAUGHT, (Object)false);
            this.getAnimationHandler().setAnimation(CHEST_THROW);
            return true;
        }
        return false;
    });
    private final BoundEntityListHandler<Marionetta> caughtEntities = new BoundEntityListHandler<Marionetta>(this);

    public Marionetta(class_1299<? extends Marionetta> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.MARIONETTA.getID(), this.method_5476(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.MARIONETTA_FIGHT.get());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CAUGHT, (Object)false);
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(MOVE_DIRECTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.26);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(MELEE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(CARD_ATTACK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new LeapInDirection().shouldLeap((entity, target) -> {
            if (entity.method_5858((class_1297)target) < 9.0) {
                entity.getAnimationHandler().setAnimation(LEAP);
                return true;
            }
            return false;
        }).strength(1.2).horizontalDirection((entity, target) -> LeapInDirection.createBackwardsVec((class_243)entity.method_19538(), (class_243)target.method_19538())).whenStarting(m -> m.getAnimationHandler().setAnimation(LEAP))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(11).start(MonsterBehaviourUtils.checkedAttack(SPIN)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(14)).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(CHEST_ATTACK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(14)).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).start(MonsterBehaviourUtils.checkedAttack(STUFFED_ANIMALS)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(6.0).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(DARK_BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(12)).speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(6).start(MonsterBehaviourUtils.checkedAttack(FURNITURE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(12, new ExtendedBehaviour[]{DummyBehaviour.opt((ExtendedBehaviour)new InvalidateMemory(class_4140.field_18445)), DummyBehaviour.opt((ExtendedBehaviour)new LeapInDirection().shouldLeap((e, t) -> {
            if (e.method_59922().method_43057() < 4.0f) {
                e.getAnimationHandler().setAnimation(LEAP);
                return true;
            }
            return false;
        }).horizontalDirection((entity, target) -> {
            if (entity.method_5858((class_1297)target) <= 5.0) {
                return LeapInDirection.createBackwardsVec((class_243)entity.method_19538(), (class_243)target.method_19538());
            }
            return LeapInDirection.createSidewaysVec((class_243)entity.method_19538(), (class_243)target.method_19538(), (boolean)entity.method_59922().method_43056());
        }).strength(1.2).cooldownFor(e -> 60)), new StrafeTarget().strafeDistance(10.0f)}).add(4, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(3.0f).radius(6.0), MonsterBehaviourUtils.moveTo()}).add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected boolean runCooldownBehaviour() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return (anim == null || anim.is(new String[]{LEAP})) && BrainUtils.hasMemory((class_1309)this, (class_4140)class_4140.field_22475);
    }

    @Override
    public void method_5670() {
        super.method_5670();
        this.caughtEntities.forEach(entity -> {
            if (entity.method_5805()) {
                entity.method_18799(class_243.field_1353);
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    player.method_24203(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.2, this.method_23321());
                } else {
                    entity.method_5814(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.2, this.method_23321());
                }
                entity.field_6037 = true;
            }
        });
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1309 living;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && this.caughtEntities.has(living = (class_1309)class_12972)) {
            return false;
        }
        return !this.getAnimationHandler().isCurrent(new String[]{CHEST_THROW}) && super.method_5643(source, amount);
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    public void method_5697(class_1297 entityIn) {
        if (this.getAnimationHandler().isCurrent(new String[]{SPIN, CHEST_ATTACK})) {
            return;
        }
        super.method_5697(entityIn);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{SPIN, CHEST_ATTACK})) {
            return this.getMoveDirection();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        class_243 dir = this.getMoveDirection();
        if (dir == null) {
            dir = target != null ? target.method_1020(this.method_19538()) : this.method_5828(1.0f);
        }
        if (anim.is(new String[]{SPIN})) {
            float rotY = -class_3532.method_15393((float)((float)(class_3532.method_15349((double)dir.method_10216(), (double)dir.method_10215()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1012(0.0, 0.0, -1.0).method_1009(grow + 0.5, 0.1, grow + 1.2), rotY, 0.0f, this.method_19538());
        }
        if (anim.is(new String[]{CHEST_ATTACK})) {
            float rotY = -class_3532.method_15393((float)((float)(class_3532.method_15349((double)dir.method_10216(), (double)dir.method_10215()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.5, 0.1, grow + 1.2), rotY, 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim.equals(CHEST_ATTACK)) {
            cooldown += class_3532.method_15384((double)this.getAnimationHandler().get(CHEST_THROW).length());
        }
        return cooldown;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Marionetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.CARD_THROW.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CARD_ATTACK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    private void catchEntity(class_1309 entity) {
        this.caughtEntities.add(entity);
        this.field_6011.method_12778(CAUGHT, (Object)true);
    }

    public boolean caughtTarget() {
        return (Boolean)this.field_6011.method_12789(CAUGHT);
    }

    public class_243 getMoveDirection() {
        return (class_243)this.getDataContainer().get(MOVE_DIRECTION);
    }

    public void setMoveDirection(class_243 direction) {
        this.getDataContainer().set(MOVE_DIRECTION, (Object)direction);
    }

    @Override
    public double deathRayOffset() {
        return (double)this.method_17682() * 0.1;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public BoundEntityListHandler<?> getList() {
        return this.caughtEntities;
    }
}

