/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.GroundShakeParticleSpawner;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BigLeafSpell;
import io.github.flemmli97.runecraftory.common.spells.SmallLeafSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9064;
import net.minecraft.class_9066;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Raccoon
extends BossMonster {
    private static final class_2940<Integer> CLONE_INDEX = class_2945.method_12791(Raccoon.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> BERSERK = class_2945.method_12791(Raccoon.class, (class_2941)class_2943.field_13323);
    public static final class_243[] CLONE_POS = new class_243[]{new class_243(-6.0, 0.0, 0.0), new class_243(0.0, 0.0, -6.0), new class_243(6.0, 0.0, 0.0), new class_243(0.0, 0.0, 6.0)};
    public static final TypedResource<class_243> CLONE_POSITION = new TypedResource(RuneCraftory.modRes("clone_position"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DOUBLE_PUNCH = BUILDER.add("double_punch", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.4, 0.68}));
    public static final String INTERACT = BUILDER.add("interact", DOUBLE_PUNCH);
    public static final String PUNCH = BUILDER.add("punch", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.6}));
    public static final String INTERACT_BERSERK = BUILDER.add("interact_berserk", PUNCH);
    public static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)1.12).marker("jump", new double[]{0.24}).infinite());
    public static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.36).marker("attack", new double[]{0.12}));
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)1.4).marker("attack_1", new double[]{0.6}).marker("attack_2", new double[]{1.16}));
    public static final String LEAF_SHOOT = BUILDER.add("shoot", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.56}));
    public static final String LEAF_BOOMERANG = BUILDER.add("spinning_shoot", LEAF_SHOOT);
    public static final String LEAF_SHOT_CLONE = BUILDER.add("leaf_clone", AnimationsBuilder.definition((double)1.0).animationId("shoot").marker("attack", new double[]{0.56, 0.76}));
    public static final String BARRAGE = BUILDER.add("punch_barrage", AnimationsBuilder.definition((double)3.4).marker("attack", new double[]{0.6, 0.92, 1.36}).marker("vulnerable_start", new double[]{1.64}).marker("vulnerable_end", new double[]{3.08}));
    public static final String ROAR = BUILDER.add("roar", AnimationsBuilder.definition((double)1.28).marker("roar", new double[]{0.28}));
    public static final String CLONE = BUILDER.add("clone", AnimationsBuilder.definition((double)1.28).marker("start", new double[]{0.1}));
    public static final String TRANSFORM = BUILDER.add("transform", AnimationsBuilder.definition((double)1.5));
    public static final String UNTRANSFORM = BUILDER.add("untransform", AnimationsBuilder.definition((double)2.2).marker("knockback_start", new double[]{1.0}).marker("knockback_end", new double[]{1.5}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("smoke", new double[]{0.72}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.28}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final byte SPAWN_SMOKE_EVENT = 66;
    private static final ImmutableMap<String, BiConsumer<AnimationState, Raccoon>> ATTACK_HANDLER = Raccoon.createAnimationHandler(b -> {
        b.put((Object)DOUBLE_PUNCH, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (target != null) {
                entity.method_5942().method_6335((class_1297)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::method_6121);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)BARRAGE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                class_243 dir;
                class_1309 target = entity.method_5968();
                if (target != null) {
                    class_243 targetPos = target.method_19538();
                    dir = new class_243(targetPos.field_1352 - entity.method_23317(), 0.0, targetPos.field_1350 - entity.method_23321()).method_1029();
                    entity.setTargetPosition(target);
                } else {
                    dir = EntityUtils.horizontalLookAngle((class_1297)entity);
                }
                entity.method_18799(entity.method_18798().method_1019(dir.method_1021(0.6)));
                entity.mobAttack((AnimationState)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)JUMP, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("jump")) {
                class_243 dir;
                if (entity.method_5968() != null) {
                    dir = entity.method_5968().method_19538().method_1020(entity.method_19538());
                    dir = (dir = new class_243(dir.method_10216(), 0.0, dir.method_10215())).method_1027() > 400.0 ? dir.method_1029().method_1021(2.8000000000000003) : dir.method_1021(0.14);
                } else {
                    dir = EntityUtils.horizontalLookAngle((class_1297)entity).method_1021(0.75);
                }
                entity.method_18800(dir.method_10216(), 2.2, dir.method_10215());
            }
            if (anim.isPast("jump")) {
                entity.field_6017 = 0.0f;
                entity.method_18799(entity.method_18798().method_1031(0.0, -0.08, 0.0));
                entity.method_5702(class_2183.class_2184.field_9851, entity.method_19538().method_1031(entity.method_18798().method_10216(), 0.0, entity.method_18798().method_10215()));
                if (entity.method_18798().field_1351 < -1.1) {
                    entity.method_18800(entity.method_18798().field_1352, -1.1, entity.method_18798().field_1350);
                }
                if (anim.done(0) && entity.method_24828()) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
                if (!(!anim.isPast(6.0) || entity.method_25936().method_27852(class_2246.field_10124) && entity.method_25936().method_27852(class_2246.field_10124))) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
            }
        });
        b.put((Object)LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                DynamicDamage.Builder source = new DynamicDamage.Builder((class_1297)entity).noKnockback().element(ItemElement.EARTH).hurtResistant(5).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.STUN.asHolder(), 80.0);
                entity.mobAttack((AnimationState)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, source));
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 8, 3.0f);
                entity.method_37908().method_8649((class_1297)new GroundShakeParticleSpawner(entity.method_37908(), (class_1309)entity, 360.0, (double)entity.method_17681() * 1.8));
                entity.method_37908().method_8396(null, entity.method_24515(), (class_3414)class_3417.field_15152.comp_349(), entity.method_5634(), 1.0f, 0.9f);
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack_1") || anim.isAt("attack_2")) {
                DynamicDamage.Builder source = new DynamicDamage.Builder((class_1297)entity).noKnockback().element(ItemElement.EARTH).hurtResistant(5).withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.STUN.asHolder(), 50.0);
                entity.mobAttack((AnimationState)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, source));
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 8, 3.0f);
                entity.method_37908().method_8396(null, entity.method_24515(), (class_3414)class_3417.field_15152.comp_349(), entity.method_5634(), 1.0f, 0.9f);
            }
        });
        b.put((Object)LEAF_SHOOT, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X7.get()).use((class_1309)entity);
                } else if (entity.isTamed() || (double)entity.field_5974.method_43057() < 0.6) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X3.get()).use((class_1309)entity);
                } else {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X5.get()).use((class_1309)entity);
                }
            }
        });
        b.put((Object)LEAF_SHOT_CLONE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X7.get()).use((class_1309)entity);
                } else if ((double)entity.field_5974.method_43057() < 0.6) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X3.get()).use((class_1309)entity);
                } else {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X5.get()).use((class_1309)entity);
                }
            }
        });
        b.put((Object)LEAF_BOOMERANG, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((BigLeafSpell)RuneCraftorySpells.BIG_LEAF_SPELL_DOUBLE.get()).use((class_1309)entity);
                } else {
                    ((BigLeafSpell)RuneCraftorySpells.BIG_LEAF_SPELL.get()).use((class_1309)entity);
                }
            }
        });
        b.put((Object)ROAR, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("roar")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_RACCOON_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        });
        b.put((Object)CLONE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("start")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_RACCOON_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
                class_243 center = entity.method_5968() == null ? entity.method_19538() : (entity.method_5858((class_1297)entity.method_5968()) < 144.0 ? entity.method_5968().method_19538() : entity.method_5968().method_19538().method_1020(entity.method_19538()).method_1029().method_1021(12.0).method_1019(entity.method_19538()));
                entity.setClonePos(center);
                int id = entity.field_5974.method_43048(CLONE_POS.length);
                class_243 pos2 = CLONE_POS[id];
                entity.field_6011.method_12778(CLONE_INDEX, (Object)id);
                entity.method_5859(center.method_10216() + pos2.field_1352, center.method_10214() + pos2.field_1351, center.method_10215() + pos2.field_1350);
            }
            entity.cloneCenter().ifPresent(pos -> entity.method_5702(class_2183.class_2184.field_9853, (class_243)pos));
        });
        b.put((Object)UNTRANSFORM, (anim, entity) -> {
            if (entity.method_24828() && anim.isPast("knockback_start") && !anim.isPast("knockback_end")) {
                entity.method_5762(0.0, 0.4, 0.0);
            }
        });
        b.put((Object)SPAWN, (anim, entity) -> {
            if (anim.isAt("smoke")) {
                entity.method_37908().method_8421((class_1297)entity, (byte)66);
            }
        });
        b.put((Object)ANGRY, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_RACCOON_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        });
    });
    private final AnimationHandler<Raccoon> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            if (anim == null && this.isBerserk() && this.getAnimationHandler().isCurrent(new String[]{TRANSFORM}) && this.pendingAngry) {
                this.pendingAngry = false;
                this.getAnimationHandler().setAnimation(ANGRY);
                return true;
            }
            this.setClonePos(null);
            if (anim == null && this.getAnimationHandler().isCurrent(new String[]{CLONE})) {
                this.getAnimationHandler().setAnimation(this.method_59922().method_43056() ? LEAF_SHOT_CLONE : LEAF_BOOMERANG);
                return true;
            }
        }
        return false;
    });
    private int hit;
    private int hitCountdown = -1;
    private final class_4048 berserkDimensions = class_4048.method_18384((float)1.4f, (float)2.5f).method_55684(class_9066.method_55673().method_55683(class_9064.field_47743, new class_243(0.0, 1.875, -0.4375)));
    private boolean pendingAngry;

    public Raccoon(class_1299<? extends Raccoon> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.RACCOON.getID(), this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.RACCOON_FIGHT.get());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BERSERK, (Object)false);
        builder.method_56912(CLONE_INDEX, (Object)0);
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CLONE_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (BERSERK.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.27);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(DOUBLE_PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(20).start(MonsterBehaviourUtils.checkedAttack(DOUBLE_PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(17).start(MonsterBehaviourUtils.checkedAttack(PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(7.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(20).start(MonsterBehaviourUtils.checkedAttack(JUMP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(24.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(16))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(18).start(MonsterBehaviourUtils.checkedAttack(STOMP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(7.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(18).start(MonsterBehaviourUtils.checkedAttack(LEAF_SHOOT)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(20.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).minDist(4.0f).radius(9.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(17).start(MonsterBehaviourUtils.checkedAttack(LEAF_BOOMERANG)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(20.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).minDist(4.0f).radius(6.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(18).start(MonsterBehaviourUtils.checkedAttack(ROAR)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(12.0))).end(3).start(MonsterBehaviourUtils.checkedAttack(BARRAGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(7.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(MonsterBehaviourUtils.checkedAttack(CLONE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(32.0))).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, Raccoon::isBerserk, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.withCondition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(6.0).test(m)), new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(1.1f), MonsterBehaviourUtils.moveTo()}).add(4, m -> !m.isBerserk() && MonsterBehaviourUtils.ifFurtherThan(4.0).test(m), new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(3)), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.withCondition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).minDist(4.0f).radius(6.0).speedMod(1.1f), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            --this.hitCountdown;
            if (this.method_5805() && !this.isBerserk() && (this.hitCountdown == 0 || this.hit >= 5)) {
                this.setBerserk(true, false);
                this.hit = 0;
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            if (!this.isBerserk()) {
                this.pendingAngry = true;
            } else {
                this.getAnimationHandler().setAnimation(ANGRY);
            }
        }
    }

    public boolean isBerserk() {
        return (Boolean)this.field_6011.method_12789(BERSERK);
    }

    public void setBerserk(boolean flag, boolean load) {
        this.field_6011.method_12778(BERSERK, (Object)flag);
        this.method_18382();
        if (!load) {
            if (flag) {
                this.getAnimationHandler().setAnimation(TRANSFORM);
            } else {
                this.getAnimationHandler().setAnimation(UNTRANSFORM);
            }
        }
    }

    public class_4048 method_55694(class_4050 pose) {
        if (this.isBerserk()) {
            return this.berserkDimensions.method_18383(this.method_17825());
        }
        return super.method_55694(pose);
    }

    @Override
    public float method_55693() {
        if (this.isBerserk()) {
            return super.method_55693() * 1.4f;
        }
        return super.method_55693();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Berserk", this.isBerserk());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setBerserk(compound.method_10577("Berserk"), true);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new String[]{JUMP, LAND, DEFEAT, TRANSFORM, UNTRANSFORM, ANGRY, SPAWN})) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    protected void method_6074(class_1282 source, float damageAmount) {
        AnimationState anim;
        super.method_6074(source, damageAmount);
        if (!this.isBerserk()) {
            ++this.hit;
            this.hitCountdown = 30;
        } else if (this.getAnimationHandler().isCurrent(new String[]{BARRAGE}) && (anim = this.getAnimationHandler().getAnimation()).isPast("vulnerable_start") && !anim.isPast("vulnerable_end")) {
            this.setBerserk(false, false);
            this.getAnimationHandler().setAnimation(UNTRANSFORM);
            this.method_5762(0.0, 0.6, 0.0);
        }
    }

    @Override
    public void method_5711(byte id) {
        super.method_5711(id);
        if (id == 66) {
            for (int i = 0; i < 32; ++i) {
                AdvancedParticleContainer.make((class_2394)class_2398.field_11251).addData((AdvancedParticleData)new ColorData(1.0f, 1.0f, 1.0f)).addData((AdvancedParticleData)new MotionData(this.method_59922().method_43059() * 0.02, this.method_59922().method_43059() * 0.02, this.method_59922().method_43059() * 0.02)).add(this.method_37908(), this.method_23322(1.2), this.method_23323(this.method_59922().method_43058() * 1.2), this.method_23325(1.2));
            }
        }
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance - 5.0f, damageMultiplier);
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, ROAR, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    public void method_5697(class_1297 entityIn) {
        if (this.getAnimationHandler().isCurrent(new String[]{ROAR, CLONE, TRANSFORM})) {
            return;
        }
        super.method_5697(entityIn);
    }

    protected void method_6070() {
        if (!this.getAnimationHandler().isCurrent(new String[]{CLONE})) {
            super.method_6070();
        }
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new String[]{CLONE, TRANSFORM, UNTRANSFORM, ROAR});
    }

    @Override
    public MoveType calculateMoveType() {
        if (this.getAnimationHandler().isCurrent(new String[]{TRANSFORM, UNTRANSFORM})) {
            return MoveType.NONE;
        }
        return super.calculateMoveType();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{JUMP, LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), 0.0f, 0.0f, this.method_19538());
        }
        if (anim.is(new String[]{STOMP})) {
            class_243 dir;
            double reach = (double)this.method_17681() * 0.55;
            float offset = anim.isAt("attack_1") ? -90.0f : 90.0f;
            class_1309 class_13092 = this.method_5642();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                dir = class_243.method_1030((float)player.method_36455(), (float)(player.method_36454() + offset));
            } else {
                dir = class_243.method_1030((float)this.method_36455(), (float)(this.method_36454() + offset));
            }
            class_243 attackPos = this.method_19538().method_1019(dir.method_1021(reach));
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, attackPos);
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        if (anim.is(new String[]{JUMP, LAND})) {
            double attackSize = (double)this.method_17681() * 1.6;
            return new class_238(-attackSize, -0.5, -attackSize, attackSize, 2.0, attackSize);
        }
        if (anim.is(new String[]{STOMP})) {
            return new class_238(-1.9, -0.5, -2.3, 1.9, 2.0, 2.3);
        }
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.5;
        if (anim.is(new String[]{DOUBLE_PUNCH})) {
            width = (double)this.method_17681() * 1.5;
            length = (double)this.method_17681() * 1.7;
        }
        if (anim.is(new String[]{PUNCH})) {
            width = (double)this.method_17681() * 1.5;
            length = (double)this.method_17681() * 1.6;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        this.method_5942().method_6340();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Raccoon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.SMALL_LEAF_SPELL_X3.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LEAF_SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(JUMP);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_PUNCH);
            }
        }
    }

    public Optional<class_243> cloneCenter() {
        return Optional.ofNullable((class_243)this.getDataContainer().get(CLONE_POSITION));
    }

    public void setClonePos(class_243 pos) {
        this.getDataContainer().set(CLONE_POSITION, (Object)pos);
    }

    public int cloneIndex() {
        return (Integer)this.field_6011.method_12789(CLONE_INDEX);
    }

    @Override
    public String getInteractAnimation() {
        return this.isBerserk() ? INTERACT_BERSERK : INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

