/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ElementalCircleSpell;
import io.github.flemmli97.runecraftory.common.spells.ExpandingLight;
import io.github.flemmli97.runecraftory.common.spells.LightBeamSpell;
import io.github.flemmli97.runecraftory.common.spells.MissileSpell;
import io.github.flemmli97.runecraftory.common.spells.PrismSpell;
import io.github.flemmli97.runecraftory.common.spells.ShineSpell;
import io.github.flemmli97.runecraftory.common.spells.StarFallSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;

public class Sarcophagus
extends BossMonster {
    public static final TypedResource<class_243> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String TELEPORT = BUILDER.add("teleport", AnimationsBuilder.definition((double)2.64).marker("teleport_start_1", new double[]{0.2}).marker("teleport_end_1", new double[]{0.44}).marker("teleport_start_2", new double[]{1.2}).marker("teleport_end_2", new double[]{1.44}).marker("teleport_start_3", new double[]{2.2}).marker("teleport_end_3", new double[]{2.44}).marker("teleport", new double[]{0.28, 1.28, 2.28}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.6).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.48}));
    public static final String BEAM = BUILDER.add("cast", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.48}));
    public static final String LIGHT_2X = BUILDER.add("light_2x", BEAM);
    public static final String LIGHT_4X = BUILDER.add("light_4x", BEAM);
    public static final String SHINE = BUILDER.add("shine", BEAM);
    public static final String PRISM = BUILDER.add("prism", BEAM);
    public static final String INTERACT = BUILDER.add("interact", BEAM);
    public static final String BEAM_3X = BUILDER.add("cast_3x", AnimationsBuilder.definition((double)2.2).marker("attack", new double[]{0.48, 1.24, 2.0}));
    public static final String FIRE_CIRCLE = BUILDER.add("circle_cast", AnimationsBuilder.definition((double)2.32).marker("attack", new double[]{0.4}));
    public static final String WIND_CIRCLE = BUILDER.add("wind_circle", FIRE_CIRCLE);
    public static final String ICE_CIRCLE = BUILDER.add("ice_circle", FIRE_CIRCLE);
    public static final String EARTH_CIRCLE = BUILDER.add("earth_circle", FIRE_CIRCLE);
    public static final String MISSILE = BUILDER.add("missile", AnimationsBuilder.definition((double)1.04).marker("attack", new double[]{0.72}));
    public static final String STARFALL = BUILDER.add("starfall", AnimationsBuilder.definition((double)8.2).marker("attack", new double[]{0.8}).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{7.96}).marker("teleport_start", new double[]{0.2}).marker("teleport_end", new double[]{8.0}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{1.4}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.1}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Sarcophagus>> ATTACK_HANDLER = Sarcophagus.createAnimationHandler(b -> {
        b.put((Object)TELEPORT, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("teleport_start_1") || anim.isAt("teleport_end_1") || anim.isAt("teleport_start_2") || anim.isAt("teleport_end_2") || anim.isAt("teleport_start_3") || anim.isAt("teleport_end_3")) {
                entity.method_5783((class_3414)RuneCraftorySounds.GENERIC_TELEPORT.get(), 1.0f, 1.0f);
            }
            if (anim.isAt("teleport")) {
                entity.teleportAround(8, 10);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<class_1309>();
                }
                if (entity.getChargeMotion() == null) {
                    entity.setChargeDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.3));
                }
                class_243 dir = entity.getChargeMotion();
                entity.method_18800(dir.method_10216(), entity.method_18798().method_10214(), dir.method_10215());
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new DynamicDamage.Builder((class_1297)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.BACK, 2.0f))) {
                        entity.hitEntity.add((class_1309)e);
                    }
                });
                if (entity.field_6012 % 5 == 0) {
                    entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.field_5974.method_43057() - entity.field_5974.method_43057()) * 0.2f + 1.0f);
                }
            } else {
                entity.method_18799(entity.method_18798().method_1021(0.6));
            }
        });
        b.put((Object)BEAM, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((LightBeamSpell)RuneCraftorySpells.LIGHT_BEAM.get()).use((class_1309)entity);
            }
        });
        b.put((Object)BEAM_3X, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((LightBeamSpell)RuneCraftorySpells.LIGHT_BEAM.get()).use((class_1309)entity);
            }
        });
        b.put((Object)FIRE_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.FIRE_CIRCLE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)WIND_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.WIND_CIRCLE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)ICE_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.ICE_CIRCLE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)EARTH_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ElementalCircleSpell)RuneCraftorySpells.EARTH_CIRCLE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)LIGHT_2X, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ExpandingLight)RuneCraftorySpells.EXPANDING_DOUBLE_LIGHT.get()).use((class_1309)entity);
            }
        });
        b.put((Object)LIGHT_4X, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ExpandingLight)RuneCraftorySpells.EXPANDING_QUAD_LIGHT.get()).use((class_1309)entity);
            }
        });
        b.put((Object)SHINE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((ShineSpell)RuneCraftorySpells.SHINE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)PRISM, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((PrismSpell)RuneCraftorySpells.PRISM_LONG.get()).use((class_1309)entity);
            }
        });
        b.put((Object)MISSILE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((MissileSpell)RuneCraftorySpells.MISSILE_8X.get()).use((class_1309)entity);
            }
        });
        b.put((Object)STARFALL, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack_start")) {
                entity.starFallPre = entity.method_19538();
                if (entity.method_18410()) {
                    class_243 pos = class_243.method_24953((class_2382)entity.method_18412());
                    entity.method_5859(pos.field_1352, pos.field_1351 + 8.0, pos.field_1350);
                } else if (entity.method_5968() != null) {
                    entity.method_5859(entity.method_5968().method_23317(), entity.method_5968().method_23318() + 8.0, entity.method_5968().method_23321());
                } else {
                    entity.method_5859(entity.method_23317(), entity.method_23318() + 8.0, entity.method_23321());
                }
                entity.starFallPos = entity.method_19538();
                ((StarFallSpell)RuneCraftorySpells.STARFALL_LONG.get()).use((class_1309)entity);
            }
            if (entity.starFallPos != null) {
                entity.method_33574(entity.starFallPos);
            }
            if (anim.isAt("attack_end")) {
                entity.method_5859(entity.starFallPre.method_10216(), entity.starFallPre.method_10214(), entity.starFallPre.method_10215());
                entity.starFallPre = null;
                entity.starFallPos = null;
                entity.teleportAround(6, 12);
            }
        });
        b.put((Object)SPAWN, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playRandomizedSound(class_3417.field_14865);
                entity.playRandomizedSound(class_3417.field_14956);
            }
        });
        b.put((Object)ANGRY, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.method_5783((class_3414)RuneCraftorySounds.ENTITY_SARCOPHAGUS_ROAR.get(), 1.0f, 1.0f + (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f);
            }
        });
    });
    private final AnimationHandler<Sarcophagus> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.hitEntity = null;
        if (anim != null) {
            if (this.forceSetNextAttack != null && anim.is(new String[]{this.forceSetNextAttack})) {
                this.forceSetNextAttack = null;
            }
            this.teleported = anim.is(new String[]{TELEPORT});
            if (!anim.is(new String[]{TELEPORT})) {
                this.previousAttack = anim.id();
            }
            if (anim.is(new String[]{CHARGE})) {
                this.setChargeDirection(null);
                this.method_5996(class_5134.field_47761).method_26835(new class_1322(LibConstants.STEP_UP_TEMP, 1.0, class_1322.class_1323.field_6328));
            }
            if (anim.is(new String[]{STARFALL})) {
                this.gravityPre = this.method_5740();
                this.starfallCooldown = 240 + this.method_59922().method_43048(400);
                this.method_5875(true);
            }
        } else {
            this.method_5996(class_5134.field_47761).method_6200(LibConstants.STEP_UP_TEMP);
            if (this.getAnimationHandler().isCurrent(new String[]{STARFALL})) {
                this.method_5875(this.gravityPre);
            }
        }
        return false;
    });
    protected List<class_1309> hitEntity;
    private class_243 starFallPre;
    private class_243 starFallPos;
    private boolean teleported;
    private boolean gravityPre;
    private String previousAttack = "";
    private String forceSetNextAttack;
    private int starfallCooldown;

    public Sarcophagus(class_1299<? extends Sarcophagus> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.SARCOPHAGUS.getID(), this.method_5476(), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.SARCOPHAGUS_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.26);
        this.method_5996(class_5134.field_47761).method_6192(((class_1320)class_5134.field_47761.comp_349()).method_6169() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(TELEPORT)).play(MonsterBehaviourUtils.cooldownedPlay()).end(11).start(MonsterBehaviourUtils.checkedAttack(CHARGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).end(7).start(MonsterBehaviourUtils.checkedAttack(BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged()).end(8).start(MonsterBehaviourUtils.checkedAttack(BEAM_3X)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(8).start(MonsterBehaviourUtils.checkedAttack(FIRE_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(WIND_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(ICE_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(EARTH_CIRCLE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(4).start(MonsterBehaviourUtils.checkedAttack(LIGHT_2X)).play(MonsterBehaviourUtils.cooldownedPlay()).end(7).start(MonsterBehaviourUtils.checkedAttack(LIGHT_4X)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(7).start(MonsterBehaviourUtils.checkedAttack(SHINE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged()).end(7).start(MonsterBehaviourUtils.checkedAttack(PRISM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(7).start(MonsterBehaviourUtils.checkedAttack(MISSILE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(7).start(MonsterBehaviourUtils.checkedAttack(STARFALL)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && m.starfallCooldown <= 0).end(20).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget().speedModifier(0.7f);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
            this.forceSetNextAttack = STARFALL;
        }
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            --this.starfallCooldown;
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.isTeleporting() && super.method_5643(source, amount);
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            if (this.getAnimationHandler().getAnimation().isPast("attack_start")) {
                return this.getChargeMotion();
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{CHARGE})) {
            double width = this.method_17681();
            double speed = Math.max(width, this.method_18798().method_1033() - width);
            float rotY = -class_3532.method_15393((float)((float)(class_3532.method_15349((double)this.method_18798().method_10216(), (double)this.method_18798().method_10215()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.4, 0.1, grow + 0.4).method_1012(0.0, 0.0, speed), rotY, 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public int animationCooldown(String anim) {
        if (TELEPORT.equals(anim)) {
            return 7 + this.method_59922().method_43048(6);
        }
        return super.animationCooldown(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Sarcophagus> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.FIRE_CIRCLE.get())) {
                    this.getAnimationHandler().setAnimation(FIRE_CIRCLE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.MISSILE_8X.get())) {
                    this.getAnimationHandler().setAnimation(MISSILE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.LIGHT_BEAM.get())) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        }
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (this.forceSetNextAttack != null) {
            return other.equals(this.forceSetNextAttack);
        }
        if (!this.teleported) {
            return TELEPORT.equals(other);
        }
        return !TELEPORT.equals(other) && !this.previousAttack.equals(other);
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT, TELEPORT, STARFALL})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    public boolean method_5727(double x, double y, double z) {
        if (this.isTeleporting()) {
            return false;
        }
        return super.method_5727(x, y, z);
    }

    private boolean isTeleporting() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        if (anim == null) {
            return false;
        }
        if (anim.is(new String[]{TELEPORT})) {
            if (anim.isPast("teleport_start_1") && !anim.isPast("teleport_end_1")) {
                return true;
            }
            if (anim.isPast("teleport_start_2") && !anim.isPast("teleport_end_2")) {
                return true;
            }
            return anim.isPast("teleport_start_3") && !anim.isPast("teleport_end_3");
        }
        if (anim.is(new String[]{STARFALL})) {
            return anim.isPast("teleport_start") && !anim.isPast("teleport_end");
        }
        return false;
    }

    private void teleportAround(int range, int yRange) {
        class_243 pos = this.method_18410() ? class_243.method_24953((class_2382)this.method_18412()) : (this.method_5968() != null ? this.method_5968().method_19538() : this.method_19538());
        for (int i = 0; i < 10; ++i) {
            double x = pos.method_10216() + (this.method_59922().method_43058() * 2.0 - 1.0) * (double)range;
            double y = pos.method_10214() + 4.0;
            double z = pos.method_10215() + (this.method_59922().method_43058() * 2.0 - 1.0) * (double)range;
            if (this.method_18410() && this.method_18412().method_10268(x, y, z) > (double)(this.method_18413() * this.method_18413()) || !this.teleport(x, y, z, yRange)) continue;
            return;
        }
    }

    private boolean teleport(double x, double y, double z, int yRange) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y - 1.0, z);
        class_2791 chunk = this.method_37908().method_22350((class_2338)pos);
        while (yRange > 0 && pos.method_10264() > this.method_37908().method_31607() && !chunk.method_8320((class_2338)pos).method_51366()) {
            pos.method_10098(class_2350.field_11033);
            --yRange;
            y -= 1.0;
        }
        class_2680 blockState = chunk.method_8320((class_2338)pos);
        if (!blockState.method_51366()) {
            return false;
        }
        class_243 current = this.method_19538();
        this.method_5859(x, y, z);
        if (!this.method_37908().method_17892((class_1297)this) || this.method_37908().method_22345(this.method_5829())) {
            this.method_5859(current.method_10216(), current.method_10214(), current.method_10215());
            return false;
        }
        return true;
    }

    public class_243 getChargeMotion() {
        return (class_243)this.getDataContainer().get(CHARGE_MOTION);
    }

    protected void setChargeDirection(class_243 moveDirection) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)moveDirection);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

