/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.SanoUno;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Sano;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.DoubleWaterLaserSpell;
import io.github.flemmli97.runecraftory.common.spells.IceBallDropSpell;
import io.github.flemmli97.runecraftory.common.spells.IceTrailSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSwipe;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_5575;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class Uno
extends SanoUno {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String WATER_LASER = BUILDER.add("water_laser", AnimationsBuilder.definition((double)2.0).marker("attack_1", new double[]{0.8}).marker("attack_2", new double[]{1.2}));
    public static final String WATER_LASER_2 = BUILDER.add("water_swipe", AnimationsBuilder.definition((double)2.0).marker("attack_1", new double[]{0.8}).marker("attack_2", new double[]{1.6}));
    public static final String ICEBALLS_5 = BUILDER.add("iceballs", AnimationsBuilder.definition((double)3.0).marker("attack", new double[]{0.8, 1.2, 1.6, 2.0, 2.4}));
    public static final String HOMING_WATER_WAVE = BUILDER.add("water_wave", AnimationsBuilder.definition((double)2.0).marker("attack", new double[]{0.8}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Uno>> ATTACK_HANDLER = Uno.createAnimationHandler(b -> {
        b.put((Object)WATER_LASER, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                ((WaterLaserSpell)RuneCraftorySpells.WATER_LASER_LONG.get()).use((class_1309)entity);
            }
            if (anim.isAt("attack_2")) {
                ((DoubleWaterLaserSpell)RuneCraftorySpells.PARALLEL_LASER_LONG.get()).use((class_1309)entity);
            }
        });
        b.put((Object)WATER_LASER_2, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.reversedSwipe = false;
                ((WaterLaserSwipe)RuneCraftorySpells.WATER_SWIPE.get()).use((class_1309)entity);
            }
            if (anim.isAt("attack_2")) {
                entity.reversedSwipe = true;
                ((WaterLaserSwipe)RuneCraftorySpells.WATER_SWIPE.get()).use((class_1309)entity);
            }
        });
        b.put((Object)ICEBALLS_5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((IceBallDropSpell)RuneCraftorySpells.ICE_BALL_DROP.get()).use((class_1309)entity);
            }
        });
        b.put((Object)HOMING_WATER_WAVE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((IceTrailSpell)RuneCraftorySpells.ICE_TRAIL.get()).use((class_1309)entity);
            }
        });
    });
    private final AnimationHandler<Uno> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private Sano other;

    public Uno(class_1299<? extends Uno> type, class_1937 level) {
        super((class_1299<? extends SanoUno>)type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(WATER_LASER)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).start(MonsterBehaviourUtils.checkedAttack(WATER_LASER_2)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).start(MonsterBehaviourUtils.checkedAttack(ICEBALLS_5)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).start(MonsterBehaviourUtils.checkedAttack(HOMING_WATER_WAVE)).play(MonsterBehaviourUtils.cooldownedPlay()).end(10).build();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Uno> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.ICE_BALL_DROP.get())) {
                    this.getAnimationHandler().setAnimation(ICEBALLS_5);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.PARALLEL_LASER.get())) {
                    this.getAnimationHandler().setAnimation(WATER_LASER_2);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), (Spell)RuneCraftorySpells.WATER_LASER.get())) {
                this.getAnimationHandler().setAnimation(WATER_LASER);
            }
        }
    }

    @Override
    public Sano getLinked() {
        List results;
        if (this.other != null && !this.other.method_31481()) {
            return this.other;
        }
        if (this.getLinkedID() != null && !(results = this.method_37908().method_18023(class_5575.method_31795(Sano.class), this.method_5829().method_1014(64.0), e -> this.getLinkedID().equals(e.getLinkedID()))).isEmpty()) {
            this.other = (Sano)results.getFirst();
        }
        return this.other;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

