/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaFlower;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaHorseTail;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaPart;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaPitcher;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.RafflesiaBreathSpell;
import io.github.flemmli97.runecraftory.common.spells.RafflesiaCircleSpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeCircle;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_11;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import org.jetbrains.annotations.Nullable;

public class Rafflesia
extends BossMonster {
    private static final class_2940<Optional<UUID>> HORSE_TAIL = class_2945.method_12791(Rafflesia.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> FLOWER = class_2945.method_12791(Rafflesia.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> PITCHER = class_2945.method_12791(Rafflesia.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_2350> SPAWN_DIRECTION = class_2945.method_12791(Rafflesia.class, (class_2941)class_2943.field_13321);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String POISON_BREATH = BUILDER.add("breath", AnimationsBuilder.definition((double)1.96).marker("attack", new double[]{0.56}));
    public static final String POISON_BREATH_REV = BUILDER.add("breath_2", POISON_BREATH);
    public static final String PARA_BREATH = BUILDER.add("paralysis_breath", POISON_BREATH);
    public static final String PARA_BREATH_REV = BUILDER.add("paralysis_breath_2", POISON_BREATH);
    public static final String SLEEP_BREATH = BUILDER.add("sleep_breath", POISON_BREATH);
    public static final String SLEEP_BREATH_REV = BUILDER.add("sleep_breath_2", POISON_BREATH);
    public static final String INTERACT = BUILDER.add("interact", POISON_BREATH);
    public static final String WIND_BLADE_X8 = BUILDER.add("casting", AnimationsBuilder.definition((double)1.24).marker("attack", new double[]{0.72}));
    public static final String WIND_BLADE_X16 = BUILDER.add("wind_blade_x16", WIND_BLADE_X8);
    public static final String RESUMMON = BUILDER.add("resummon", WIND_BLADE_X8);
    public static final String STATUS_CIRCLE = BUILDER.add("status_circle", WIND_BLADE_X8);
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.32}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.32}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Rafflesia>> ATTACK_HANDLER = Rafflesia.createAnimationHandler(b -> {
        BiConsumer<AnimationState, Rafflesia> cons = (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.useAttack((AnimationState)anim);
            }
        };
        b.put((Object)POISON_BREATH, cons);
        b.put((Object)PARA_BREATH, cons);
        b.put((Object)SLEEP_BREATH, cons);
        b.put((Object)POISON_BREATH_REV, cons);
        b.put((Object)PARA_BREATH_REV, cons);
        b.put((Object)SLEEP_BREATH_REV, cons);
        b.put((Object)WIND_BLADE_X8, cons);
        b.put((Object)WIND_BLADE_X16, cons);
        b.put((Object)RESUMMON, cons);
        b.put((Object)STATUS_CIRCLE, cons);
        BiConsumer<AnimationState, Rafflesia> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playRandomizedSound((class_3414)RuneCraftorySounds.ENTITY_RAFFLESIA_ANGRY.get());
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private boolean mirrorAttack;
    private final AnimationHandler<Rafflesia> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            this.mirrorAttack = Rafflesia.isMirrorAttack(anim);
        }
        return false;
    });
    private RafflesiaPart horseTailEntity;
    private RafflesiaPart flowerEntity;
    private RafflesiaPart pitcherEntity;
    private int summonCooldown = 100;

    public Rafflesia(class_1299<? extends Rafflesia> type, class_1937 level) {
        super((class_1299<? extends BossMonster>)type, level);
    }

    public static boolean isMirrorAttack(AnimationDefinition anim) {
        return anim != null && anim.is(new String[]{POISON_BREATH_REV, PARA_BREATH_REV, SLEEP_BREATH_REV});
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.RAFFLESIA.getID(), this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).setMusic((class_3414)RuneCraftorySounds.RAFFLESIA_FIGHT.get());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HORSE_TAIL, Optional.empty());
        builder.method_56912(FLOWER, Optional.empty());
        builder.method_56912(PITCHER, Optional.empty());
        builder.method_56912(SPAWN_DIRECTION, (Object)class_2350.field_11043);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new class_1409(this, (class_1308)this, level){

            @Nullable
            protected class_11 method_18416(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return null;
            }
        };
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(POISON_BREATH)).play(MonsterBehaviourUtils.cooldownedPlay()).end(6).start(MonsterBehaviourUtils.checkedAttack(POISON_BREATH_REV)).play(MonsterBehaviourUtils.cooldownedPlay()).end(6).start(MonsterBehaviourUtils.checkedAttack(PARA_BREATH)).play(MonsterBehaviourUtils.cooldownedPlay()).end(6).start(MonsterBehaviourUtils.checkedAttack(PARA_BREATH_REV)).play(MonsterBehaviourUtils.cooldownedPlay()).end(6).start(MonsterBehaviourUtils.checkedAttack(SLEEP_BREATH)).play(MonsterBehaviourUtils.cooldownedPlay()).end(6).start(MonsterBehaviourUtils.checkedAttack(SLEEP_BREATH_REV)).play(MonsterBehaviourUtils.cooldownedPlay()).end(6).start(MonsterBehaviourUtils.checkedAttack(WIND_BLADE_X8)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged()).end(6).start(MonsterBehaviourUtils.checkedAttack(WIND_BLADE_X16)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(BossMonster::isEnraged).end(6).start(MonsterBehaviourUtils.checkedAttack(RESUMMON)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(Rafflesia::noPartsLeft).end(7).build();
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            if (this.summonCooldown < 200 && this.getHorseTail() == null || this.getPitcher() == null || this.getFlower() == null) {
                this.summonCooldown = this.field_5974.method_43048(200) + 300;
            }
            if (this.field_6012 % 30 == 0) {
                this.method_37908().method_18023(class_5575.method_31795(class_1309.class), this.method_5829().method_1014(0.3).method_989(0.0, (double)this.method_17682(), 0.0), e -> e != this && this.targetPred.test(e)).forEach(e -> {
                    class_243 dir = e.method_19538().method_1020(this.method_19538());
                    boolean none = dir.method_10216() == 0.0 && dir.method_10215() == 0.0;
                    dir = new class_243(none ? 1.0 : dir.method_10216(), 0.0, dir.method_10215()).method_1029().method_1021(1.2);
                    e.method_18799(e.method_18798().method_1019(dir));
                    e.field_6037 = true;
                });
            }
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        class_1309 target = this.method_5968();
        if (target != null && !this.getAnimationHandler().hasAnimation()) {
            return target.method_33571().method_1020(this.method_33571());
        }
        return super.directionToLookAt();
    }

    @Override
    protected float[] targetLookClamp() {
        return new float[]{30.0f, 30.0f};
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        ((Optional)this.field_6011.method_12789(HORSE_TAIL)).ifPresent(uuid -> compound.method_25927("HeadBones", uuid));
        ((Optional)this.field_6011.method_12789(FLOWER)).ifPresent(uuid -> compound.method_25927("Flower", uuid));
        ((Optional)this.field_6011.method_12789(PITCHER)).ifPresent(uuid -> compound.method_25927("Pitcher", uuid));
        compound.method_10569("SpawnDirection", ((class_2350)this.field_6011.method_12789(SPAWN_DIRECTION)).ordinal());
        compound.method_10569("SummonCooldown", this.summonCooldown);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_25928("HorseTail")) {
            this.field_6011.method_12778(HORSE_TAIL, Optional.of(compound.method_25926("HorseTail")));
        }
        if (compound.method_25928("Flower")) {
            this.field_6011.method_12778(FLOWER, Optional.of(compound.method_25926("Flower")));
        }
        if (compound.method_25928("Pitcher")) {
            this.field_6011.method_12778(PITCHER, Optional.of(compound.method_25926("Pitcher")));
        }
        try {
            this.field_6011.method_12778(SPAWN_DIRECTION, (Object)class_2350.values()[compound.method_10550("SpawnDirection")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.summonCooldown = compound.method_10550("SummonCooldown");
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        this.field_6011.method_12778(SPAWN_DIRECTION, (Object)this.method_5735());
        this.respawnParts();
        return super.method_5943(level, difficulty, reason, spawnData);
    }

    private boolean noPartsLeft() {
        return this.getHorseTail() == null || this.getPitcher() == null || this.getFlower() == null;
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        class_1309 target = this.method_5968();
        if (target != null) {
            this.setTargetPosition(target);
        } else {
            this.setTargetPosition(TargetPosition.of((class_243)this.method_19538().method_1019(this.method_5828(1.0f).method_1021(5.0))));
        }
    }

    public void useAttack(AnimationState anim) {
        if (anim.is(new String[]{RESUMMON})) {
            this.respawnParts();
        }
        if (anim.is(new String[]{WIND_BLADE_X8})) {
            ((WindBladeCircle)RuneCraftorySpells.WIND_CIRCLE_X8.get()).use((class_1309)this);
        }
        if (anim.is(new String[]{WIND_BLADE_X16})) {
            ((WindBladeCircle)RuneCraftorySpells.WIND_CIRCLE_X16.get()).use((class_1309)this);
        }
        if (anim.is(new String[]{POISON_BREATH, POISON_BREATH_REV})) {
            ((RafflesiaBreathSpell)RuneCraftorySpells.RAFFLESIA_POISON.get()).use((class_1309)this);
        }
        if (anim.is(new String[]{PARA_BREATH, PARA_BREATH_REV})) {
            ((RafflesiaBreathSpell)RuneCraftorySpells.RAFFLESIA_PARA.get()).use((class_1309)this);
        }
        if (anim.is(new String[]{SLEEP_BREATH, SLEEP_BREATH_REV})) {
            ((RafflesiaBreathSpell)RuneCraftorySpells.RAFFLESIA_SLEEP.get()).use((class_1309)this);
        }
        if (anim.is(new String[]{STATUS_CIRCLE})) {
            ((RafflesiaCircleSpell)RuneCraftorySpells.RAFFLESIA_CIRCLE.get()).use((class_1309)this);
        }
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public int animationCooldown(String anim) {
        return super.animationCooldown(anim) + 5;
    }

    public AnimationHandler<Rafflesia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 1 ? (Spell)RuneCraftorySpells.RAFFLESIA_POISON.get() : (Spell)RuneCraftorySpells.RAFFLESIA_PARA.get())) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(POISON_BREATH);
            } else {
                this.getAnimationHandler().setAnimation(PARA_BREATH);
            }
        }
    }

    private void respawnParts() {
        class_2350 dir = (class_2350)this.field_6011.method_12789(SPAWN_DIRECTION);
        if (this.getHorseTail() == null) {
            RafflesiaHorseTail horseTail = new RafflesiaHorseTail(this.method_37908(), this);
            horseTail.setSpawnDirection(dir);
            horseTail.method_33574(this.method_19538().method_1019(Rafflesia.rotateVec(dir, horseTail.offset())));
            this.method_37908().method_8649((class_1297)horseTail);
            this.field_6011.method_12778(HORSE_TAIL, Optional.of(horseTail.method_5667()));
        }
        if (this.getFlower() == null) {
            RafflesiaFlower flower = new RafflesiaFlower(this.method_37908(), this);
            flower.setSpawnDirection(dir);
            flower.method_33574(this.method_19538().method_1019(Rafflesia.rotateVec(dir, flower.offset())));
            this.method_37908().method_8649((class_1297)flower);
            this.field_6011.method_12778(FLOWER, Optional.of(flower.method_5667()));
        }
        if (this.getPitcher() == null) {
            RafflesiaPitcher pitcher = new RafflesiaPitcher(this.method_37908(), this);
            pitcher.setSpawnDirection(dir);
            pitcher.method_33574(this.method_19538().method_1019(Rafflesia.rotateVec(dir, pitcher.offset())));
            this.method_37908().method_8649((class_1297)pitcher);
            this.field_6011.method_12778(PITCHER, Optional.of(pitcher.method_5667()));
        }
        this.summonCooldown = this.field_5974.method_43048(200) + 300;
    }

    public RafflesiaPart getHorseTail() {
        UUID uuid = ((Optional)this.field_6011.method_12789(HORSE_TAIL)).orElse(null);
        if (uuid != null) {
            if (this.horseTailEntity == null) {
                this.horseTailEntity = (RafflesiaPart)EntityUtils.findFromUUID(RafflesiaPart.class, (class_1937)this.method_37908(), (UUID)uuid);
            } else if (this.horseTailEntity.method_31481()) {
                this.horseTailEntity = null;
                this.field_6011.method_12778(HORSE_TAIL, Optional.empty());
            }
        } else {
            this.horseTailEntity = null;
        }
        return this.horseTailEntity;
    }

    public static class_243 rotateVec(class_2350 dir, class_243 v) {
        return switch (dir) {
            case class_2350.field_11043 -> v.method_18805(-1.0, 1.0, -1.0);
            case class_2350.field_11034 -> new class_243(v.method_10215(), v.method_10214(), -v.method_10216());
            case class_2350.field_11039 -> new class_243(-v.method_10215(), v.method_10214(), -v.method_10216());
            default -> v;
        };
    }

    public RafflesiaPart getFlower() {
        UUID uuid = ((Optional)this.field_6011.method_12789(FLOWER)).orElse(null);
        if (uuid != null) {
            if (this.flowerEntity == null) {
                this.flowerEntity = (RafflesiaPart)EntityUtils.findFromUUID(RafflesiaPart.class, (class_1937)this.method_37908(), (UUID)uuid);
            } else if (this.flowerEntity.method_31481()) {
                this.flowerEntity = null;
                this.field_6011.method_12778(FLOWER, Optional.empty());
            }
        } else {
            this.flowerEntity = null;
        }
        return this.flowerEntity;
    }

    public RafflesiaPart getPitcher() {
        UUID uuid = ((Optional)this.field_6011.method_12789(PITCHER)).orElse(null);
        if (uuid != null) {
            if (this.pitcherEntity == null) {
                this.pitcherEntity = (RafflesiaPart)EntityUtils.findFromUUID(RafflesiaPart.class, (class_1937)this.method_37908(), (UUID)uuid);
            } else if (this.pitcherEntity.method_31481()) {
                this.pitcherEntity = null;
                this.field_6011.method_12778(PITCHER, Optional.empty());
            }
        } else {
            this.pitcherEntity = null;
        }
        return this.pitcherEntity;
    }

    public boolean method_30948() {
        return true;
    }

    public class_2350 getSpawnDirection() {
        return (class_2350)this.field_6011.method_12789(SPAWN_DIRECTION);
    }

    public boolean mirrorAttack() {
        return this.mirrorAttack;
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)RuneCraftorySounds.ENTITY_RAFFLESIA_DEATH.get();
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return DEFEAT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

