/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import io.github.flemmli97.runecraftory.common.entities.ai.goal.RafflesiaPartAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.Rafflesia;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;

public abstract class RafflesiaPart
extends class_1308
implements AnimatedEntity,
class_6025 {
    private static final class_2940<Optional<UUID>> PARENT = class_2945.method_12791(RafflesiaPart.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_2350> SPAWN_DIRECTION = class_2945.method_12791(RafflesiaPart.class, (class_2941)class_2943.field_13321);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String HORSE_TAIL_ACTION = BUILDER.add("horse_tail_action", AnimationsBuilder.definition((double)1.28).marker("attack", new double[]{0.56}));
    public static final String FLOWER_ACTION = BUILDER.add("flower_action", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.4456}));
    public static final String PITCHER_ACTION = BUILDER.add("pitcher_action", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.4}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public final RafflesiaPartAttackGoal attack = new RafflesiaPartAttackGoal(this);
    private Rafflesia parent;

    public RafflesiaPart(class_1299<? extends class_1308> entityType, class_1937 level, Rafflesia parent) {
        this(entityType, level);
        this.parent = parent;
        this.field_6011.method_12778(PARENT, Optional.of(this.parent.method_5667()));
        this.method_6127().method_26850(parent.method_6127().method_26855());
        double health = parent.method_45325(class_5134.field_23716) * 0.33;
        this.method_5996(class_5134.field_23716).method_6192(health);
        this.method_6033(this.method_6063());
    }

    public RafflesiaPart(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
        if (!level.field_9236) {
            this.field_6201.method_6277(1, (class_1352)this.attack);
        }
    }

    public static class_5132.class_5133 createAttributes() {
        class_5132.class_5133 map = class_1588.method_26918().method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23717, 32.0);
        for (RegistryEntrySupplier<class_1320, ?> att : RuneCraftoryAttributes.ENTITY_ATTRIBUTES) {
            map.method_26867(att.asHolder());
        }
        return map;
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1409(this, this, level){

            @Nullable
            protected class_11 method_18416(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return null;
            }
        };
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PARENT, Optional.empty());
        builder.method_56912(SPAWN_DIRECTION, (Object)class_2350.field_11043);
    }

    public void method_5670() {
        if (!this.method_37908().field_9236 && !this.field_5953) {
            if (this.getOwner() != null) {
                if (this.getOwner().method_29504() || this.getPartType().getPart.apply(this.getOwner()) != this) {
                    this.method_31472();
                } else {
                    if (this.method_5968() != this.getOwner().method_5968()) {
                        this.method_5980(this.getOwner().method_5968());
                    }
                    this.method_33574(this.getOwner().method_19538().method_1019(Rafflesia.rotateVec((class_2350)this.field_6011.method_12789(SPAWN_DIRECTION), this.offset())));
                }
            } else if (this.method_6139() == null) {
                this.method_31472();
            }
        }
        super.method_5670();
        this.getAnimationHandler().tick();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        ((Optional)this.field_6011.method_12789(PARENT)).ifPresent(uuid -> compound.method_25927("Parent", uuid));
        compound.method_10569("SpawnDirection", ((class_2350)this.field_6011.method_12789(SPAWN_DIRECTION)).ordinal());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_25928("Parent")) {
            this.field_6011.method_12778(PARENT, Optional.of(compound.method_25926("Parent")));
        }
        try {
            this.field_6011.method_12778(SPAWN_DIRECTION, (Object)class_2350.values()[compound.method_10550("SpawnDirection")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public abstract PartType getPartType();

    public abstract class_243 offset();

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(PARENT)).orElse(null);
    }

    @Nullable
    public Rafflesia getOwner() {
        UUID uuid = this.method_6139();
        if (uuid != null) {
            if (this.parent == null || !this.parent.method_5805()) {
                this.parent = (Rafflesia)EntityUtils.findFromUUID(Rafflesia.class, (class_1937)this.method_37908(), (UUID)uuid);
            }
        } else {
            this.parent = null;
        }
        return this.parent;
    }

    public void setSpawnDirection(class_2350 direction) {
        this.field_6011.method_12778(SPAWN_DIRECTION, (Object)direction);
    }

    public boolean method_30948() {
        return true;
    }

    public abstract String attackAnim();

    public int cooldown() {
        return this.method_59922().method_43048(40) + 100;
    }

    public static enum PartType {
        FLOWER(Rafflesia::getFlower),
        HORSETAIL(Rafflesia::getHorseTail),
        PITCHER(Rafflesia::getPitcher);

        private final Function<Rafflesia, class_1297> getPart;

        private PartType(Function<Rafflesia, class_1297> getPart) {
            this.getPart = getPart;
        }
    }
}

